/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.zaxxer.hikari.proxy;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import shaded.com.zaxxer.hikari.proxy.ConnectionProxy;
import shaded.com.zaxxer.hikari.proxy.ProxyFactory;
import shaded.com.zaxxer.hikari.proxy.StatementProxy;

public abstract class PreparedStatementProxy
extends StatementProxy
implements PreparedStatement {
    protected PreparedStatementProxy(ConnectionProxy connection, PreparedStatement statement) {
        super(connection, statement);
    }

    @Override
    public boolean execute() throws SQLException {
        this.connection.markCommitStateDirty();
        return ((PreparedStatement)this.delegate).execute();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.connection.markCommitStateDirty();
        ResultSet resultSet = ((PreparedStatement)this.delegate).executeQuery();
        return ProxyFactory.getProxyResultSet(this.connection, resultSet);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.connection.markCommitStateDirty();
        return ((PreparedStatement)this.delegate).executeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.connection.markCommitStateDirty();
        return ((PreparedStatement)this.delegate).executeLargeUpdate();
    }
}

