/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.zaxxer.hikari.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.zaxxer.hikari.HikariConfig;
import shaded.com.zaxxer.hikari.util.DefaultThreadFactory;
import shaded.com.zaxxer.hikari.util.DriverDataSource;
import shaded.com.zaxxer.hikari.util.PropertyBeanSetter;
import shaded.com.zaxxer.hikari.util.UtilityElf;

public final class PoolUtilities {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolUtilities.class);
    private Executor netTimeoutExecutor;
    private String poolName;
    private volatile boolean isValidChecked;
    private volatile boolean isValidSupported;
    private boolean isNetworkTimeoutSupported;
    private boolean isQueryTimeoutSupported;

    public PoolUtilities(HikariConfig configuration) {
        this.poolName = configuration.getPoolName();
        this.isValidSupported = true;
        this.isNetworkTimeoutSupported = true;
        this.isQueryTimeoutSupported = true;
    }

    public void quietlyCloseConnection(Connection connection, String closureReason) {
        try {
            if (connection == null || connection.isClosed()) {
                return;
            }
            LOGGER.debug("Closing connection {} in pool {} {}", new Object[]{connection, this.poolName, closureReason});
            try {
                this.setNetworkTimeout(connection, TimeUnit.SECONDS.toMillis(15L));
            }
            finally {
                connection.close();
            }
        }
        catch (Throwable e) {
            LOGGER.debug("Exception closing connection {} in pool {} {}", new Object[]{connection, this.poolName, closureReason, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSql(Connection connection, String sql, boolean isAutoCommit) throws SQLException {
        if (sql != null) {
            try (Statement statement = connection.createStatement();){
                statement.execute(sql);
                if (!isAutoCommit) {
                    connection.commit();
                }
            }
        }
    }

    public DataSource initializeDataSource(String dsClassName, DataSource dataSource, Properties dataSourceProperties, String driverClassName, String jdbcUrl, String username, String password) {
        if (dsClassName != null && dataSource == null) {
            dataSource = UtilityElf.createInstance(dsClassName, DataSource.class, new Object[0]);
            PropertyBeanSetter.setTargetFromProperties(dataSource, dataSourceProperties);
        } else if (jdbcUrl != null && dataSource == null) {
            dataSource = new DriverDataSource(jdbcUrl, driverClassName, dataSourceProperties, username, password);
        }
        if (dataSource != null) {
            this.createNetworkTimeoutExecutor(dataSource, dsClassName, jdbcUrl);
        }
        return dataSource;
    }

    public void setupConnection(Connection connection, boolean isAutoCommit, boolean isReadOnly, int transactionIsolation, String catalog) throws SQLException {
        connection.setAutoCommit(isAutoCommit);
        try {
            connection.setReadOnly(isReadOnly);
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        if (transactionIsolation != connection.getTransactionIsolation()) {
            connection.setTransactionIsolation(transactionIsolation);
        }
        if (catalog != null) {
            connection.setCatalog(catalog);
        }
    }

    public boolean isJdbc4ValidationSupported(Connection connection) {
        if (!this.isValidChecked) {
            try {
                connection.isValid(5);
            }
            catch (Throwable e) {
                this.isValidSupported = false;
                LOGGER.debug("{} - JDBC4 Connection.isValid() not supported", (Object)this.poolName);
            }
            this.isValidChecked = true;
        }
        return this.isValidSupported;
    }

    public void setQueryTimeout(Statement statement, int timeoutSec) {
        if (this.isQueryTimeoutSupported) {
            try {
                statement.setQueryTimeout(timeoutSec);
            }
            catch (Throwable e) {
                this.isQueryTimeoutSupported = false;
                LOGGER.debug("{} - Statement.setQueryTimeout() not supported", (Object)this.poolName);
            }
        }
    }

    public int getAndSetNetworkTimeout(Connection connection, long timeoutMs) {
        if (this.isNetworkTimeoutSupported) {
            try {
                int networkTimeout = connection.getNetworkTimeout();
                connection.setNetworkTimeout(this.netTimeoutExecutor, (int)timeoutMs);
                return networkTimeout;
            }
            catch (Throwable e) {
                this.isNetworkTimeoutSupported = false;
                LOGGER.debug("{} - Connection.setNetworkTimeout() not supported", (Object)this.poolName);
            }
        }
        return 0;
    }

    public void setNetworkTimeout(Connection connection, long timeoutMs) {
        if (this.isNetworkTimeoutSupported) {
            try {
                connection.setNetworkTimeout(this.netTimeoutExecutor, (int)timeoutMs);
            }
            catch (Throwable e) {
                LOGGER.debug("Unable to reset network timeout for connection {} in pool {}", new Object[]{connection.toString(), this.poolName, e});
            }
        }
    }

    public void setLoginTimeout(DataSource dataSource, long connectionTimeout) {
        if (connectionTimeout != Integer.MAX_VALUE) {
            try {
                dataSource.setLoginTimeout((int)TimeUnit.MILLISECONDS.toSeconds(Math.max(1000L, connectionTimeout)));
            }
            catch (SQLException e) {
                LOGGER.warn("Unable to set DataSource login timeout", (Throwable)e);
            }
        }
    }

    private void createNetworkTimeoutExecutor(DataSource dataSource, String dsClassName, String jdbcUrl) {
        if (dsClassName != null && dsClassName.contains("Mysql") || jdbcUrl != null && jdbcUrl.contains("mysql") || dataSource != null && dataSource.getClass().getName().contains("Mysql")) {
            this.netTimeoutExecutor = new SynchronousExecutor();
        } else {
            this.netTimeoutExecutor = Executors.newCachedThreadPool(new DefaultThreadFactory("Hikari JDBC Timeout Executor", true));
            ((ThreadPoolExecutor)this.netTimeoutExecutor).allowCoreThreadTimeOut(true);
        }
    }

    private static class SynchronousExecutor
    implements Executor {
        private SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            try {
                command.run();
            }
            catch (Throwable t) {
                LOGGER.debug("Exception executing {}", (Object)command.toString(), (Object)t);
            }
        }
    }
}

