/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.zaxxer.hikari.pool;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.zaxxer.hikari.HikariConfig;
import shaded.com.zaxxer.hikari.pool.BaseHikariPool;

public final class HikariMBeanElf {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariMBeanElf.class);

    private HikariMBeanElf() {
    }

    public static void registerMBeans(HikariConfig configuration, BaseHikariPool pool) {
        if (!configuration.isRegisterMbeans()) {
            return;
        }
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName poolConfigName = new ObjectName("shaded.com.zaxxer.hikari:type=PoolConfig (" + configuration.getPoolName() + ")");
            ObjectName poolName = new ObjectName("shaded.com.zaxxer.hikari:type=Pool (" + configuration.getPoolName() + ")");
            if (!mBeanServer.isRegistered(poolConfigName)) {
                mBeanServer.registerMBean(configuration, poolConfigName);
                mBeanServer.registerMBean(pool, poolName);
            } else {
                LOGGER.error("You cannot use the same pool name for separate pool instances.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to register management beans.", (Throwable)e);
        }
    }

    public static void unregisterMBeans(HikariConfig configuration, BaseHikariPool pool) {
        if (!configuration.isRegisterMbeans()) {
            return;
        }
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName poolConfigName = new ObjectName("shaded.com.zaxxer.hikari:type=PoolConfig (" + configuration.getPoolName() + ")");
            ObjectName poolName = new ObjectName("shaded.com.zaxxer.hikari:type=Pool (" + configuration.getPoolName() + ")");
            if (mBeanServer.isRegistered(poolConfigName)) {
                mBeanServer.unregisterMBean(poolConfigName);
                mBeanServer.unregisterMBean(poolName);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to unregister management beans.", (Throwable)e);
        }
    }

    static {
        new HikariMBeanElf();
    }
}

