/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.utilities;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import mineverse.Aust1n46.chat.ClickAction;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.json.JsonAttribute;
import mineverse.Aust1n46.chat.json.JsonFormat;
import mineverse.Aust1n46.chat.localization.LocalizedMessage;
import mineverse.Aust1n46.chat.versions.VersionHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class Format {
    public static final int LEGACY_COLOR_CODE_LENGTH = 2;
    public static final int HEX_COLOR_CODE_LENGTH = 14;
    public static final String HEX_COLOR_CODE_PREFIX = "#";
    public static final char BUKKIT_COLOR_CODE_PREFIX_CHAR = '\u00a7';
    public static final String BUKKIT_COLOR_CODE_PREFIX = String.valueOf('\u00a7');
    public static final String BUKKIT_HEX_COLOR_CODE_PREFIX = "x";
    public static final String DEFAULT_COLOR_CODE = BUKKIT_COLOR_CODE_PREFIX + "f";
    private static final Pattern LEGACY_CHAT_COLOR_DIGITS_PATTERN = Pattern.compile("&([0-9])");
    private static final Pattern LEGACY_CHAT_COLOR_PATTERN = Pattern.compile("(?<!(&x(&[a-fA-F0-9]){5}))(?<!(&x(&[a-fA-F0-9]){4}))(?<!(&x(&[a-fA-F0-9]){3}))(?<!(&x(&[a-fA-F0-9]){2}))(?<!(&x(&[a-fA-F0-9]){1}))(?<!(&x))(&)([0-9a-fA-F])");
    private static final Pattern PLACEHOLDERAPI_PLACEHOLDER_PATTERN = Pattern.compile("\\{([^\\{\\}]+)\\}");
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    public static final long MILLISECONDS_PER_HOUR = 3600000L;
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    public static final long MILLISECONDS_PER_SECOND = 1000L;
    public static final String DEFAULT_MESSAGE_SOUND = "ENTITY_PLAYER_LEVELUP";
    public static final String DEFAULT_LEGACY_MESSAGE_SOUND = "LEVEL_UP";

    public static String convertToJson(MineverseChatPlayer sender, String format, String chat) {
        JsonFormat JSONformat = JsonFormat.getJsonFormat(sender.getJsonFormat());
        String c = Format.escapeJsonChars(chat);
        String json = "[\"\",{\"text\":\"\",\"extra\":[";
        json = json + Format.convertPlaceholders(format, JSONformat, sender);
        json = json + "]}";
        json = json + "," + Format.convertLinks(c);
        json = json + "]";
        if (MineverseChat.getInstance().getConfig().getString("loglevel", "info").equals("debug")) {
            System.out.println(json);
            System.out.println("END OF JSON");
            System.out.println("END OF JSON");
            System.out.println("END OF JSON");
            System.out.println("END OF JSON");
            System.out.println("END OF JSON");
        }
        return json;
    }

    private static String convertPlaceholders(String s, JsonFormat format, MineverseChatPlayer icp) {
        Matcher matcher;
        String remaining = s;
        String temp = "";
        int indexStart = -1;
        int indexEnd = -1;
        String placeholder = "";
        String formattedPlaceholder = "";
        String lastCode = DEFAULT_COLOR_CODE;
        while ((matcher = PLACEHOLDERAPI_PLACEHOLDER_PATTERN.matcher(remaining)).find()) {
            indexStart = matcher.start();
            indexEnd = matcher.end();
            placeholder = remaining.substring(indexStart, indexEnd);
            formattedPlaceholder = Format.escapeJsonChars(Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)icp.getPlayer(), (String)placeholder)));
            temp = temp + Format.convertToJsonColors(Format.escapeJsonChars(lastCode + remaining.substring(0, indexStart))) + ",";
            lastCode = Format.getLastCode(lastCode + remaining.substring(0, indexStart));
            boolean placeholderHasJsonAttribute = false;
            for (JsonAttribute jsonAttribute : format.getJsonAttributes()) {
                String actionJson;
                if (!placeholder.contains(jsonAttribute.getName().replace("{", "").replace("}", ""))) continue;
                StringBuilder hover = new StringBuilder();
                for (String st : jsonAttribute.getHoverText()) {
                    hover.append(Format.FormatStringAll(st) + "\n");
                }
                String hoverText = !hover.isEmpty() ? Format.escapeJsonChars(Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)icp.getPlayer(), (String)hover.substring(0, hover.length() - 1)))) : "";
                ClickAction clickAction = jsonAttribute.getClickAction();
                if (clickAction == ClickAction.NONE) {
                    actionJson = "";
                } else {
                    String clickText = Format.escapeJsonChars(Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)icp.getPlayer(), (String)jsonAttribute.getClickText())));
                    actionJson = ",\"clickEvent\":{\"action\":\"" + jsonAttribute.getClickAction().toString() + "\",\"value\":\"" + clickText + "\"}";
                }
                String hoverJson = hoverText.isEmpty() ? "" : ",\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[" + Format.convertToJsonColors(hoverText) + "]}}";
                temp = temp + Format.convertToJsonColors(lastCode + formattedPlaceholder, actionJson + hoverJson) + ",";
                placeholderHasJsonAttribute = true;
                break;
            }
            if (!placeholderHasJsonAttribute) {
                temp = temp + Format.convertToJsonColors(lastCode + formattedPlaceholder) + ",";
            }
            lastCode = Format.getLastCode(lastCode + formattedPlaceholder);
            remaining = remaining.substring(indexEnd);
        }
        temp = temp + Format.convertToJsonColors(lastCode + remaining);
        return temp;
    }

    private static String convertLinks(String s) {
        Pattern pattern;
        Matcher matcher;
        String remaining = s;
        String temp = "";
        int indexLink = -1;
        int indexLinkEnd = -1;
        String link = "";
        String lastCode = DEFAULT_COLOR_CODE;
        while ((matcher = (pattern = Pattern.compile("([a-zA-Z0-9" + BUKKIT_COLOR_CODE_PREFIX + "\\-:/]+\\.[a-zA-Z/0-9" + BUKKIT_COLOR_CODE_PREFIX + "\\-:_#]+(\\.[a-zA-Z/0-9." + BUKKIT_COLOR_CODE_PREFIX + "\\-:;,#\\?\\+=_]+)?)")).matcher(remaining)).find()) {
            indexLink = matcher.start();
            indexLinkEnd = matcher.end();
            link = remaining.substring(indexLink, indexLinkEnd);
            temp = temp + Format.convertToJsonColors(lastCode + remaining.substring(0, indexLink)) + ",";
            lastCode = Format.getLastCode(lastCode + remaining.substring(0, indexLink));
            String https = "";
            if (ChatColor.stripColor((String)link).contains("https://")) {
                https = "s";
            }
            temp = temp + Format.convertToJsonColors(lastCode + link, ",\"underlined\":" + Format.underlineURLs() + ",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"http" + https + "://" + ChatColor.stripColor((String)link.replace("http://", "").replace("https://", "")) + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[" + Format.convertToJsonColors(lastCode + link) + "]}}") + ",";
            lastCode = Format.getLastCode(lastCode + link);
            remaining = remaining.substring(indexLinkEnd);
        }
        temp = temp + Format.convertToJsonColors(lastCode + remaining);
        return temp;
    }

    public static String getLastCode(String s) {
        String ts = "";
        char[] ch = s.toCharArray();
        for (int a = 0; a < s.length() - 1; ++a) {
            if (String.valueOf(ch[a + 1]).matches("[lkomnLKOMN]") && ch[a] == '\u00a7') {
                ts = ts + String.valueOf(ch[a]) + ch[a + 1];
                ++a;
                continue;
            }
            if (String.valueOf(ch[a + 1]).matches("[0123456789abcdefrABCDEFR]") && ch[a] == '\u00a7') {
                ts = String.valueOf(ch[a]) + ch[a + 1];
                ++a;
                continue;
            }
            if (ch[a + 1] != 'x' || ch[a] != '\u00a7' || ch.length <= a + 13 || !String.valueOf(ch[a + 3]).matches("[0123456789abcdefABCDEF]") || !String.valueOf(ch[a + 5]).matches("[0123456789abcdefABCDEF]") || !String.valueOf(ch[a + 7]).matches("[0123456789abcdefABCDEF]") || !String.valueOf(ch[a + 9]).matches("[0123456789abcdefABCDEF]") || !String.valueOf(ch[a + 11]).matches("[0123456789abcdefABCDEF]") || !String.valueOf(ch[a + 13]).matches("[0123456789abcdefABCDEF]") || ch[a + 2] != '\u00a7' || ch[a + 4] != '\u00a7' || ch[a + 6] != '\u00a7' || ch[a + 8] != '\u00a7' || ch[a + 10] != '\u00a7' || ch[a + 12] != '\u00a7') continue;
            ts = String.valueOf(ch[a]) + ch[a + 1] + ch[a + 2] + ch[a + 3] + ch[a + 4] + ch[a + 5] + ch[a + 6] + ch[a + 7] + ch[a + 8] + ch[a + 9] + ch[a + 10] + ch[a + 11] + ch[a + 12] + ch[a + 13];
            a += 13;
        }
        return ts;
    }

    public static String convertToJsonColors(String s) {
        return Format.convertToJsonColors(s, "");
    }

    private static String convertToJsonColors(String s, String extensions) {
        String remaining = s;
        String temp = "";
        int indexColor = -1;
        int indexNextColor = -1;
        String color = "";
        String modifier = "";
        boolean bold = false;
        boolean obfuscated = false;
        boolean italic = false;
        boolean strikethrough = false;
        boolean underlined = false;
        String previousColor = "";
        int colorLength = 2;
        do {
            if (remaining.length() < 2) {
                temp = "{\"text\":\"" + remaining + "\"},";
                break;
            }
            modifier = "";
            indexColor = remaining.indexOf(BUKKIT_COLOR_CODE_PREFIX);
            previousColor = color;
            color = remaining.substring(1, indexColor + 2);
            if (color.equals(BUKKIT_HEX_COLOR_CODE_PREFIX)) {
                if (remaining.length() >= 14) {
                    color = HEX_COLOR_CODE_PREFIX + remaining.substring(2, indexColor + 14).replace(BUKKIT_COLOR_CODE_PREFIX, "");
                    colorLength = 14;
                    bold = false;
                    obfuscated = false;
                    italic = false;
                    strikethrough = false;
                    underlined = false;
                }
            } else if (!color.matches("[0123456789abcdefABCDEF]")) {
                switch (color) {
                    case "l": 
                    case "L": {
                        bold = true;
                        break;
                    }
                    case "k": 
                    case "K": {
                        obfuscated = true;
                        break;
                    }
                    case "o": 
                    case "O": {
                        italic = true;
                        break;
                    }
                    case "m": 
                    case "M": {
                        strikethrough = true;
                        break;
                    }
                    case "n": 
                    case "N": {
                        underlined = true;
                        break;
                    }
                    case "r": 
                    case "R": {
                        bold = false;
                        obfuscated = false;
                        italic = false;
                        strikethrough = false;
                        underlined = false;
                        color = "f";
                    }
                }
                if (!color.equals("f")) {
                    color = previousColor;
                }
                if (color.length() == 0) {
                    color = "f";
                }
            } else {
                bold = false;
                obfuscated = false;
                italic = false;
                strikethrough = false;
                underlined = false;
            }
            if (bold) {
                modifier = VersionHandler.isAtLeast_1_20_4() ? modifier + ",\"bold\":true" : modifier + ",\"bold\":\"true\"";
            }
            if (obfuscated) {
                modifier = VersionHandler.isAtLeast_1_20_4() ? modifier + ",\"obfuscated\":true" : modifier + ",\"obfuscated\":\"true\"";
            }
            if (italic) {
                modifier = VersionHandler.isAtLeast_1_20_4() ? modifier + ",\"italic\":true" : modifier + ",\"italic\":\"true\"";
            }
            if (underlined) {
                modifier = VersionHandler.isAtLeast_1_20_4() ? modifier + ",\"underlined\":true" : modifier + ",\"underlined\":\"true\"";
            }
            if (strikethrough) {
                modifier = VersionHandler.isAtLeast_1_20_4() ? modifier + ",\"strikethrough\":true" : modifier + ",\"strikethrough\":\"true\"";
            }
            remaining = remaining.substring(colorLength);
            colorLength = 2;
            indexNextColor = remaining.indexOf(BUKKIT_COLOR_CODE_PREFIX);
            if (indexNextColor == -1) {
                indexNextColor = remaining.length();
            }
            temp = temp + "{\"text\":\"" + remaining.substring(0, indexNextColor) + "\",\"color\":\"" + Format.hexidecimalToJsonColorRGB(color) + "\"" + modifier + extensions + "},";
        } while ((remaining = remaining.substring(indexNextColor)).length() > 1 && indexColor != -1);
        if (temp.length() > 1) {
            temp = temp.substring(0, temp.length() - 1);
        }
        return temp;
    }

    private static String hexidecimalToJsonColorRGB(String c) {
        if (c.length() == 1) {
            switch (c) {
                case "0": {
                    return "black";
                }
                case "1": {
                    return "dark_blue";
                }
                case "2": {
                    return "dark_green";
                }
                case "3": {
                    return "dark_aqua";
                }
                case "4": {
                    return "dark_red";
                }
                case "5": {
                    return "dark_purple";
                }
                case "6": {
                    return "gold";
                }
                case "7": {
                    return "gray";
                }
                case "8": {
                    return "dark_gray";
                }
                case "9": {
                    return "blue";
                }
                case "a": 
                case "A": {
                    return "green";
                }
                case "b": 
                case "B": {
                    return "aqua";
                }
                case "c": 
                case "C": {
                    return "red";
                }
                case "d": 
                case "D": {
                    return "light_purple";
                }
                case "e": 
                case "E": {
                    return "yellow";
                }
                case "f": 
                case "F": {
                    return "white";
                }
            }
            return "white";
        }
        if (Format.isValidHexColor(c)) {
            return c;
        }
        return "white";
    }

    public static String convertPlainTextToJson(String s, boolean convertURL) {
        s = Format.escapeJsonChars(s);
        if (convertURL) {
            return "[" + Format.convertLinks(s) + "]";
        }
        return "[" + Format.convertToJsonColors(DEFAULT_COLOR_CODE + s) + "]";
    }

    private static String escapeJsonChars(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static String formatModerationGUI(String json, Player player, String sender, String channelName, int hash) {
        if (player.hasPermission("venturechat.gui")) {
            json = json.substring(0, json.length() - 1);
            json = json + "," + Format.convertToJsonColors(Format.FormatStringAll(MineverseChat.getInstance().getConfig().getString("guiicon")), ",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/vchatgui " + sender + " " + channelName + " " + hash + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[" + Format.convertToJsonColors(Format.FormatStringAll(MineverseChat.getInstance().getConfig().getString("guitext"))) + "]}}") + "]";
        }
        return json;
    }

    public static PacketContainer createPacketPlayOutChat(String json) {
        PacketContainer container;
        if (VersionHandler.isAtLeast_1_20_4()) {
            container = new PacketContainer(PacketType.Play.Server.SYSTEM_CHAT);
            container.getChatComponents().write(0, (Object)WrappedChatComponent.fromJson((String)json));
            container.getBooleans().write(0, (Object)false);
        } else if (VersionHandler.isAbove_1_19()) {
            container = new PacketContainer(PacketType.Play.Server.SYSTEM_CHAT);
            container.getStrings().write(0, (Object)json);
            container.getBooleans().write(0, (Object)false);
        } else if (VersionHandler.isUnder_1_19()) {
            WrappedChatComponent component = WrappedChatComponent.fromJson((String)json);
            container = new PacketContainer(PacketType.Play.Server.CHAT);
            container.getModifier().writeDefaults();
            container.getChatComponents().write(0, (Object)component);
        } else {
            container = new PacketContainer(PacketType.Play.Server.SYSTEM_CHAT);
            container.getStrings().write(0, (Object)json);
            container.getIntegers().write(0, (Object)1);
        }
        return container;
    }

    public static PacketContainer createPacketPlayOutChat(WrappedChatComponent component) {
        PacketContainer container;
        if (VersionHandler.isAtLeast_1_20_4()) {
            container = new PacketContainer(PacketType.Play.Server.SYSTEM_CHAT);
            container.getChatComponents().write(0, (Object)component);
            container.getBooleans().write(0, (Object)false);
        } else if (VersionHandler.isAbove_1_19()) {
            container = new PacketContainer(PacketType.Play.Server.SYSTEM_CHAT);
            container.getStrings().write(0, (Object)component.getJson());
            container.getBooleans().write(0, (Object)false);
        } else if (VersionHandler.isUnder_1_19()) {
            container = new PacketContainer(PacketType.Play.Server.CHAT);
            container.getModifier().writeDefaults();
            container.getChatComponents().write(0, (Object)component);
        } else {
            container = new PacketContainer(PacketType.Play.Server.SYSTEM_CHAT);
            container.getStrings().write(0, (Object)component.getJson());
            container.getIntegers().write(0, (Object)1);
        }
        return container;
    }

    public static void sendPacketPlayOutChat(Player player, PacketContainer packet) {
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    public static String toColoredText(Object o, Class<?> c) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String toPlainText(Object o, Class<?> c) {
        ArrayList<Object> finalList = new ArrayList<Object>();
        StringBuilder stringbuilder = new StringBuilder();
        try {
            Format.splitComponents(finalList, o, c);
            for (Object e : finalList) {
                if (VersionHandler.is1_7()) {
                    stringbuilder.append((String)e.getClass().getMethod("e", new Class[0]).invoke(e, new Object[0]));
                    continue;
                }
                if (VersionHandler.is1_8() || VersionHandler.is1_9() || VersionHandler.is1_10() || VersionHandler.is1_11() || VersionHandler.is1_12() || VersionHandler.is1_13() || VersionHandler.is1_14() || VersionHandler.is1_15() || VersionHandler.is1_16() || VersionHandler.is1_17()) {
                    stringbuilder.append((String)e.getClass().getMethod("getText", new Class[0]).invoke(e, new Object[0]));
                    continue;
                }
                stringbuilder.append((String)e.getClass().getMethod("getString", new Class[0]).invoke(e, new Object[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stringbuilder.toString();
    }

    private static void splitComponents(List<Object> finalList, Object o, Class<?> c) throws Exception {
        if (VersionHandler.is1_7() || VersionHandler.is1_8() || VersionHandler.is1_9() || VersionHandler.is1_10() || VersionHandler.is1_11() || VersionHandler.is1_12() || VersionHandler.is1_13() || VersionHandler.is1_14() && !VersionHandler.is1_14_4()) {
            ArrayList list = (ArrayList)c.getMethod("a", new Class[0]).invoke(o, new Object[0]);
            for (Object component : list) {
                ArrayList innerList = (ArrayList)c.getMethod("a", new Class[0]).invoke(component, new Object[0]);
                if (innerList.size() > 0) {
                    Format.splitComponents(finalList, component, c);
                    continue;
                }
                finalList.add(component);
            }
        } else if (VersionHandler.is1_14_4() || VersionHandler.is1_15() || VersionHandler.is1_16() || VersionHandler.is1_17()) {
            ArrayList list = (ArrayList)c.getMethod("getSiblings", new Class[0]).invoke(o, new Object[0]);
            for (Object component : list) {
                ArrayList innerList = (ArrayList)c.getMethod("getSiblings", new Class[0]).invoke(component, new Object[0]);
                if (innerList.size() > 0) {
                    Format.splitComponents(finalList, component, c);
                    continue;
                }
                finalList.add(component);
            }
        } else {
            ArrayList list = (ArrayList)c.getMethod("b", new Class[0]).invoke(o, new Object[0]);
            for (Object component : list) {
                ArrayList innerList = (ArrayList)c.getMethod("b", new Class[0]).invoke(component, new Object[0]);
                if (innerList.size() > 0) {
                    Format.splitComponents(finalList, component, c);
                    continue;
                }
                finalList.add(component);
            }
        }
    }

    public static String FormatStringColor(String string) {
        String allFormated = string;
        allFormated = LEGACY_CHAT_COLOR_DIGITS_PATTERN.matcher(allFormated).replaceAll("\u00a7$1");
        allFormated = allFormated.replaceAll("&[x]", BUKKIT_COLOR_CODE_PREFIX + BUKKIT_HEX_COLOR_CODE_PREFIX);
        allFormated = allFormated.replaceAll("&[aA]", BUKKIT_COLOR_CODE_PREFIX + "a");
        allFormated = allFormated.replaceAll("&[bB]", BUKKIT_COLOR_CODE_PREFIX + "b");
        allFormated = allFormated.replaceAll("&[cC]", BUKKIT_COLOR_CODE_PREFIX + "c");
        allFormated = allFormated.replaceAll("&[dD]", BUKKIT_COLOR_CODE_PREFIX + "d");
        allFormated = allFormated.replaceAll("&[eE]", BUKKIT_COLOR_CODE_PREFIX + "e");
        allFormated = allFormated.replaceAll("&[fF]", BUKKIT_COLOR_CODE_PREFIX + "f");
        allFormated = allFormated.replaceAll("%", "\\%");
        allFormated = Format.convertHexColorCodeStringToBukkitColorCodeString(allFormated);
        return allFormated;
    }

    public static String FormatStringLegacyColor(String string) {
        String allFormated = string;
        allFormated = LEGACY_CHAT_COLOR_PATTERN.matcher(allFormated).replaceAll("\u00a7$13");
        allFormated = allFormated.replaceAll(BUKKIT_COLOR_CODE_PREFIX + "[A]", BUKKIT_COLOR_CODE_PREFIX + "a");
        allFormated = allFormated.replaceAll(BUKKIT_COLOR_CODE_PREFIX + "[B]", BUKKIT_COLOR_CODE_PREFIX + "b");
        allFormated = allFormated.replaceAll(BUKKIT_COLOR_CODE_PREFIX + "[C]", BUKKIT_COLOR_CODE_PREFIX + "c");
        allFormated = allFormated.replaceAll(BUKKIT_COLOR_CODE_PREFIX + "[D]", BUKKIT_COLOR_CODE_PREFIX + "d");
        allFormated = allFormated.replaceAll(BUKKIT_COLOR_CODE_PREFIX + "[E]", BUKKIT_COLOR_CODE_PREFIX + "e");
        allFormated = allFormated.replaceAll(BUKKIT_COLOR_CODE_PREFIX + "[F]", BUKKIT_COLOR_CODE_PREFIX + "f");
        allFormated = allFormated.replaceAll("%", "\\%");
        return allFormated;
    }

    public static String FormatString(String string) {
        String allFormated = string;
        allFormated = allFormated.replaceAll("&[kK]", BUKKIT_COLOR_CODE_PREFIX + "k");
        allFormated = allFormated.replaceAll("&[lL]", BUKKIT_COLOR_CODE_PREFIX + "l");
        allFormated = allFormated.replaceAll("&[mM]", BUKKIT_COLOR_CODE_PREFIX + "m");
        allFormated = allFormated.replaceAll("&[nN]", BUKKIT_COLOR_CODE_PREFIX + "n");
        allFormated = allFormated.replaceAll("&[oO]", BUKKIT_COLOR_CODE_PREFIX + "o");
        allFormated = allFormated.replaceAll("&[rR]", BUKKIT_COLOR_CODE_PREFIX + "r");
        allFormated = allFormated.replaceAll("%", "\\%");
        return allFormated;
    }

    public static String FormatStringAll(String string) {
        String allFormated = Format.FormatString(string);
        allFormated = Format.FormatStringColor(allFormated);
        return allFormated;
    }

    public static String FilterChat(String msg) {
        int t = 0;
        List filters = MineverseChat.getInstance().getConfig().getStringList("filters");
        for (String s : filters) {
            t = 0;
            String[] pparse = new String[]{" ", " "};
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                if (t >= 2) continue;
                pparse[t++] = st.nextToken();
            }
            msg = msg.replaceAll("(?i)" + pparse[0], pparse[1]);
        }
        return msg;
    }

    public static boolean isValidColor(String color) {
        Boolean bFound = false;
        for (ChatColor bkColors : ChatColor.values()) {
            if (!color.equalsIgnoreCase(bkColors.name())) continue;
            bFound = true;
        }
        return bFound;
    }

    public static boolean isValidHexColor(String color) {
        Pattern pattern = Pattern.compile("(^&?#[0-9a-fA-F]{6}\\b)");
        Matcher matcher = pattern.matcher(color);
        return matcher.find();
    }

    public static String convertHexColorCodeToBukkitColorCode(String color) {
        color = color.replace("&", "");
        StringBuilder bukkitColorCode = new StringBuilder(BUKKIT_COLOR_CODE_PREFIX + BUKKIT_HEX_COLOR_CODE_PREFIX);
        for (int a = 1; a < color.length(); ++a) {
            bukkitColorCode.append(BUKKIT_COLOR_CODE_PREFIX + color.charAt(a));
        }
        return bukkitColorCode.toString().toLowerCase();
    }

    public static String convertHexColorCodeStringToBukkitColorCodeString(String string) {
        Pattern pattern = Pattern.compile("(&?#[0-9a-fA-F]{6})");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            int indexStart = matcher.start();
            int indexEnd = matcher.end();
            String hexColor = string.substring(indexStart, indexEnd);
            String bukkitColor = Format.convertHexColorCodeToBukkitColorCode(hexColor);
            string = string.replaceAll(hexColor, bukkitColor);
            matcher.reset(string);
        }
        return string;
    }

    public static String escapeAllRegex(String input) {
        return input.replace("[", "\\[").replace("]", "\\]").replace("{", "\\{").replace("}", "\\}").replace("(", "\\(").replace(")", "\\)").replace("|", "\\|").replace("+", "\\+").replace("*", "\\*");
    }

    public static String underlineURLs() {
        boolean configValue = MineverseChat.getInstance().getConfig().getBoolean("underlineurls", true);
        if (VersionHandler.isAtLeast_1_20_4()) {
            return String.valueOf(configValue);
        }
        return "\"" + configValue + "\"";
    }

    public static String parseTimeStringFromMillis(long millis) {
        String units;
        String timeString = "";
        if (millis >= 86400000L) {
            long numberOfDays = millis / 86400000L;
            millis -= 86400000L * numberOfDays;
            units = LocalizedMessage.UNITS_DAY_PLURAL.toString();
            if (numberOfDays == 1L) {
                units = LocalizedMessage.UNITS_DAY_SINGULAR.toString();
            }
            timeString = timeString + numberOfDays + " " + units + " ";
        }
        if (millis >= 3600000L) {
            long numberOfHours = millis / 3600000L;
            millis -= 3600000L * numberOfHours;
            units = LocalizedMessage.UNITS_HOUR_PLURAL.toString();
            if (numberOfHours == 1L) {
                units = LocalizedMessage.UNITS_HOUR_SINGULAR.toString();
            }
            timeString = timeString + numberOfHours + " " + units + " ";
        }
        if (millis >= 60000L) {
            long numberOfMinutes = millis / 60000L;
            millis -= 60000L * numberOfMinutes;
            units = LocalizedMessage.UNITS_MINUTE_PLURAL.toString();
            if (numberOfMinutes == 1L) {
                units = LocalizedMessage.UNITS_MINUTE_SINGULAR.toString();
            }
            timeString = timeString + numberOfMinutes + " " + units + " ";
        }
        if (millis >= 1000L) {
            long numberOfSeconds = millis / 1000L;
            millis -= 1000L * numberOfSeconds;
            units = LocalizedMessage.UNITS_SECOND_PLURAL.toString();
            if (numberOfSeconds == 1L) {
                units = LocalizedMessage.UNITS_SECOND_SINGULAR.toString();
            }
            timeString = timeString + numberOfSeconds + " " + units;
        }
        return timeString.trim();
    }

    public static long parseTimeStringToMillis(String timeInput) {
        long millis = 0L;
        char[] validChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'd', 'h', 'm', 's'};
        if (Format.containsInvalidChars(validChars, timeInput = timeInput.toLowerCase())) {
            return -1L;
        }
        long countDayTokens = timeInput.chars().filter(ch -> ch == 100).count();
        long countHourTokens = timeInput.chars().filter(ch -> ch == 104).count();
        long countMinuteTokens = timeInput.chars().filter(ch -> ch == 109).count();
        long countSecondTokens = timeInput.chars().filter(ch -> ch == 115).count();
        if (countDayTokens > 1L || countHourTokens > 1L || countMinuteTokens > 1L || countSecondTokens > 1L) {
            return -1L;
        }
        int indexOfSecondToken = timeInput.indexOf("s");
        int indexOfMinuteToken = timeInput.indexOf("m");
        int indexOfHourToken = timeInput.indexOf("h");
        int indexOfDayToken = timeInput.indexOf("d");
        if (indexOfDayToken != -1 && (indexOfHourToken != -1 && indexOfHourToken < indexOfDayToken || indexOfMinuteToken != -1 && indexOfMinuteToken < indexOfDayToken || indexOfSecondToken != -1 && indexOfSecondToken < indexOfDayToken)) {
            return -1L;
        }
        if (indexOfHourToken != -1 && (indexOfMinuteToken != -1 && indexOfMinuteToken < indexOfHourToken || indexOfSecondToken != -1 && indexOfSecondToken < indexOfHourToken)) {
            return -1L;
        }
        if (indexOfMinuteToken != -1 && indexOfSecondToken != -1 && indexOfSecondToken < indexOfMinuteToken) {
            return -1L;
        }
        if (indexOfDayToken != -1) {
            int numberOfDays = Integer.parseInt(timeInput.substring(0, indexOfDayToken));
            timeInput = timeInput.substring(indexOfDayToken + 1);
            millis += 86400000L * (long)numberOfDays;
        }
        if (timeInput.length() > 0 && (indexOfHourToken = timeInput.indexOf("h")) != -1) {
            int numberOfHours = Integer.parseInt(timeInput.substring(0, indexOfHourToken));
            timeInput = timeInput.substring(indexOfHourToken + 1);
            millis += 3600000L * (long)numberOfHours;
        }
        if (timeInput.length() > 0 && (indexOfMinuteToken = timeInput.indexOf("m")) != -1) {
            int numberOfMinutes = Integer.parseInt(timeInput.substring(0, indexOfMinuteToken));
            timeInput = timeInput.substring(indexOfMinuteToken + 1);
            millis += 60000L * (long)numberOfMinutes;
        }
        if (timeInput.length() > 0 && (indexOfSecondToken = timeInput.indexOf("s")) != -1) {
            int numberOfSeconds = Integer.parseInt(timeInput.substring(0, indexOfSecondToken));
            timeInput = timeInput.substring(indexOfSecondToken + 1);
            millis += 1000L * (long)numberOfSeconds;
        }
        return millis;
    }

    private static boolean containsInvalidChars(char[] validChars, String validate) {
        for (char c : validate.toCharArray()) {
            boolean isValidChar = false;
            for (char v : validChars) {
                if (c != v) continue;
                isValidChar = true;
            }
            if (isValidChar) continue;
            return true;
        }
        return false;
    }

    public static void broadcastToServer(String message) {
        for (MineverseChatPlayer mcp : MineverseChatAPI.getOnlineMineverseChatPlayers()) {
            mcp.getPlayer().sendMessage(message);
        }
    }

    public static void playMessageSound(MineverseChatPlayer mcp) {
        Player player = mcp.getPlayer();
        String soundName = MineverseChat.getInstance().getConfig().getString("message_sound", DEFAULT_MESSAGE_SOUND);
        if (!soundName.equalsIgnoreCase("None")) {
            Sound messageSound = Format.getSound(soundName);
            player.playSound(player.getLocation(), messageSound, 1.0f, 0.0f);
        }
    }

    private static Sound getSound(String soundName) {
        if (Arrays.asList(Sound.values()).stream().map(Enum::toString).collect(Collectors.toList()).contains(soundName)) {
            return Sound.valueOf((String)soundName);
        }
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&c - Message sound invalid!"));
        return Format.getDefaultMessageSound();
    }

    private static Sound getDefaultMessageSound() {
        if (VersionHandler.is1_7() || VersionHandler.is1_8()) {
            return Sound.valueOf((String)DEFAULT_LEGACY_MESSAGE_SOUND);
        }
        return Sound.valueOf((String)DEFAULT_MESSAGE_SOUND);
    }

    public static String stripColor(String message) {
        return message.replaceAll("(\u00a7([a-z0-9]))", "");
    }
}

