/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.proxy;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import mineverse.Aust1n46.chat.database.ProxyPlayerData;
import mineverse.Aust1n46.chat.proxy.VentureChatProxy;
import mineverse.Aust1n46.chat.proxy.VentureChatProxyServer;
import mineverse.Aust1n46.chat.proxy.VentureChatProxySource;
import mineverse.Aust1n46.chat.utilities.Format;
import org.slf4j.Logger;
import shaded.net.md_5.bungee.config.Configuration;
import shaded.net.md_5.bungee.config.ConfigurationProvider;
import shaded.net.md_5.bungee.config.YamlConfiguration;

public class VentureChatVelocity
implements VentureChatProxySource {
    private final ProxyServer proxyServer;
    private final ChannelIdentifier channelIdentifier = MinecraftChannelIdentifier.create((String)VentureChatProxy.PLUGIN_MESSAGING_CHANNEL_NAMESPACE, (String)VentureChatProxy.PLUGIN_MESSAGING_CHANNEL_NAME);
    private final Logger logger;
    @Inject
    @DataDirectory
    private Path dataPath;
    private File velocityPlayerDataDirectory;
    private static Configuration velocityConfig;

    @Inject
    public VentureChatVelocity(ProxyServer server, Logger logger) {
        this.proxyServer = server;
        this.logger = logger;
    }

    public static Configuration getVelocityConfig() {
        return velocityConfig;
    }

    @Subscribe
    public void onInitialize(ProxyInitializeEvent event) {
        this.proxyServer.getChannelRegistrar().register(new ChannelIdentifier[]{this.channelIdentifier});
        File dataFolder = this.dataPath.toFile();
        if (!dataFolder.exists()) {
            dataFolder.mkdir();
        }
        File config = new File(dataFolder, "velocityconfig.yml");
        try {
            if (!config.exists()) {
                Files.copy(this.getClass().getClassLoader().getResourceAsStream("velocityconfig.yml"), config.toPath(), new CopyOption[0]);
            }
            velocityConfig = ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(dataFolder, "velocityconfig.yml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.velocityPlayerDataDirectory = new File(this.dataPath.toAbsolutePath().toString() + "/PlayerData");
        ProxyPlayerData.loadProxyPlayerData(this.velocityPlayerDataDirectory, this);
    }

    @Subscribe
    public void onShutdown(ProxyShutdownEvent event) {
        ProxyPlayerData.saveProxyPlayerData(this.velocityPlayerDataDirectory, this);
    }

    @Subscribe
    public void onPlayerJoin(ServerPostConnectEvent event) {
        this.updatePlayerNames();
    }

    @Subscribe
    public void onPlayerQuit(DisconnectEvent event) {
        this.proxyServer.getScheduler().buildTask((Object)this, () -> this.updatePlayerNames()).delay(1L, TimeUnit.SECONDS).schedule();
    }

    private void updatePlayerNames() {
        try {
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outstream);
            out.writeUTF("PlayerNames");
            out.writeInt(this.proxyServer.getPlayerCount());
            for (Player player : this.proxyServer.getAllPlayers()) {
                out.writeUTF(player.getUsername());
            }
            this.getServers().forEach(send -> {
                if (!send.isEmpty()) {
                    this.sendPluginMessage(send.getName(), outstream.toByteArray());
                }
            });
        }
        catch (IllegalStateException e) {
            this.sendConsoleMessage("Velocity being finicky with DisconnectEvent.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent event) {
        String channelIdentifierId = event.getIdentifier().getId();
        if (!channelIdentifierId.equals(VentureChatProxy.PLUGIN_MESSAGING_CHANNEL_STRING) && !channelIdentifierId.contains("viaversion:")) {
            return;
        }
        if (!(event.getSource() instanceof ServerConnection)) {
            return;
        }
        String serverName = ((ServerConnection)event.getSource()).getServerInfo().getName();
        VentureChatProxy.onPluginMessage(event.getData(), serverName, this);
        event.setResult(PluginMessageEvent.ForwardResult.handled());
    }

    @Override
    public void sendPluginMessage(String serverName, byte[] data) {
        Optional server = this.proxyServer.getServer(serverName);
        if (server.isPresent()) {
            ((RegisteredServer)server.get()).sendPluginMessage(this.channelIdentifier, data);
        }
    }

    @Override
    public List<VentureChatProxyServer> getServers() {
        return this.proxyServer.getAllServers().stream().map(velocityServer -> new VentureChatProxyServer(velocityServer.getServerInfo().getName(), velocityServer.getPlayersConnected().isEmpty())).collect(Collectors.toList());
    }

    @Override
    public VentureChatProxyServer getServer(String serverName) {
        RegisteredServer server = (RegisteredServer)this.proxyServer.getServer(serverName).get();
        return new VentureChatProxyServer(serverName, server.getPlayersConnected().isEmpty());
    }

    @Override
    public void sendConsoleMessage(String message) {
        this.logger.info(Format.stripColor(message));
    }

    @Override
    public boolean isOfflineServerAcknowledgementSet() {
        return velocityConfig.getBoolean("offline_server_acknowledgement");
    }
}

