/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.proxy;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Collectors;
import mineverse.Aust1n46.chat.database.ProxyPlayerData;
import mineverse.Aust1n46.chat.proxy.VentureChatProxy;
import mineverse.Aust1n46.chat.proxy.VentureChatProxyServer;
import mineverse.Aust1n46.chat.proxy.VentureChatProxySource;
import mineverse.Aust1n46.chat.utilities.Format;
import mineverse.Aust1n46.chat.utilities.UUIDFetcher;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ServerDisconnectEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import shaded.net.md_5.bungee.config.Configuration;
import shaded.net.md_5.bungee.config.ConfigurationProvider;
import shaded.net.md_5.bungee.config.YamlConfiguration;

public class VentureChatBungee
extends Plugin
implements Listener,
VentureChatProxySource {
    private static Configuration bungeeConfig;
    private File bungeePlayerDataDirectory;

    public void onEnable() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        File config = new File(this.getDataFolder(), "bungeeconfig.yml");
        try {
            if (!config.exists()) {
                Files.copy(this.getResourceAsStream("bungeeconfig.yml"), config.toPath(), new CopyOption[0]);
            }
            bungeeConfig = ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(this.getDataFolder(), "bungeeconfig.yml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bungeePlayerDataDirectory = new File(this.getDataFolder().getAbsolutePath() + "/PlayerData");
        ProxyPlayerData.loadLegacyBungeePlayerData(this.bungeePlayerDataDirectory, this);
        ProxyPlayerData.loadProxyPlayerData(this.bungeePlayerDataDirectory, this);
        this.getProxy().registerChannel(VentureChatProxy.PLUGIN_MESSAGING_CHANNEL_STRING);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
    }

    public void onDisable() {
        ProxyPlayerData.saveProxyPlayerData(this.bungeePlayerDataDirectory, this);
    }

    @EventHandler
    public void onPlayerJoin(ServerSwitchEvent event) {
        this.updatePlayerNames();
    }

    @EventHandler
    public void onPlayerLeave(ServerDisconnectEvent event) {
        this.updatePlayerNames();
    }

    @EventHandler
    public void onPlayerJoinNetwork(PostLoginEvent event) {
        UUIDFetcher.checkOfflineUUIDWarningProxy(event.getPlayer().getUniqueId(), this);
    }

    private void updatePlayerNames() {
        try {
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outstream);
            out.writeUTF("PlayerNames");
            out.writeInt(this.getProxy().getPlayers().size());
            for (ProxiedPlayer pp : this.getProxy().getPlayers()) {
                out.writeUTF(pp.getName());
            }
            for (String send : this.getProxy().getServers().keySet()) {
                if (((ServerInfo)this.getProxy().getServers().get(send)).getPlayers().size() <= 0) continue;
                ((ServerInfo)this.getProxy().getServers().get(send)).sendData(VentureChatProxy.PLUGIN_MESSAGING_CHANNEL_STRING, outstream.toByteArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent event) {
        if (!event.getTag().equals(VentureChatProxy.PLUGIN_MESSAGING_CHANNEL_STRING) && !event.getTag().contains("viaversion:")) {
            return;
        }
        if (!(event.getSender() instanceof Server)) {
            return;
        }
        String serverName = ((Server)event.getSender()).getInfo().getName();
        VentureChatProxy.onPluginMessage(event.getData(), serverName, this);
    }

    @Override
    public void sendPluginMessage(String serverName, byte[] data) {
        ((ServerInfo)this.getProxy().getServers().get(serverName)).sendData(VentureChatProxy.PLUGIN_MESSAGING_CHANNEL_STRING, data);
    }

    @Override
    public List<VentureChatProxyServer> getServers() {
        return this.getProxy().getServers().values().stream().map(bungeeServer -> new VentureChatProxyServer(bungeeServer.getName(), bungeeServer.getPlayers().isEmpty())).collect(Collectors.toList());
    }

    @Override
    public VentureChatProxyServer getServer(String serverName) {
        ServerInfo server = (ServerInfo)this.getProxy().getServers().get(serverName);
        return new VentureChatProxyServer(serverName, server.getPlayers().isEmpty());
    }

    @Override
    public void sendConsoleMessage(String message) {
        ProxyServer.getInstance().getConsole().sendMessage(TextComponent.fromLegacyText((String)Format.FormatStringAll(message)));
    }

    @Override
    public boolean isOfflineServerAcknowledgementSet() {
        return bungeeConfig.getBoolean("offline_server_acknowledgement");
    }
}

