/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.listeners;

import java.util.UUID;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.channel.ChatChannel;
import mineverse.Aust1n46.chat.database.PlayerData;
import mineverse.Aust1n46.chat.utilities.Format;
import mineverse.Aust1n46.chat.utilities.UUIDFetcher;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class LoginListener
implements Listener {
    private MineverseChat plugin = MineverseChat.getInstance();

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        MineverseChatPlayer mcp = MineverseChatAPI.getOnlineMineverseChatPlayer(playerQuitEvent.getPlayer());
        PlayerData.savePlayerData(mcp);
        mcp.clearMessages();
        mcp.setOnline(false);
        MineverseChatAPI.removeMineverseChatOnlinePlayerToMap(mcp);
    }

    void handleNameChange(MineverseChatPlayer mcp, Player eventPlayerInstance) {
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Detected Name Change. Old Name:&c " + mcp.getName() + " &eNew Name:&c " + eventPlayerInstance.getName()));
        MineverseChatAPI.removeNameFromMap(mcp.getName());
        mcp.setName(eventPlayerInstance.getName());
        MineverseChatAPI.addNameToMap(mcp);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerJoin(PlayerJoinEvent event) throws Exception {
        MineverseChatPlayer mcp = MineverseChatAPI.getMineverseChatPlayer(event.getPlayer());
        Player player = event.getPlayer();
        String name = player.getName();
        if (mcp == null) {
            UUID uuid = player.getUniqueId();
            mcp = new MineverseChatPlayer(uuid, name);
            MineverseChatAPI.addMineverseChatPlayerToMap(mcp);
            MineverseChatAPI.addNameToMap(mcp);
        }
        UUIDFetcher.checkOfflineUUIDWarning(mcp.getUUID());
        if (!mcp.getName().equals(name)) {
            this.handleNameChange(mcp, event.getPlayer());
        }
        mcp.setOnline(true);
        mcp.setHasPlayed(false);
        MineverseChatAPI.addMineverseChatOnlinePlayerToMap(mcp);
        mcp.setJsonFormat();
        for (ChatChannel ch : ChatChannel.getAutojoinList()) {
            if (ch.hasPermission().booleanValue()) {
                if (!mcp.getPlayer().hasPermission(ch.getPermission())) continue;
                mcp.addListening(ch.getName());
                continue;
            }
            mcp.addListening(ch.getName());
        }
        try {
            if (this.plugin.getServer().spigot().getConfig().getBoolean("settings.bungeecord") || this.plugin.getServer().spigot().getPaperConfig().getBoolean("settings.velocity-support.enabled") || this.plugin.getServer().spigot().getPaperConfig().getBoolean("proxies.velocity.enabled")) {
                long delayInTicks = 20L;
                final MineverseChatPlayer sync = mcp;
                this.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        MineverseChat.synchronize(sync, false);
                    }
                }, delayInTicks);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }
}

