/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.listeners;

import com.comphenix.protocol.events.PacketContainer;
import com.massivecraft.factions.entity.MPlayer;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Resident;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.api.events.ChannelJoinEvent;
import mineverse.Aust1n46.chat.api.events.VentureChatEvent;
import mineverse.Aust1n46.chat.channel.ChatChannel;
import mineverse.Aust1n46.chat.command.mute.MuteContainer;
import mineverse.Aust1n46.chat.database.Database;
import mineverse.Aust1n46.chat.localization.LocalizedMessage;
import mineverse.Aust1n46.chat.utilities.Format;
import net.essentialsx.api.v2.services.discord.DiscordService;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class ChatListener
implements Listener {
    private final boolean essentialsDiscordHook = Bukkit.getPluginManager().isPluginEnabled("EssentialsDiscord");
    private MineverseChat plugin = MineverseChat.getInstance();

    @EventHandler(priority=EventPriority.NORMAL)
    public void onChannelJoin(ChannelJoinEvent event) {
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAsyncPlayerChatEvent(final AsyncPlayerChatEvent event) {
        event.setCancelled(true);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ChatListener.this.handleTrueAsyncPlayerChatEvent(event);
            }
        });
    }

    public void handleTrueAsyncPlayerChatEvent(AsyncPlayerChatEvent event) {
        boolean bungee = false;
        String chat = event.getMessage();
        Set recipients = event.getRecipients();
        int recipientCount = recipients.size();
        MineverseChatPlayer mcp = MineverseChatAPI.getOnlineMineverseChatPlayer(event.getPlayer());
        ChatChannel eventChannel = mcp.getCurrentChannel();
        if (mcp.isEditing()) {
            mcp.getPlayer().sendMessage(Format.FormatStringAll(chat));
            mcp.setEditing(false);
            return;
        }
        if (mcp.isQuickChat()) {
            eventChannel = mcp.getQuickChannel();
        }
        if (mcp.hasConversation() && !mcp.isQuickChat()) {
            MineverseChatPlayer tp = MineverseChatAPI.getMineverseChatPlayer(mcp.getConversation());
            if (!tp.isOnline()) {
                mcp.getPlayer().sendMessage(ChatColor.RED + tp.getName() + " is not available.");
                if (!mcp.getPlayer().hasPermission("venturechat.spy.override")) {
                    for (MineverseChatPlayer p : MineverseChatAPI.getOnlineMineverseChatPlayers()) {
                        if (p.getName().equals(mcp.getName()) || !p.isSpy()) continue;
                        p.getPlayer().sendMessage(LocalizedMessage.EXIT_PRIVATE_CONVERSATION_SPY.toString().replace("{player_sender}", mcp.getName()).replace("{player_receiver}", tp.getName()));
                    }
                }
                mcp.setConversation(null);
            } else {
                if (tp.getIgnores().contains(mcp.getUUID())) {
                    mcp.getPlayer().sendMessage(LocalizedMessage.IGNORING_MESSAGE.toString().replace("{player}", tp.getName()));
                    event.setCancelled(true);
                    return;
                }
                if (!tp.getMessageToggle()) {
                    mcp.getPlayer().sendMessage(LocalizedMessage.BLOCKING_MESSAGE.toString().replace("{player}", tp.getName()));
                    event.setCancelled(true);
                    return;
                }
                String filtered = chat;
                String echo = "";
                String send = "";
                String spy = "";
                if (mcp.hasFilter()) {
                    filtered = Format.FilterChat(filtered);
                }
                if (mcp.getPlayer().hasPermission("venturechat.color.legacy")) {
                    filtered = Format.FormatStringLegacyColor(filtered);
                }
                if (mcp.getPlayer().hasPermission("venturechat.color")) {
                    filtered = Format.FormatStringColor(filtered);
                }
                if (mcp.getPlayer().hasPermission("venturechat.format")) {
                    filtered = Format.FormatString(filtered);
                }
                filtered = " " + filtered;
                send = Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)mcp.getPlayer(), (String)this.plugin.getConfig().getString("tellformatfrom").replaceAll("sender_", "")));
                echo = Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)mcp.getPlayer(), (String)this.plugin.getConfig().getString("tellformatto").replaceAll("sender_", "")));
                spy = Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)mcp.getPlayer(), (String)this.plugin.getConfig().getString("tellformatspy").replaceAll("sender_", "")));
                send = Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)tp.getPlayer(), (String)send.replaceAll("receiver_", ""))) + filtered;
                echo = Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)tp.getPlayer(), (String)echo.replaceAll("receiver_", ""))) + filtered;
                spy = Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)tp.getPlayer(), (String)spy.replaceAll("receiver_", ""))) + filtered;
                if (!mcp.getPlayer().hasPermission("venturechat.spy.override")) {
                    for (MineverseChatPlayer p : MineverseChatAPI.getOnlineMineverseChatPlayers()) {
                        if (p.getName().equals(mcp.getName()) || p.getName().equals(tp.getName()) || !p.isSpy()) continue;
                        p.getPlayer().sendMessage(spy);
                    }
                }
                tp.getPlayer().sendMessage(send);
                mcp.getPlayer().sendMessage(echo);
                if (tp.hasNotifications()) {
                    Format.playMessageSound(tp);
                }
                mcp.setReplyPlayer(tp.getUUID());
                tp.setReplyPlayer(mcp.getUUID());
                if (Database.isEnabled()) {
                    Database.writeVentureChat(mcp.getUUID().toString(), mcp.getName(), "Local", "Messaging_Component", chat.replace("'", "''"), "Chat");
                }
            }
            return;
        }
        if (mcp.isPartyChat() && !mcp.isQuickChat()) {
            if (mcp.hasParty()) {
                String partyformat = "";
                for (MineverseChatPlayer p : MineverseChatAPI.getOnlineMineverseChatPlayers()) {
                    if ((!p.hasParty() || !p.getParty().toString().equals(mcp.getParty().toString())) && !p.isSpy()) continue;
                    String filtered = chat;
                    if (mcp.hasFilter()) {
                        filtered = Format.FilterChat(filtered);
                    }
                    if (mcp.getPlayer().hasPermission("venturechat.color.legacy")) {
                        filtered = Format.FormatStringLegacyColor(filtered);
                    }
                    if (mcp.getPlayer().hasPermission("venturechat.color")) {
                        filtered = Format.FormatStringColor(filtered);
                    }
                    if (mcp.getPlayer().hasPermission("venturechat.format")) {
                        filtered = Format.FormatString(filtered);
                    }
                    filtered = " " + filtered;
                    partyformat = this.plugin.getConfig().getString("partyformat").equalsIgnoreCase("Default") ? ChatColor.GREEN + "[" + MineverseChatAPI.getMineverseChatPlayer(mcp.getParty()).getName() + "'s Party] " + mcp.getName() + ":" + filtered : Format.FormatStringAll(this.plugin.getConfig().getString("partyformat").replace("{host}", MineverseChatAPI.getMineverseChatPlayer(mcp.getParty()).getName()).replace("{player}", mcp.getName())) + filtered;
                    p.getPlayer().sendMessage(partyformat);
                }
                Bukkit.getConsoleSender().sendMessage(partyformat);
                if (Database.isEnabled()) {
                    Database.writeVentureChat(mcp.getUUID().toString(), mcp.getName(), "Local", "Party_Component", chat.replace("'", "''"), "Chat");
                }
                return;
            }
            mcp.getPlayer().sendMessage(ChatColor.RED + "You are not in a party.");
            return;
        }
        Location locsender = mcp.getPlayer().getLocation();
        Boolean filterthis = true;
        mcp.addListening(eventChannel.getName());
        if (mcp.isMuted(eventChannel.getName())) {
            MuteContainer muteContainer = mcp.getMute(eventChannel.getName());
            if (muteContainer.hasDuration()) {
                long dateTimeMillis = System.currentTimeMillis();
                long muteTimeMillis = muteContainer.getDuration();
                long remainingMuteTime = muteTimeMillis - dateTimeMillis;
                if (remainingMuteTime < 1000L) {
                    remainingMuteTime = 1000L;
                }
                String timeString = Format.parseTimeStringFromMillis(remainingMuteTime);
                if (muteContainer.hasReason()) {
                    mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_MUTED_TIMED_REASON.toString().replace("{channel_color}", eventChannel.getColor()).replace("{channel_name}", eventChannel.getName()).replace("{time}", timeString).replace("{reason}", muteContainer.getReason()));
                } else {
                    mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_MUTED_TIMED.toString().replace("{channel_color}", eventChannel.getColor()).replace("{channel_name}", eventChannel.getName()).replace("{time}", timeString));
                }
            } else if (muteContainer.hasReason()) {
                mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_MUTED_REASON.toString().replace("{channel_color}", eventChannel.getColor()).replace("{channel_name}", eventChannel.getName()).replace("{reason}", muteContainer.getReason()));
            } else {
                mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_MUTED.toString().replace("{channel_color}", eventChannel.getColor()).replace("{channel_name}", eventChannel.getName()));
            }
            mcp.setQuickChat(false);
            return;
        }
        Double chDistance = 0.0;
        String curColor = "";
        if (eventChannel.hasPermission().booleanValue() && !mcp.getPlayer().hasPermission(eventChannel.getPermission())) {
            mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_NO_PERMISSION.toString());
            mcp.setQuickChat(false);
            mcp.removeListening(eventChannel.getName());
            mcp.setCurrentChannel(ChatChannel.getDefaultChannel());
            return;
        }
        if (eventChannel.hasSpeakPermission() && !mcp.getPlayer().hasPermission(eventChannel.getSpeakPermission())) {
            mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_NO_SPEAK_PERMISSIONS.toString());
            mcp.setQuickChat(false);
            return;
        }
        curColor = eventChannel.getChatColor();
        bungee = eventChannel.getBungee();
        long dateTimeSeconds = System.currentTimeMillis() / 1000L;
        int chCooldown = 0;
        if (eventChannel.hasCooldown().booleanValue()) {
            chCooldown = eventChannel.getCooldown();
        }
        try {
            long cooldownTime;
            if (mcp.hasCooldown(eventChannel) && dateTimeSeconds < (cooldownTime = mcp.getCooldowns().get(eventChannel).longValue())) {
                long remainingCooldownTime = cooldownTime - dateTimeSeconds;
                String cooldownString = Format.parseTimeStringFromMillis(remainingCooldownTime * 1000L);
                mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_COOLDOWN.toString().replace("{cooldown}", cooldownString));
                mcp.setQuickChat(false);
                bungee = false;
                return;
            }
            if (eventChannel.hasCooldown().booleanValue() && !mcp.getPlayer().hasPermission("venturechat.cooldown.bypass")) {
                mcp.addCooldown(eventChannel, dateTimeSeconds + (long)chCooldown);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (mcp.hasSpam(eventChannel) && this.plugin.getConfig().getConfigurationSection("antispam").getBoolean("enabled") && !mcp.getPlayer().hasPermission("venturechat.spam.bypass")) {
            long spamcount = mcp.getSpam().get(eventChannel).get(0);
            long spamtime = mcp.getSpam().get(eventChannel).get(1);
            long spamtimeconfig = this.plugin.getConfig().getConfigurationSection("antispam").getLong("spamnumber");
            String mutedForTime = this.plugin.getConfig().getConfigurationSection("antispam").getString("mutetime", "0");
            long dateTime = System.currentTimeMillis();
            if (dateTimeSeconds < spamtime + this.plugin.getConfig().getConfigurationSection("antispam").getLong("spamtime")) {
                if (spamcount + 1L >= spamtimeconfig) {
                    long time = Format.parseTimeStringToMillis(mutedForTime);
                    if (time > 0L) {
                        mcp.addMute(eventChannel.getName(), dateTime + time, LocalizedMessage.SPAM_MUTE_REASON_TEXT.toString());
                        String timeString = Format.parseTimeStringFromMillis(time);
                        mcp.getPlayer().sendMessage(LocalizedMessage.MUTE_PLAYER_PLAYER_TIME_REASON.toString().replace("{channel_color}", eventChannel.getColor()).replace("{channel_name}", eventChannel.getName()).replace("{time}", timeString).replace("{reason}", LocalizedMessage.SPAM_MUTE_REASON_TEXT.toString()));
                    } else {
                        mcp.addMute(eventChannel.getName(), LocalizedMessage.SPAM_MUTE_REASON_TEXT.toString());
                        mcp.getPlayer().sendMessage(LocalizedMessage.MUTE_PLAYER_PLAYER_REASON.toString().replace("{channel_color}", eventChannel.getColor()).replace("{channel_name}", eventChannel.getName()).replace("{reason}", LocalizedMessage.SPAM_MUTE_REASON_TEXT.toString()));
                    }
                    if (eventChannel.getBungee().booleanValue()) {
                        MineverseChat.synchronize(mcp, true);
                    }
                    mcp.getSpam().get(eventChannel).set(0, 0L);
                    mcp.setQuickChat(false);
                    return;
                }
                if (spamtimeconfig % 2L != 0L) {
                    ++spamtimeconfig;
                }
                if (spamcount + 1L == spamtimeconfig / 2L) {
                    mcp.getPlayer().sendMessage(LocalizedMessage.SPAM_WARNING.toString());
                }
                mcp.getSpam().get(eventChannel).set(0, spamcount + 1L);
            } else {
                mcp.getSpam().get(eventChannel).set(0, 1L);
                mcp.getSpam().get(eventChannel).set(1, dateTimeSeconds);
            }
        } else {
            mcp.addSpam(eventChannel);
            mcp.getSpam().get(eventChannel).add(0, 1L);
            mcp.getSpam().get(eventChannel).add(1, dateTimeSeconds);
        }
        if (eventChannel.hasDistance().booleanValue()) {
            chDistance = eventChannel.getDistance();
        }
        String format = Format.FormatStringAll(eventChannel.getFormat());
        filterthis = eventChannel.isFiltered();
        if (filterthis.booleanValue() && mcp.hasFilter()) {
            chat = Format.FilterChat(chat);
        }
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        for (MineverseChatPlayer p : MineverseChatAPI.getOnlineMineverseChatPlayers()) {
            if (p.getPlayer() == mcp.getPlayer()) continue;
            if (!p.isListening(eventChannel.getName())) {
                recipients.remove(p.getPlayer());
                --recipientCount;
                continue;
            }
            if (this.plugin.getConfig().getBoolean("ignorechat", false) && p.getIgnores().contains(mcp.getUUID())) {
                recipients.remove(p.getPlayer());
                --recipientCount;
                continue;
            }
            if (this.plugin.getConfig().getBoolean("enable_towny_channel") && pluginManager.isPluginEnabled("Towny")) {
                try {
                    Resident pp;
                    TownyUniverse towny = TownyUniverse.getInstance();
                    if (eventChannel.getName().equalsIgnoreCase("Town")) {
                        Resident r = towny.getResident(p.getName());
                        pp = towny.getResident(mcp.getName());
                        if (!pp.hasTown()) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                            continue;
                        }
                        if (!r.hasTown()) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                            continue;
                        }
                        if (!r.getTown().getName().equals(pp.getTown().getName())) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                            continue;
                        }
                    }
                    if (eventChannel.getName().equalsIgnoreCase("Nation")) {
                        Resident r = towny.getResident(p.getName());
                        pp = towny.getResident(mcp.getName());
                        if (!pp.hasNation()) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                            continue;
                        }
                        if (!r.hasNation()) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                            continue;
                        }
                        if (!r.getTown().getNation().getName().equals(pp.getTown().getNation().getName())) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                            continue;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.plugin.getConfig().getBoolean("enable_factions_channel") && pluginManager.isPluginEnabled("Factions")) {
                try {
                    if (eventChannel.getName().equalsIgnoreCase("Faction")) {
                        MPlayer mplayer = MPlayer.get((Object)mcp.getPlayer());
                        MPlayer mplayerp = MPlayer.get((Object)p.getPlayer());
                        if (!mplayer.hasFaction()) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                        } else if (!mplayerp.hasFaction()) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                        } else if (!mplayer.getFactionName().equals(mplayerp.getFactionName())) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (chDistance > 0.0 && !bungee && !p.getRangedSpy()) {
                Location locreceip = p.getPlayer().getLocation();
                if (locreceip.getWorld() == mcp.getPlayer().getWorld()) {
                    Location diff = locreceip.subtract(locsender);
                    if (Math.abs(diff.getX()) > chDistance || Math.abs(diff.getZ()) > chDistance || Math.abs(diff.getY()) > chDistance) {
                        recipients.remove(p.getPlayer());
                        --recipientCount;
                        continue;
                    }
                    if (!mcp.getPlayer().canSee(p.getPlayer())) {
                        --recipientCount;
                        continue;
                    }
                } else {
                    recipients.remove(p.getPlayer());
                    --recipientCount;
                    continue;
                }
            }
            if (mcp.getPlayer().canSee(p.getPlayer())) continue;
            --recipientCount;
        }
        if (mcp.getPlayer().hasPermission("venturechat.color.legacy")) {
            chat = Format.FormatStringLegacyColor(chat);
        }
        if (mcp.getPlayer().hasPermission("venturechat.color")) {
            chat = Format.FormatStringColor(chat);
        }
        if (mcp.getPlayer().hasPermission("venturechat.format")) {
            chat = Format.FormatString(chat);
        }
        if (!mcp.isQuickChat()) {
            chat = " " + chat;
        }
        chat = curColor.equalsIgnoreCase("None") ? Format.getLastCode(Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)mcp.getPlayer(), (String)format))) + chat : curColor + chat;
        String globalJSON = Format.convertToJson(mcp, format, chat);
        format = Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)mcp.getPlayer(), (String)Format.FormatStringAll(format)));
        String message = Format.stripColor(format + chat);
        int hash = message.hashCode();
        VentureChatEvent ventureChatEvent = new VentureChatEvent(mcp, mcp.getName(), mcp.getNickname(), MineverseChat.getVaultPermission().getPrimaryGroup(mcp.getPlayer()), eventChannel, recipients, recipientCount, format, chat, globalJSON, hash, bungee);
        Bukkit.getServer().getPluginManager().callEvent((Event)ventureChatEvent);
        this.handleVentureChatEvent(ventureChatEvent);
        mcp.setQuickChat(false);
    }

    public void handleVentureChatEvent(VentureChatEvent event) {
        MineverseChatPlayer mcp = event.getMineverseChatPlayer();
        ChatChannel channel = event.getChannel();
        Set<Player> recipients = event.getRecipients();
        int recipientCount = event.getRecipientCount();
        String format = event.getFormat();
        String chat = event.getChat();
        String consoleChat = event.getConsoleChat();
        String globalJSON = event.getGlobalJSON();
        int hash = event.getHash();
        boolean bungee = event.isBungee();
        if (this.essentialsDiscordHook && channel.isDefaultchannel().booleanValue()) {
            ((DiscordService)Bukkit.getServicesManager().load(DiscordService.class)).sendChatMessage(mcp.getPlayer(), chat);
        }
        if (!bungee) {
            if (Database.isEnabled()) {
                Database.writeVentureChat(mcp.getUUID().toString(), mcp.getName(), "Local", channel.getName(), chat.replace("'", "''"), "Chat");
            }
            if (recipientCount == 1 && !this.plugin.getConfig().getString("emptychannelalert", "&6No one is listening to you.").equals("")) {
                mcp.getPlayer().sendMessage(Format.FormatStringAll(this.plugin.getConfig().getString("emptychannelalert", "&6No one is listening to you.")));
            }
            for (Player p : recipients) {
                String json = Format.formatModerationGUI(globalJSON, p, mcp.getName(), channel.getName(), hash);
                PacketContainer packet = Format.createPacketPlayOutChat(json);
                Format.sendPacketPlayOutChat(p, packet);
            }
            Bukkit.getConsoleSender().sendMessage(consoleChat);
            return;
        }
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOutStream);
        try {
            out.writeUTF("Chat");
            out.writeUTF(channel.getName());
            out.writeUTF(mcp.getName());
            out.writeUTF(mcp.getUUID().toString());
            out.writeBoolean(mcp.getBungeeToggle());
            out.writeInt(hash);
            out.writeUTF(format);
            out.writeUTF(chat);
            if (this.plugin.getConfig().getString("loglevel", "info").equals("debug")) {
                System.out.println(out.size() + " size bytes without json");
            }
            out.writeUTF(globalJSON);
            if (this.plugin.getConfig().getString("loglevel", "info").equals("debug")) {
                System.out.println(out.size() + " bytes size with json");
            }
            out.writeUTF(MineverseChat.getVaultPermission().getPrimaryGroup(mcp.getPlayer()));
            out.writeUTF(mcp.getNickname());
            mcp.getPlayer().sendPluginMessage((Plugin)this.plugin, "venturechat:data", byteOutStream.toByteArray());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

