/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.database;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.UUID;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.channel.ChatChannel;
import mineverse.Aust1n46.chat.command.mute.MuteContainer;
import mineverse.Aust1n46.chat.utilities.Format;
import mineverse.Aust1n46.chat.utilities.UUIDFetcher;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerData {
    private static MineverseChat plugin = MineverseChat.getInstance();
    private static final String PLAYER_DATA_DIRECTORY_PATH = plugin.getDataFolder().getAbsolutePath() + "/PlayerData";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLegacyPlayerData() {
        File legacyPlayerDataFile = new File(plugin.getDataFolder().getAbsolutePath(), "Players.yml");
        if (!legacyPlayerDataFile.isFile()) {
            return;
        }
        try {
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&c - Detected Legacy Player Data!"));
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&c - Converting to new structure and deleting old Players.yml file!"));
            YamlConfiguration playerData = YamlConfiguration.loadConfiguration((File)legacyPlayerDataFile);
            for (String uuidString : playerData.getConfigurationSection("players").getKeys(false)) {
                UUID uuid = UUID.fromString(uuidString);
                if (UUIDFetcher.shouldSkipOfflineUUID(uuid)) {
                    Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&c - Skipping Offline UUID: " + uuid));
                    continue;
                }
                String name = playerData.getConfigurationSection("players." + uuid).getString("name");
                String currentChannelName = playerData.getConfigurationSection("players." + uuid).getString("current");
                ChatChannel currentChannel = ChatChannel.isChannel(currentChannelName) ? ChatChannel.getChannel(currentChannelName) : ChatChannel.getDefaultChannel();
                HashSet<UUID> ignores = new HashSet<UUID>();
                StringTokenizer i = new StringTokenizer(playerData.getConfigurationSection("players." + uuidString).getString("ignores"), ",");
                while (i.hasMoreTokens()) {
                    ignores.add(UUID.fromString(i.nextToken()));
                }
                HashSet<String> listening = new HashSet<String>();
                StringTokenizer l = new StringTokenizer(playerData.getConfigurationSection("players." + uuidString).getString("listen"), ",");
                while (l.hasMoreTokens()) {
                    String channel = l.nextToken();
                    if (!ChatChannel.isChannel(channel)) continue;
                    listening.add(channel);
                }
                HashMap<String, MuteContainer> mutes = new HashMap<String, MuteContainer>();
                StringTokenizer m = new StringTokenizer(playerData.getConfigurationSection("players." + uuidString).getString("mutes"), ",");
                while (m.hasMoreTokens()) {
                    String[] parts = m.nextToken().split(":");
                    if (!ChatChannel.isChannel(parts[0])) continue;
                    if (parts[1].equals("null")) {
                        Bukkit.getConsoleSender().sendMessage("[VentureChat] Null Mute Time: " + parts[0] + " " + name);
                        continue;
                    }
                    String channelName = parts[0];
                    mutes.put(channelName, new MuteContainer(channelName, Long.parseLong(parts[1])));
                }
                HashSet<String> blockedCommands = new HashSet<String>();
                StringTokenizer b = new StringTokenizer(playerData.getConfigurationSection("players." + uuidString).getString("blockedcommands"), ",");
                while (b.hasMoreTokens()) {
                    blockedCommands.add(b.nextToken());
                }
                boolean host = playerData.getConfigurationSection("players." + uuidString).getBoolean("host");
                UUID party = playerData.getConfigurationSection("players." + uuidString).getString("party").length() > 0 ? UUID.fromString(playerData.getConfigurationSection("players." + uuidString).getString("party")) : null;
                boolean filter = playerData.getConfigurationSection("players." + uuidString).getBoolean("filter");
                boolean notifications = playerData.getConfigurationSection("players." + uuidString).getBoolean("notifications");
                String jsonFormat = "Default";
                boolean spy = playerData.getConfigurationSection("players." + uuidString).getBoolean("spy", false);
                boolean commandSpy = playerData.getConfigurationSection("players." + uuidString).getBoolean("commandspy", false);
                boolean rangedSpy = playerData.getConfigurationSection("players." + uuidString).getBoolean("rangedspy", false);
                boolean messageToggle = playerData.getConfigurationSection("players." + uuidString).getBoolean("messagetoggle", true);
                boolean bungeeToggle = playerData.getConfigurationSection("players." + uuidString).getBoolean("bungeetoggle", true);
                MineverseChatPlayer mcp = new MineverseChatPlayer(uuid, name, currentChannel, ignores, listening, mutes, blockedCommands, host, party, filter, notifications, jsonFormat, spy, commandSpy, rangedSpy, messageToggle, bungeeToggle);
                mcp.setModified(true);
                MineverseChatAPI.addMineverseChatPlayerToMap(mcp);
                MineverseChatAPI.addNameToMap(mcp);
            }
        }
        catch (Exception e) {
            MineverseChatAPI.clearMineverseChatPlayerMap();
            MineverseChatAPI.clearNameMap();
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&c - Error Loading Legacy Player Data!"));
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&c - Deleted Players.yml file!"));
        }
        finally {
            legacyPlayerDataFile.delete();
        }
    }

    public static void loadPlayerData() {
        try {
            File playerDataDirectory = new File(PLAYER_DATA_DIRECTORY_PATH);
            if (!playerDataDirectory.exists()) {
                playerDataDirectory.mkdirs();
            }
            Files.walk(Paths.get(PLAYER_DATA_DIRECTORY_PATH, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> PlayerData.readPlayerDataFile(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void readPlayerDataFile(Path path) {
        MineverseChatPlayer mcp;
        File playerDataFile = path.toFile();
        if (!playerDataFile.exists()) {
            return;
        }
        try {
            YamlConfiguration playerDataFileYamlConfiguration = YamlConfiguration.loadConfiguration((File)playerDataFile);
            String uuidString = playerDataFile.getName().replace(".yml", "");
            UUID uuid = UUID.fromString(uuidString);
            if (UUIDFetcher.shouldSkipOfflineUUID(uuid)) {
                Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&c - Skipping Offline UUID: " + uuid));
                Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&c - File will be skipped and deleted."));
                playerDataFile.delete();
                return;
            }
            String name = playerDataFileYamlConfiguration.getString("name");
            String currentChannelName = playerDataFileYamlConfiguration.getString("current");
            ChatChannel currentChannel = ChatChannel.isChannel(currentChannelName) ? ChatChannel.getChannel(currentChannelName) : ChatChannel.getDefaultChannel();
            HashSet<UUID> ignores = new HashSet<UUID>();
            StringTokenizer i = new StringTokenizer(playerDataFileYamlConfiguration.getString("ignores"), ",");
            while (i.hasMoreTokens()) {
                ignores.add(UUID.fromString(i.nextToken()));
            }
            HashSet<String> listening = new HashSet<String>();
            StringTokenizer l = new StringTokenizer(playerDataFileYamlConfiguration.getString("listen"), ",");
            while (l.hasMoreTokens()) {
                String channel = l.nextToken();
                if (!ChatChannel.isChannel(channel)) continue;
                listening.add(channel);
            }
            HashMap<String, MuteContainer> mutes = new HashMap<String, MuteContainer>();
            ConfigurationSection muteSection = playerDataFileYamlConfiguration.getConfigurationSection("mutes");
            for (String channelName : muteSection.getKeys(false)) {
                ConfigurationSection channelSection = muteSection.getConfigurationSection(channelName);
                mutes.put(channelName, new MuteContainer(channelName, channelSection.getLong("time"), channelSection.getString("reason")));
            }
            HashSet<String> blockedCommands = new HashSet<String>();
            StringTokenizer b = new StringTokenizer(playerDataFileYamlConfiguration.getString("blockedcommands"), ",");
            while (b.hasMoreTokens()) {
                blockedCommands.add(b.nextToken());
            }
            boolean host = playerDataFileYamlConfiguration.getBoolean("host");
            UUID party = playerDataFileYamlConfiguration.getString("party").length() > 0 ? UUID.fromString(playerDataFileYamlConfiguration.getString("party")) : null;
            boolean filter = playerDataFileYamlConfiguration.getBoolean("filter");
            boolean notifications = playerDataFileYamlConfiguration.getBoolean("notifications");
            String jsonFormat = "Default";
            boolean spy = playerDataFileYamlConfiguration.getBoolean("spy", false);
            boolean commandSpy = playerDataFileYamlConfiguration.getBoolean("commandspy", false);
            boolean rangedSpy = playerDataFileYamlConfiguration.getBoolean("rangedspy", false);
            boolean messageToggle = playerDataFileYamlConfiguration.getBoolean("messagetoggle", true);
            boolean bungeeToggle = playerDataFileYamlConfiguration.getBoolean("bungeetoggle", true);
            mcp = new MineverseChatPlayer(uuid, name, currentChannel, ignores, listening, mutes, blockedCommands, host, party, filter, notifications, jsonFormat, spy, commandSpy, rangedSpy, messageToggle, bungeeToggle);
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&c - Error Loading Data File: " + playerDataFile.getName()));
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&c - File will be skipped and deleted."));
            playerDataFile.delete();
            return;
        }
        if (mcp != null) {
            MineverseChatAPI.addMineverseChatPlayerToMap(mcp);
            MineverseChatAPI.addNameToMap(mcp);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void savePlayerData(MineverseChatPlayer mcp) {
        if (mcp == null || UUIDFetcher.shouldSkipOfflineUUID(mcp.getUUID()) || !mcp.isOnline() && !mcp.wasModified()) {
            return;
        }
        try {
            void var5_9;
            File playerDataFile = new File(PLAYER_DATA_DIRECTORY_PATH, mcp.getUUID() + ".yml");
            YamlConfiguration playerDataFileYamlConfiguration = YamlConfiguration.loadConfiguration((File)playerDataFile);
            if (!playerDataFile.exists()) {
                playerDataFileYamlConfiguration.save(playerDataFile);
            }
            playerDataFileYamlConfiguration.set("name", (Object)mcp.getName());
            playerDataFileYamlConfiguration.set("current", (Object)mcp.getCurrentChannel().getName());
            String ignores = "";
            for (UUID uUID : mcp.getIgnores()) {
                ignores = ignores + uUID.toString() + ",";
            }
            playerDataFileYamlConfiguration.set("ignores", (Object)ignores);
            String listening = "";
            for (String string : mcp.getListening()) {
                ChatChannel chatChannel = ChatChannel.getChannel(string);
                listening = listening + chatChannel.getName() + ",";
            }
            String string = "";
            for (String string2 : mcp.getBlockedCommands()) {
                String string3 = (String)var5_9 + string2 + ",";
            }
            if (listening.length() > 0) {
                listening = listening.substring(0, listening.length() - 1);
            }
            playerDataFileYamlConfiguration.set("listen", (Object)listening);
            ConfigurationSection configurationSection = playerDataFileYamlConfiguration.createSection("mutes");
            for (MuteContainer mute : mcp.getMutes()) {
                ConfigurationSection channelSection = configurationSection.createSection(mute.getChannel());
                channelSection.set("time", (Object)mute.getDuration());
                channelSection.set("reason", (Object)mute.getReason());
            }
            playerDataFileYamlConfiguration.set("blockedcommands", (Object)var5_9);
            playerDataFileYamlConfiguration.set("host", (Object)mcp.isHost());
            playerDataFileYamlConfiguration.set("party", (Object)(mcp.hasParty() ? mcp.getParty().toString() : ""));
            playerDataFileYamlConfiguration.set("filter", (Object)mcp.hasFilter());
            playerDataFileYamlConfiguration.set("notifications", (Object)mcp.hasNotifications());
            playerDataFileYamlConfiguration.set("spy", (Object)mcp.isSpy());
            playerDataFileYamlConfiguration.set("commandspy", (Object)mcp.hasCommandSpy());
            playerDataFileYamlConfiguration.set("rangedspy", (Object)mcp.getRangedSpy());
            playerDataFileYamlConfiguration.set("messagetoggle", (Object)mcp.getMessageToggle());
            playerDataFileYamlConfiguration.set("bungeetoggle", (Object)mcp.getBungeeToggle());
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MMM/dd HH:mm:ss");
            String dateNow = formatter.format(calendar.getTime());
            playerDataFileYamlConfiguration.set("date", (Object)dateNow);
            mcp.setModified(false);
            playerDataFileYamlConfiguration.save(playerDataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void savePlayerData() {
        for (MineverseChatPlayer p : MineverseChatAPI.getMineverseChatPlayers()) {
            PlayerData.savePlayerData(p);
        }
    }
}

