/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.command;

import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.channel.ChatChannel;
import mineverse.Aust1n46.chat.command.ChannelAlias;
import mineverse.Aust1n46.chat.command.chat.Broadcast;
import mineverse.Aust1n46.chat.command.chat.BungeeToggle;
import mineverse.Aust1n46.chat.command.chat.Channel;
import mineverse.Aust1n46.chat.command.chat.Channelinfo;
import mineverse.Aust1n46.chat.command.chat.Chatinfo;
import mineverse.Aust1n46.chat.command.chat.Chatreload;
import mineverse.Aust1n46.chat.command.chat.Chlist;
import mineverse.Aust1n46.chat.command.chat.Chwho;
import mineverse.Aust1n46.chat.command.chat.Clearchat;
import mineverse.Aust1n46.chat.command.chat.Commandblock;
import mineverse.Aust1n46.chat.command.chat.Commandspy;
import mineverse.Aust1n46.chat.command.chat.Config;
import mineverse.Aust1n46.chat.command.chat.Edit;
import mineverse.Aust1n46.chat.command.chat.Filter;
import mineverse.Aust1n46.chat.command.chat.Force;
import mineverse.Aust1n46.chat.command.chat.Forceall;
import mineverse.Aust1n46.chat.command.chat.Kickchannel;
import mineverse.Aust1n46.chat.command.chat.Kickchannelall;
import mineverse.Aust1n46.chat.command.chat.Leave;
import mineverse.Aust1n46.chat.command.chat.Listen;
import mineverse.Aust1n46.chat.command.chat.Me;
import mineverse.Aust1n46.chat.command.chat.Party;
import mineverse.Aust1n46.chat.command.chat.RangedSpy;
import mineverse.Aust1n46.chat.command.chat.Removemessage;
import mineverse.Aust1n46.chat.command.chat.Setchannel;
import mineverse.Aust1n46.chat.command.chat.Setchannelall;
import mineverse.Aust1n46.chat.command.chat.VentureChatGui;
import mineverse.Aust1n46.chat.command.chat.Venturechat;
import mineverse.Aust1n46.chat.command.message.Ignore;
import mineverse.Aust1n46.chat.command.message.Message;
import mineverse.Aust1n46.chat.command.message.MessageToggle;
import mineverse.Aust1n46.chat.command.message.Notifications;
import mineverse.Aust1n46.chat.command.message.Reply;
import mineverse.Aust1n46.chat.command.message.Spy;
import mineverse.Aust1n46.chat.command.mute.Mute;
import mineverse.Aust1n46.chat.command.mute.Muteall;
import mineverse.Aust1n46.chat.command.mute.Unmute;
import mineverse.Aust1n46.chat.command.mute.Unmuteall;
import mineverse.Aust1n46.chat.utilities.Format;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class VentureCommandExecutor {
    private static final String VERSION = "3.3.0";
    private static final Map<String, Command> commands = new HashMap<String, Command>();
    private static final MineverseChat plugin = MineverseChat.getInstance();
    private static Map<String, Command> knownCommands;

    public static void initialize() {
        YamlConfiguration commandsFileConfiguration;
        String fileVersion;
        Server server = plugin.getServer();
        File commandsFile = new File(plugin.getDataFolder().getAbsolutePath(), "commands.yml");
        if (!commandsFile.isFile()) {
            plugin.saveResource("commands.yml", true);
        }
        if (!(fileVersion = (commandsFileConfiguration = YamlConfiguration.loadConfiguration((File)commandsFile)).getString("Version", "null")).equals(VERSION)) {
            server.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Version Change Detected!  Saving Old commands.yml and Generating Latest File"));
            commandsFile.renameTo(new File(plugin.getDataFolder().getAbsolutePath(), "commands_old_" + fileVersion + ".yml"));
            plugin.saveResource("commands.yml", true);
            commandsFileConfiguration = YamlConfiguration.loadConfiguration((File)commandsFile);
        }
        try {
            knownCommands = server.getCommandMap().getKnownCommands();
        }
        catch (NoSuchMethodError error) {
            try {
                Field commandMapField = server.getClass().getDeclaredField("commandMap");
                commandMapField.setAccessible(true);
                SimpleCommandMap simpleCommandMap = (SimpleCommandMap)commandMapField.get(server);
                Field field = SimpleCommandMap.class.getDeclaredField("knownCommands");
                field.setAccessible(true);
                knownCommands = (Map)field.get(simpleCommandMap);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                server.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&c - Unable to access CommandMap on Spigot. If this issue persists, try using Paper."));
                e.printStackTrace();
            }
        }
        commands.put("broadcast", new Broadcast());
        commands.put("channel", new Channel());
        commands.put("channelinfo", new Channelinfo());
        commands.put("chatinfo", new Chatinfo());
        commands.put("chatreload", new Chatreload());
        commands.put("chlist", new Chlist());
        commands.put("chwho", new Chwho());
        commands.put("clearchat", new Clearchat());
        commands.put("commandblock", new Commandblock());
        commands.put("commandspy", new Commandspy());
        commands.put("config", new Config());
        commands.put("edit", new Edit());
        commands.put("filter", new Filter());
        commands.put("force", new Force());
        commands.put("forceall", new Forceall());
        commands.put("kickchannel", new Kickchannel());
        commands.put("kickchannelall", new Kickchannelall());
        commands.put("leave", new Leave());
        commands.put("listen", new Listen());
        commands.put("me", new Me());
        commands.put("venturechat", new Venturechat());
        commands.put("notifications", new Notifications());
        commands.put("party", new Party());
        commands.put("rangedspy", new RangedSpy());
        commands.put("removemessage", new Removemessage());
        commands.put("setchannel", new Setchannel());
        commands.put("setchannelall", new Setchannelall());
        commands.put("spy", new Spy());
        commands.put("venturechatgui", new VentureChatGui());
        commands.put("messagetoggle", new MessageToggle());
        commands.put("bungeetoggle", new BungeeToggle());
        commands.put("mute", new Mute());
        commands.put("muteall", new Muteall());
        commands.put("unmute", new Unmute());
        commands.put("unmuteall", new Unmuteall());
        commands.put("reply", new Reply());
        commands.put("message", new Message());
        commands.put("ignore", new Ignore());
        ChannelAlias channelAlias = new ChannelAlias();
        for (ChatChannel chatChannel : ChatChannel.getChatChannels()) {
            String string = chatChannel.getAlias();
            commands.put(string, channelAlias);
        }
        ConfigurationSection commandsSection = commandsFileConfiguration.getConfigurationSection("commands");
        for (String string : commandsSection.getKeys(false)) {
            ConfigurationSection commandSection = commandsSection.getConfigurationSection(string);
            boolean isEnabled = commandSection.getBoolean("enabled", true);
            if (!isEnabled) {
                commands.remove(string);
                continue;
            }
            Command command = commands.get(string);
            if (command == null) continue;
            List aliases = commandSection.getStringList("aliases");
            for (String alias : aliases) {
                commands.put(alias, command);
            }
            commands.put("venturechat:" + string, command);
        }
        for (Map.Entry entry : commands.entrySet()) {
            VentureCommandExecutor.registerCommand((String)entry.getKey(), (Command)entry.getValue());
        }
        server.getScheduler().runTaskLater((Plugin)plugin, () -> {
            for (Map.Entry<String, Command> commandEntry : commands.entrySet()) {
                VentureCommandExecutor.registerCommand(commandEntry.getKey(), commandEntry.getValue());
            }
        }, 10L);
    }

    public static void registerCommand(String commandLabel, Command command) {
        knownCommands.put(commandLabel, command);
    }
}

