/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.channel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.utilities.Format;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class ChatChannel {
    private static final String PERMISSION_PREFIX = "venturechat.";
    private static final String NO_PERMISSIONS = "venturechat.none";
    private static MineverseChat plugin = MineverseChat.getInstance();
    private static ChatChannel defaultChatChannel;
    private static String defaultColor;
    private static HashMap<String, ChatChannel> chatChannels;
    @Deprecated
    private static ChatChannel[] channels;
    private String name;
    private String permission;
    private String speakPermission;
    private boolean mutable;
    private String color;
    private String chatColor;
    private boolean defaultChannel;
    private boolean autojoin;
    private String alias;
    private double distance;
    private boolean filter;
    private boolean bungee;
    private String format;
    private int cooldown;
    private String prefix;

    public static void initialize() {
        chatChannels = new HashMap();
        ConfigurationSection cs = plugin.getConfig().getConfigurationSection("channels");
        int len = cs.getKeys(false).size();
        channels = new ChatChannel[len];
        int counter = 0;
        for (String key : cs.getKeys(false)) {
            String color = cs.getString(key + ".color", "white");
            String chatColor = cs.getString(key + ".chatcolor", "white");
            String name = key;
            String permission = cs.getString(key + ".permissions", "None");
            String speakPermission = cs.getString(key + ".speak_permissions", "None");
            boolean mutable = cs.getBoolean(key + ".mutable", false);
            boolean filter = cs.getBoolean(key + ".filter", true);
            boolean bungee = cs.getBoolean(key + ".bungeecord", false);
            String format = cs.getString(key + ".format", "Default");
            boolean defaultChannel = cs.getBoolean(key + ".default", false);
            String alias = cs.getString(key + ".alias", "None");
            double distance = cs.getDouble(key + ".distance", 0.0);
            int cooldown = cs.getInt(key + ".cooldown", 0);
            boolean autojoin = cs.getBoolean(key + ".autojoin", false);
            String prefix = cs.getString(key + ".channel_prefix");
            ChatChannel chatChannel = new ChatChannel(name, color, chatColor, permission, speakPermission, mutable, filter, defaultChannel, alias, distance, autojoin, bungee, cooldown, prefix, format);
            ChatChannel.channels[counter++] = chatChannel;
            chatChannels.put(name.toLowerCase(), chatChannel);
            chatChannels.put(alias.toLowerCase(), chatChannel);
            if (!defaultChannel) continue;
            defaultChatChannel = chatChannel;
            defaultColor = color;
        }
        if (defaultChatChannel == null) {
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - &cNo default channel found!"));
            defaultChatChannel = new ChatChannel("MissingDefault", "red", "red", "None", "None", false, true, true, "md", 0.0, true, false, 0, "&f[&cMissingDefault&f]", "{venturechat_channel_prefix} {vault_prefix}{player_displayname}&c:");
            defaultColor = defaultChatChannel.getColor();
            chatChannels.put("missingdefault", defaultChatChannel);
            chatChannels.put("md", defaultChatChannel);
        }
    }

    @Deprecated
    public static ChatChannel[] getChannels() {
        return channels;
    }

    public static Collection<ChatChannel> getChatChannels() {
        return new HashSet<ChatChannel>(chatChannels.values());
    }

    public static ChatChannel getChannel(String channelName) {
        return chatChannels.get(channelName.toLowerCase());
    }

    public static boolean isChannel(String channelName) {
        return ChatChannel.getChannel(channelName) != null;
    }

    public static String getDefaultColor() {
        return defaultColor;
    }

    public static ChatChannel getDefaultChannel() {
        return defaultChatChannel;
    }

    public static List<ChatChannel> getAutojoinList() {
        ArrayList<ChatChannel> joinlist = new ArrayList<ChatChannel>();
        for (ChatChannel c : channels) {
            if (!c.getAutojoin().booleanValue()) continue;
            joinlist.add(c);
        }
        return joinlist;
    }

    public ChatChannel(String name, String color, String chatColor, String permission, String speakPermission, boolean mutable, boolean filter, boolean defaultChannel, String alias, double distance, boolean autojoin, boolean bungee, int cooldown, String prefix, String format) {
        this.name = name;
        this.color = color;
        this.chatColor = chatColor;
        this.permission = PERMISSION_PREFIX + permission;
        this.speakPermission = PERMISSION_PREFIX + speakPermission;
        this.mutable = mutable;
        this.filter = filter;
        this.defaultChannel = defaultChannel;
        this.alias = alias;
        this.distance = distance;
        this.autojoin = autojoin;
        this.bungee = bungee;
        this.cooldown = cooldown;
        this.format = format;
        this.prefix = prefix;
    }

    @Deprecated
    public ChatChannel(String name, String color, String chatColor, String permission, String speakPermission, Boolean mutable, Boolean filter, Boolean defaultChannel, String alias, Double distance, Boolean autojoin, Boolean bungee, int cooldown, String format) {
        this.name = name;
        this.color = color;
        this.chatColor = chatColor;
        this.permission = PERMISSION_PREFIX + permission;
        this.speakPermission = PERMISSION_PREFIX + speakPermission;
        this.mutable = mutable;
        this.filter = filter;
        this.defaultChannel = defaultChannel;
        this.alias = alias;
        this.distance = distance;
        this.autojoin = autojoin;
        this.bungee = bungee;
        this.cooldown = cooldown;
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Boolean getBungee() {
        return this.bungee;
    }

    public String getPermission() {
        return this.permission;
    }

    public Boolean getAutojoin() {
        return this.autojoin;
    }

    public Boolean isMutable() {
        return this.mutable;
    }

    public String getColor() {
        if (Format.isValidColor(this.color)) {
            return String.valueOf(ChatColor.valueOf((String)this.color.toUpperCase()));
        }
        if (Format.isValidHexColor(this.color)) {
            return Format.convertHexColorCodeToBukkitColorCode(this.color);
        }
        return Format.DEFAULT_COLOR_CODE;
    }

    public String getColorRaw() {
        return this.color;
    }

    public String getChatColor() {
        if (this.chatColor.equalsIgnoreCase("None")) {
            return this.chatColor;
        }
        if (Format.isValidColor(this.chatColor)) {
            return String.valueOf(ChatColor.valueOf((String)this.chatColor.toUpperCase()));
        }
        if (Format.isValidHexColor(this.chatColor)) {
            return Format.convertHexColorCodeToBukkitColorCode(this.chatColor);
        }
        return Format.DEFAULT_COLOR_CODE;
    }

    public String getChatColorRaw() {
        return this.chatColor;
    }

    public Boolean isDefaultchannel() {
        return this.defaultChannel;
    }

    public String getAlias() {
        return this.alias;
    }

    public Double getDistance() {
        return this.distance;
    }

    public Boolean hasDistance() {
        return this.distance > 0.0;
    }

    public Boolean hasCooldown() {
        return this.cooldown > 0;
    }

    public Boolean hasPermission() {
        return !this.permission.equalsIgnoreCase(NO_PERMISSIONS);
    }

    public boolean hasSpeakPermission() {
        return !this.speakPermission.equalsIgnoreCase(NO_PERMISSIONS);
    }

    public String getSpeakPermission() {
        return this.speakPermission;
    }

    public Boolean isFiltered() {
        return this.filter;
    }

    public boolean equals(Object channel) {
        return channel instanceof ChatChannel && this.name.equals(((ChatChannel)channel).getName());
    }
}

