/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.api.SynchronizedMineverseChatPlayer;
import org.bukkit.entity.Player;

public final class MineverseChatAPI {
    private static HashMap<UUID, MineverseChatPlayer> playerMap = new HashMap();
    private static HashMap<String, UUID> namesMap = new HashMap();
    private static HashMap<UUID, MineverseChatPlayer> onlinePlayerMap = new HashMap();
    private static List<String> networkPlayerNames = new ArrayList<String>();
    private static HashMap<UUID, SynchronizedMineverseChatPlayer> proxyPlayerMap = new HashMap();

    public static List<String> getNetworkPlayerNames() {
        return networkPlayerNames;
    }

    public static void clearNetworkPlayerNames() {
        networkPlayerNames.clear();
    }

    public static void addNetworkPlayerName(String name) {
        networkPlayerNames.add(name);
    }

    public static void addSynchronizedMineverseChatPlayerToMap(SynchronizedMineverseChatPlayer smcp) {
        proxyPlayerMap.put(smcp.getUUID(), smcp);
    }

    public static void clearProxyPlayerMap() {
        proxyPlayerMap.clear();
    }

    public static Collection<SynchronizedMineverseChatPlayer> getSynchronizedMineverseChatPlayers() {
        return proxyPlayerMap.values();
    }

    public static void addNameToMap(MineverseChatPlayer mcp) {
        namesMap.put(mcp.getName(), mcp.getUUID());
    }

    public static void removeNameFromMap(String name) {
        namesMap.remove(name);
    }

    public static void clearNameMap() {
        namesMap.clear();
    }

    public static void addMineverseChatPlayerToMap(MineverseChatPlayer mcp) {
        playerMap.put(mcp.getUUID(), mcp);
        MineverseChat.players.add(mcp);
    }

    public static void clearMineverseChatPlayerMap() {
        playerMap.clear();
        MineverseChat.players.clear();
    }

    public static Collection<MineverseChatPlayer> getMineverseChatPlayers() {
        return playerMap.values();
    }

    public static void addMineverseChatOnlinePlayerToMap(MineverseChatPlayer mcp) {
        onlinePlayerMap.put(mcp.getUUID(), mcp);
        MineverseChat.onlinePlayers.add(mcp);
    }

    public static void removeMineverseChatOnlinePlayerToMap(MineverseChatPlayer mcp) {
        onlinePlayerMap.remove(mcp.getUUID());
        MineverseChat.onlinePlayers.remove(mcp);
    }

    public static void clearOnlineMineverseChatPlayerMap() {
        onlinePlayerMap.clear();
        MineverseChat.onlinePlayers.clear();
    }

    public static Collection<MineverseChatPlayer> getOnlineMineverseChatPlayers() {
        return onlinePlayerMap.values();
    }

    public static MineverseChatPlayer getMineverseChatPlayer(Player player) {
        return MineverseChatAPI.getMineverseChatPlayer(player.getUniqueId());
    }

    public static MineverseChatPlayer getMineverseChatPlayer(UUID uuid) {
        return playerMap.get(uuid);
    }

    public static MineverseChatPlayer getMineverseChatPlayer(String name) {
        return MineverseChatAPI.getMineverseChatPlayer(namesMap.get(name));
    }

    public static MineverseChatPlayer getOnlineMineverseChatPlayer(Player player) {
        return MineverseChatAPI.getOnlineMineverseChatPlayer(player.getUniqueId());
    }

    public static MineverseChatPlayer getOnlineMineverseChatPlayer(UUID uuid) {
        return onlinePlayerMap.get(uuid);
    }

    public static MineverseChatPlayer getOnlineMineverseChatPlayer(String name) {
        return MineverseChatAPI.getOnlineMineverseChatPlayer(namesMap.get(name));
    }

    public static SynchronizedMineverseChatPlayer getSynchronizedMineverseChatPlayer(UUID uuid) {
        return proxyPlayerMap.get(uuid);
    }
}

