/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import mineverse.Aust1n46.chat.VentureChatPlaceholders;
import mineverse.Aust1n46.chat.alias.Alias;
import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.api.events.VentureChatEvent;
import mineverse.Aust1n46.chat.channel.ChatChannel;
import mineverse.Aust1n46.chat.channel.ChatChannelInfo;
import mineverse.Aust1n46.chat.command.VentureCommandExecutor;
import mineverse.Aust1n46.chat.command.chat.Channel;
import mineverse.Aust1n46.chat.command.mute.MuteContainer;
import mineverse.Aust1n46.chat.database.Database;
import mineverse.Aust1n46.chat.database.PlayerData;
import mineverse.Aust1n46.chat.gui.GuiSlot;
import mineverse.Aust1n46.chat.json.JsonFormat;
import mineverse.Aust1n46.chat.listeners.ChatListener;
import mineverse.Aust1n46.chat.listeners.CommandListener;
import mineverse.Aust1n46.chat.listeners.LoginListener;
import mineverse.Aust1n46.chat.listeners.PacketListenerLegacyChat;
import mineverse.Aust1n46.chat.listeners.SignListener;
import mineverse.Aust1n46.chat.localization.Localization;
import mineverse.Aust1n46.chat.localization.LocalizedMessage;
import mineverse.Aust1n46.chat.utilities.Format;
import mineverse.Aust1n46.chat.versions.VersionHandler;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.scheduler.BukkitScheduler;

public class MineverseChat
extends JavaPlugin
implements PluginMessageListener {
    public static final String PLUGIN_MESSAGING_CHANNEL = "venturechat:data";
    public static final boolean ASYNC = true;
    public static final boolean SYNC = false;
    public static final int LINE_LENGTH = 40;
    @Deprecated
    public static ChatChannelInfo ccInfo;
    @Deprecated
    public static Set<MineverseChatPlayer> players;
    @Deprecated
    public static Set<MineverseChatPlayer> onlinePlayers;
    private static Permission permission;
    private static Chat chat;

    public void onEnable() {
        ccInfo = new ChatChannelInfo();
        try {
            File file;
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Initializing..."));
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdirs();
            }
            if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
                Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Config not found! Generating file."));
                this.saveDefaultConfig();
            } else {
                Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Config found! Loading file."));
            }
            this.saveResource("example_config_always_up_to_date!.yml", true);
        }
        catch (Exception ex) {
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - &cCould not load configuration! Something unexpected went wrong!"));
        }
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Checking for Vault..."));
        if (!this.setupPermissions() || !this.setupChat()) {
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - &cCould not find Vault and/or a Vault compatible permissions plugin!"));
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        MineverseChat.initializeConfigReaders();
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Loading player data"));
        PlayerData.loadLegacyPlayerData();
        PlayerData.loadPlayerData();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> Database.initializeMySQL());
        VentureCommandExecutor.initialize();
        this.registerListeners();
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Registering Listeners"));
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Attaching to Executors"));
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Establishing BungeeCord"));
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, PLUGIN_MESSAGING_CHANNEL);
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, PLUGIN_MESSAGING_CHANNEL, (PluginMessageListener)this);
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (pluginManager.isPluginEnabled("Towny")) {
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Enabling Towny Formatting"));
        }
        if (pluginManager.isPluginEnabled("Jobs")) {
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Enabling Jobs Formatting"));
        }
        if (pluginManager.isPluginEnabled("Factions")) {
            String version = pluginManager.getPlugin("Factions").getDescription().getVersion();
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Enabling Factions Formatting version " + version));
        }
        if (pluginManager.isPluginEnabled("PlaceholderAPI")) {
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Enabling PlaceholderAPI Hook"));
        }
        new VentureChatPlaceholders().register();
        this.startRepeatingTasks();
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Enabled Successfully"));
    }

    public void onDisable() {
        PlayerData.savePlayerData();
        MineverseChatAPI.clearMineverseChatPlayerMap();
        MineverseChatAPI.clearNameMap();
        MineverseChatAPI.clearOnlineMineverseChatPlayerMap();
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Disabling..."));
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Disabled Successfully"));
    }

    private void startRepeatingTasks() {
        BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
        scheduler.runTaskTimerAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                PlayerData.savePlayerData();
                if (MineverseChat.this.getConfig().getString("loglevel", "info").equals("debug")) {
                    Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Saving Player Data"));
                }
            }
        }, 0L, (long)(this.getConfig().getInt("saveinterval") * 1200));
        scheduler.runTaskTimerAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                for (MineverseChatPlayer p : MineverseChatAPI.getOnlineMineverseChatPlayers()) {
                    long currentTimeMillis = System.currentTimeMillis();
                    Iterator<MuteContainer> iterator = p.getMutes().iterator();
                    while (iterator.hasNext()) {
                        MuteContainer mute = iterator.next();
                        if (!ChatChannel.isChannel(mute.getChannel())) continue;
                        ChatChannel channel = ChatChannel.getChannel(mute.getChannel());
                        long timemark = mute.getDuration();
                        if (timemark == 0L) continue;
                        if (MineverseChat.this.getConfig().getString("loglevel", "info").equals("debug")) {
                            System.out.println(currentTimeMillis + " " + timemark);
                        }
                        if (currentTimeMillis < timemark) continue;
                        iterator.remove();
                        p.getPlayer().sendMessage(LocalizedMessage.UNMUTE_PLAYER_PLAYER.toString().replace("{player}", p.getName()).replace("{channel_color}", channel.getColor()).replace("{channel_name}", mute.getChannel()));
                        if (!channel.getBungee().booleanValue()) continue;
                        MineverseChat.synchronize(p, true);
                    }
                }
                if (MineverseChat.this.getConfig().getString("loglevel", "info").equals("trace")) {
                    Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Updating Player Mutes"));
                }
            }
        }, 0L, 60L);
    }

    private void registerListeners() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new Channel(), (Plugin)this);
        pluginManager.registerEvents((Listener)new ChatListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new SignListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new CommandListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new LoginListener(), (Plugin)this);
        if (VersionHandler.isUnder_1_19()) {
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketListenerLegacyChat());
        }
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider permissionProvider = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null) {
            permission = (Permission)permissionProvider.getProvider();
        }
        return permission != null;
    }

    private boolean setupChat() {
        RegisteredServiceProvider chatProvider = this.getServer().getServicesManager().getRegistration(Chat.class);
        if (chatProvider != null) {
            chat = (Chat)chatProvider.getProvider();
        }
        return chat != null;
    }

    public static MineverseChat getInstance() {
        return (MineverseChat)MineverseChat.getPlugin(MineverseChat.class);
    }

    public static void initializeConfigReaders() {
        Localization.initialize();
        Alias.initialize();
        JsonFormat.initialize();
        GuiSlot.initialize();
        ChatChannel.initialize();
    }

    public static Chat getVaultChat() {
        return chat;
    }

    public static Permission getVaultPermission() {
        return permission;
    }

    /*
     * WARNING - void declaration
     */
    public static void synchronize(final MineverseChatPlayer mcp, boolean changes) {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outstream);
        try {
            out.writeUTF("Sync");
            if (!changes) {
                out.writeUTF("Receive");
                out.writeUTF(mcp.getUUID().toString());
                Bukkit.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)MineverseChat.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        if (!mcp.isOnline() || mcp.hasPlayed()) {
                            return;
                        }
                        MineverseChat.synchronize(mcp, false);
                    }
                }, 20L);
            } else {
                void var6_14;
                ChatChannel channel;
                out.writeUTF("Update");
                out.writeUTF(mcp.getUUID().toString());
                int channelCount = 0;
                for (String string : mcp.getListening()) {
                    ChatChannel channel2 = ChatChannel.getChannel(string);
                    if (!channel2.getBungee().booleanValue()) continue;
                    ++channelCount;
                }
                out.write(channelCount);
                for (String string : mcp.getListening()) {
                    ChatChannel channel2 = ChatChannel.getChannel(string);
                    if (!channel2.getBungee().booleanValue()) continue;
                    out.writeUTF(channel2.getName());
                }
                int muteCount = 0;
                for (MuteContainer mute : mcp.getMutes()) {
                    channel = ChatChannel.getChannel(mute.getChannel());
                    if (!channel.getBungee().booleanValue()) continue;
                    ++muteCount;
                }
                out.write(muteCount);
                for (MuteContainer mute : mcp.getMutes()) {
                    channel = ChatChannel.getChannel(mute.getChannel());
                    if (!channel.getBungee().booleanValue()) continue;
                    out.writeUTF(channel.getName());
                    out.writeLong(mute.getDuration());
                    out.writeUTF(mute.getReason());
                }
                boolean bl = false;
                for (UUID c : mcp.getIgnores()) {
                    ++var6_14;
                }
                out.write((int)var6_14);
                for (UUID c : mcp.getIgnores()) {
                    out.writeUTF(c.toString());
                }
                out.writeBoolean(mcp.isSpy());
                out.writeBoolean(mcp.getMessageToggle());
            }
            MineverseChat.sendPluginMessage(outstream);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendPluginMessage(ByteArrayOutputStream byteOutStream) {
        if (MineverseChatAPI.getOnlineMineverseChatPlayers().size() > 0) {
            MineverseChatAPI.getOnlineMineverseChatPlayers().iterator().next().getPlayer().sendPluginMessage((Plugin)MineverseChat.getInstance(), PLUGIN_MESSAGING_CHANNEL, byteOutStream.toByteArray());
        }
    }

    public static void sendDiscordSRVPluginMessage(String chatChannel, String message) {
        if (MineverseChatAPI.getOnlineMineverseChatPlayers().size() == 0) {
            return;
        }
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOutStream);
        try {
            out.writeUTF("DiscordSRV");
            out.writeUTF(chatChannel);
            out.writeUTF(message);
            MineverseChat.sendPluginMessage(byteOutStream);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] inputStream) {
        if (!channel.equals(PLUGIN_MESSAGING_CHANNEL)) {
            return;
        }
        try {
            MineverseChatPlayer senderMCP;
            MineverseChatPlayer senderMCP2;
            ChatChannel chatChannelObj;
            int hash;
            DataInputStream msgin = new DataInputStream(new ByteArrayInputStream(inputStream));
            if (this.getConfig().getString("loglevel", "info").equals("debug")) {
                System.out.println(msgin.available() + " size on receiving end");
            }
            String subchannel = msgin.readUTF();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(stream);
            if (subchannel.equals("Chat")) {
                String server = msgin.readUTF();
                String chatchannel = msgin.readUTF();
                final String senderName = msgin.readUTF();
                UUID senderUUID = UUID.fromString(msgin.readUTF());
                hash = msgin.readInt();
                Iterator<MineverseChatPlayer> format = msgin.readUTF();
                String chat = msgin.readUTF();
                String consoleChat = (String)((Object)format) + chat;
                String globalJSON = msgin.readUTF();
                final String primaryGroup = msgin.readUTF();
                final String nickname = msgin.readUTF();
                if (!ChatChannel.isChannel(chatchannel)) {
                    return;
                }
                final ChatChannel chatChannelObject = ChatChannel.getChannel(chatchannel);
                if (!chatChannelObject.getBungee().booleanValue()) {
                    return;
                }
                final HashSet<Player> recipients = new HashSet<Player>();
                for (MineverseChatPlayer p : MineverseChatAPI.getOnlineMineverseChatPlayers()) {
                    if (!p.isListening(chatChannelObject.getName())) continue;
                    recipients.add(p.getPlayer());
                }
                Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)this, new Runnable(){
                    final /* synthetic */ String val$format;
                    final /* synthetic */ String val$chat;
                    final /* synthetic */ String val$globalJSON;
                    final /* synthetic */ int val$hash;
                    {
                        this.val$format = string4;
                        this.val$chat = string5;
                        this.val$globalJSON = string6;
                        this.val$hash = n;
                    }

                    @Override
                    public void run() {
                        VentureChatEvent ventureChatEvent = new VentureChatEvent(null, senderName, nickname, primaryGroup, chatChannelObject, recipients, recipients.size(), this.val$format, this.val$chat, this.val$globalJSON, this.val$hash, false);
                        Bukkit.getServer().getPluginManager().callEvent((Event)ventureChatEvent);
                    }
                });
                Bukkit.getConsoleSender().sendMessage(consoleChat);
                if (Database.isEnabled()) {
                    Database.writeVentureChat(senderUUID.toString(), senderName, server, chatchannel, chat.replace("'", "''"), "Chat");
                }
                for (MineverseChatPlayer p : MineverseChatAPI.getOnlineMineverseChatPlayers()) {
                    if (!p.isListening(chatChannelObject.getName()) || !p.getBungeeToggle() && MineverseChatAPI.getOnlineMineverseChatPlayer(senderName) == null) continue;
                    String json = Format.formatModerationGUI(globalJSON, p.getPlayer(), senderName, chatchannel, hash);
                    PacketContainer packet = Format.createPacketPlayOutChat(json);
                    if (this.getConfig().getBoolean("ignorechat", false)) {
                        if (p.getIgnores().contains(senderUUID)) continue;
                        Format.sendPacketPlayOutChat(p.getPlayer(), packet);
                        continue;
                    }
                    Format.sendPacketPlayOutChat(p.getPlayer(), packet);
                }
            }
            if (subchannel.equals("DiscordSRV")) {
                String chatChannel = msgin.readUTF();
                String message = msgin.readUTF();
                if (!ChatChannel.isChannel(chatChannel)) {
                    return;
                }
                ChatChannel chatChannelObj2 = ChatChannel.getChannel(chatChannel);
                if (!chatChannelObj2.getBungee().booleanValue()) {
                    return;
                }
                String json = Format.convertPlainTextToJson(message, true);
                hash = message.replaceAll("([\ufffd]([a-z0-9]))", "").hashCode();
                for (MineverseChatPlayer p : MineverseChatAPI.getOnlineMineverseChatPlayers()) {
                    if (!p.isListening(chatChannelObj2.getName())) continue;
                    String finalJSON = Format.formatModerationGUI(json, p.getPlayer(), "Discord", chatChannelObj2.getName(), hash);
                    PacketContainer packet = Format.createPacketPlayOutChat(finalJSON);
                    Format.sendPacketPlayOutChat(p.getPlayer(), packet);
                }
            }
            if (subchannel.equals("PlayerNames")) {
                MineverseChatAPI.clearNetworkPlayerNames();
                int playerCount = msgin.readInt();
                for (int a = 0; a < playerCount; ++a) {
                    MineverseChatAPI.addNetworkPlayerName(msgin.readUTF());
                }
            }
            if (subchannel.equals("Chwho")) {
                String identifier = msgin.readUTF();
                if (identifier.equals("Get")) {
                    String server = msgin.readUTF();
                    String sender = msgin.readUTF();
                    String chatchannel = msgin.readUTF();
                    ArrayList<String> listening = new ArrayList<String>();
                    if (ChatChannel.isChannel(chatchannel)) {
                        for (MineverseChatPlayer mcp : MineverseChatAPI.getOnlineMineverseChatPlayers()) {
                            if (!mcp.isListening(chatchannel)) continue;
                            String entry = "&f" + mcp.getName();
                            if (mcp.isMuted(chatchannel)) {
                                entry = "&c" + mcp.getName();
                            }
                            listening.add(entry);
                        }
                    }
                    out.writeUTF("Chwho");
                    out.writeUTF("Receive");
                    out.writeUTF(server);
                    out.writeUTF(sender);
                    out.writeUTF(chatchannel);
                    out.writeInt(listening.size());
                    for (String s : listening) {
                        out.writeUTF(s);
                    }
                    MineverseChat.sendPluginMessage(stream);
                }
                if (identifier.equals("Receive")) {
                    String sender = msgin.readUTF();
                    Object[] stringchannel = msgin.readUTF();
                    MineverseChatPlayer mcp = MineverseChatAPI.getOnlineMineverseChatPlayer(UUID.fromString(sender));
                    ChatChannel chatchannel = ChatChannel.getChannel((String)stringchannel);
                    String playerList = "";
                    int size = msgin.readInt();
                    for (int a = 0; a < size; ++a) {
                        playerList = playerList + msgin.readUTF() + ChatColor.WHITE + ", ";
                    }
                    if (playerList.length() > 2) {
                        playerList = playerList.substring(0, playerList.length() - 2);
                    }
                    mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_PLAYER_LIST_HEADER.toString().replace("{channel_color}", chatchannel.getColor().toString()).replace("{channel_name}", chatchannel.getName()));
                    mcp.getPlayer().sendMessage(Format.FormatStringAll(playerList));
                }
            }
            if (subchannel.equals("RemoveMessage")) {
                String hash2 = msgin.readUTF();
                this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), "removemessage " + hash2);
            }
            if (subchannel.equals("Sync")) {
                String uuid;
                MineverseChatPlayer p;
                if (this.getConfig().getString("loglevel", "info").equals("debug")) {
                    Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Received update..."));
                }
                if ((p = MineverseChatAPI.getOnlineMineverseChatPlayer(UUID.fromString(uuid = msgin.readUTF()))) == null || p.hasPlayed()) {
                    return;
                }
                for (Object ch : p.getListening().toArray()) {
                    String c = ch.toString();
                    ChatChannel cha = ChatChannel.getChannel(c);
                    if (!cha.getBungee().booleanValue()) continue;
                    p.removeListening(c);
                }
                int size = msgin.read();
                for (int a = 0; a < size; ++a) {
                    ChatChannel cha;
                    String ch = msgin.readUTF();
                    if (!ChatChannel.isChannel(ch) || (cha = ChatChannel.getChannel(ch)).hasPermission().booleanValue() && !p.getPlayer().hasPermission(cha.getPermission())) continue;
                    p.addListening(ch);
                }
                p.getMutes().removeIf(mute -> ChatChannel.getChannel(mute.getChannel()).getBungee());
                int sizeB = msgin.read();
                for (int b = 0; b < sizeB; ++b) {
                    Object ch;
                    ch = msgin.readUTF();
                    long muteTime = msgin.readLong();
                    String muteReason = msgin.readUTF();
                    if (!ChatChannel.isChannel((String)ch)) continue;
                    p.addMute((String)ch, muteTime, muteReason);
                }
                p.setSpy(msgin.readBoolean());
                p.setMessageToggle(msgin.readBoolean());
                for (Object o : p.getIgnores().toArray()) {
                    p.removeIgnore((UUID)o);
                }
                int sizeC = msgin.read();
                for (int c = 0; c < sizeC; ++c) {
                    String i = msgin.readUTF();
                    p.addIgnore(UUID.fromString(i));
                }
                if (!p.hasPlayed()) {
                    boolean isThereABungeeChannel = false;
                    for (ChatChannel ch : ChatChannel.getAutojoinList()) {
                        if (ch.hasPermission().booleanValue() && !p.getPlayer().hasPermission(ch.getPermission()) || p.isListening(ch.getName())) continue;
                        p.addListening(ch.getName());
                        if (!ch.getBungee().booleanValue()) continue;
                        isThereABungeeChannel = true;
                    }
                    p.setHasPlayed(true);
                    if (isThereABungeeChannel) {
                        MineverseChat.synchronize(p, true);
                    }
                }
            }
            if (subchannel.equals("Ignore")) {
                String identifier = msgin.readUTF();
                if (identifier.equals("Send")) {
                    String server = msgin.readUTF();
                    String receiver = msgin.readUTF();
                    MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(receiver);
                    UUID sender = UUID.fromString(msgin.readUTF());
                    if (!this.getConfig().getBoolean("bungeecordmessaging", true) || p == null || !p.isOnline()) {
                        out.writeUTF("Ignore");
                        out.writeUTF("Offline");
                        out.writeUTF(server);
                        out.writeUTF(receiver);
                        out.writeUTF(sender.toString());
                        MineverseChat.sendPluginMessage(stream);
                        return;
                    }
                    if (p.getPlayer().hasPermission("venturechat.ignore.bypass")) {
                        out.writeUTF("Ignore");
                        out.writeUTF("Bypass");
                        out.writeUTF(server);
                        out.writeUTF(receiver);
                        out.writeUTF(sender.toString());
                        MineverseChat.sendPluginMessage(stream);
                        return;
                    }
                    out.writeUTF("Ignore");
                    out.writeUTF("Echo");
                    out.writeUTF(server);
                    out.writeUTF(p.getUUID().toString());
                    out.writeUTF(receiver);
                    out.writeUTF(sender.toString());
                    MineverseChat.sendPluginMessage(stream);
                    return;
                }
                if (identifier.equals("Offline")) {
                    String receiver = msgin.readUTF();
                    UUID sender = UUID.fromString(msgin.readUTF());
                    MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                    p.getPlayer().sendMessage(LocalizedMessage.PLAYER_OFFLINE.toString().replace("{args}", receiver));
                }
                if (identifier.equals("Echo")) {
                    UUID receiver = UUID.fromString(msgin.readUTF());
                    String receiverName = msgin.readUTF();
                    UUID sender = UUID.fromString(msgin.readUTF());
                    MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                    if (p.getIgnores().contains(receiver)) {
                        p.getPlayer().sendMessage(LocalizedMessage.IGNORE_PLAYER_OFF.toString().replace("{player}", receiverName));
                        p.removeIgnore(receiver);
                        MineverseChat.synchronize(p, true);
                        return;
                    }
                    p.addIgnore(receiver);
                    p.getPlayer().sendMessage(LocalizedMessage.IGNORE_PLAYER_ON.toString().replace("{player}", receiverName));
                    MineverseChat.synchronize(p, true);
                }
                if (identifier.equals("Bypass")) {
                    String receiver = msgin.readUTF();
                    UUID sender = UUID.fromString(msgin.readUTF());
                    MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                    p.getPlayer().sendMessage(LocalizedMessage.IGNORE_PLAYER_CANT.toString().replace("{player}", receiver));
                }
            }
            if (subchannel.equals("Mute")) {
                String identifier = msgin.readUTF();
                if (identifier.equals("Send")) {
                    String server = msgin.readUTF();
                    String senderIdentifier = msgin.readUTF();
                    String temporaryDataInstanceUUIDString = msgin.readUTF();
                    String playerToMute = msgin.readUTF();
                    String channelName = msgin.readUTF();
                    long time = msgin.readLong();
                    String reason = msgin.readUTF();
                    MineverseChatPlayer playerToMuteMCP = MineverseChatAPI.getOnlineMineverseChatPlayer(playerToMute);
                    if (playerToMuteMCP == null) {
                        out.writeUTF("Mute");
                        out.writeUTF("Offline");
                        out.writeUTF(server);
                        out.writeUTF(temporaryDataInstanceUUIDString);
                        out.writeUTF(senderIdentifier);
                        out.writeUTF(playerToMute);
                        MineverseChat.sendPluginMessage(stream);
                        return;
                    }
                    if (!ChatChannel.isChannel(channelName)) {
                        return;
                    }
                    ChatChannel chatChannelObj3 = ChatChannel.getChannel(channelName);
                    if (playerToMuteMCP.isMuted(chatChannelObj3.getName())) {
                        out.writeUTF("Mute");
                        out.writeUTF("AlreadyMuted");
                        out.writeUTF(server);
                        out.writeUTF(senderIdentifier);
                        out.writeUTF(playerToMute);
                        out.writeUTF(channelName);
                        MineverseChat.sendPluginMessage(stream);
                        return;
                    }
                    if (time > 0L) {
                        String timeString;
                        long datetime = System.currentTimeMillis();
                        if (reason.isEmpty()) {
                            playerToMuteMCP.addMute(chatChannelObj3.getName(), datetime + time);
                            timeString = Format.parseTimeStringFromMillis(time);
                            playerToMuteMCP.getPlayer().sendMessage(LocalizedMessage.MUTE_PLAYER_PLAYER_TIME.toString().replace("{channel_color}", chatChannelObj3.getColor()).replace("{channel_name}", chatChannelObj3.getName()).replace("{time}", timeString));
                        } else {
                            playerToMuteMCP.addMute(chatChannelObj3.getName(), datetime + time, reason);
                            timeString = Format.parseTimeStringFromMillis(time);
                            playerToMuteMCP.getPlayer().sendMessage(LocalizedMessage.MUTE_PLAYER_PLAYER_TIME_REASON.toString().replace("{channel_color}", chatChannelObj3.getColor()).replace("{channel_name}", chatChannelObj3.getName()).replace("{time}", timeString).replace("{reason}", reason));
                        }
                    } else if (reason.isEmpty()) {
                        playerToMuteMCP.addMute(chatChannelObj3.getName());
                        playerToMuteMCP.getPlayer().sendMessage(LocalizedMessage.MUTE_PLAYER_PLAYER.toString().replace("{channel_color}", chatChannelObj3.getColor()).replace("{channel_name}", chatChannelObj3.getName()));
                    } else {
                        playerToMuteMCP.addMute(chatChannelObj3.getName(), reason);
                        playerToMuteMCP.getPlayer().sendMessage(LocalizedMessage.MUTE_PLAYER_PLAYER_REASON.toString().replace("{channel_color}", chatChannelObj3.getColor()).replace("{channel_name}", chatChannelObj3.getName()).replace("{reason}", reason));
                    }
                    MineverseChat.synchronize(playerToMuteMCP, true);
                    out.writeUTF("Mute");
                    out.writeUTF("Valid");
                    out.writeUTF(server);
                    out.writeUTF(senderIdentifier);
                    out.writeUTF(playerToMute);
                    out.writeUTF(channelName);
                    out.writeLong(time);
                    out.writeUTF(reason);
                    MineverseChat.sendPluginMessage(stream);
                    return;
                }
                if (identifier.equals("Valid")) {
                    MineverseChatPlayer senderMCP3;
                    UUID sender;
                    String senderIdentifier = msgin.readUTF();
                    String playerToMute = msgin.readUTF();
                    String channelName = msgin.readUTF();
                    long time = msgin.readLong();
                    String reason = msgin.readUTF();
                    if (!ChatChannel.isChannel(channelName)) {
                        return;
                    }
                    chatChannelObj = ChatChannel.getChannel(channelName);
                    if (time > 0L) {
                        UUID sender2;
                        String timeString = Format.parseTimeStringFromMillis(time);
                        if (reason.isEmpty()) {
                            if (senderIdentifier.equals("VentureChat:Console")) {
                                Bukkit.getConsoleSender().sendMessage(LocalizedMessage.MUTE_PLAYER_SENDER_TIME.toString().replace("{player}", playerToMute).replace("{channel_color}", chatChannelObj.getColor()).replace("{channel_name}", chatChannelObj.getName()).replace("{time}", timeString));
                            } else {
                                sender2 = UUID.fromString(senderIdentifier);
                                senderMCP2 = MineverseChatAPI.getOnlineMineverseChatPlayer(sender2);
                                senderMCP2.getPlayer().sendMessage(LocalizedMessage.MUTE_PLAYER_SENDER_TIME.toString().replace("{player}", playerToMute).replace("{channel_color}", chatChannelObj.getColor()).replace("{channel_name}", chatChannelObj.getName()).replace("{time}", timeString));
                            }
                        } else if (senderIdentifier.equals("VentureChat:Console")) {
                            Bukkit.getConsoleSender().sendMessage(LocalizedMessage.MUTE_PLAYER_SENDER_TIME_REASON.toString().replace("{player}", playerToMute).replace("{channel_color}", chatChannelObj.getColor()).replace("{channel_name}", chatChannelObj.getName()).replace("{time}", timeString).replace("{reason}", reason));
                        } else {
                            sender2 = UUID.fromString(senderIdentifier);
                            senderMCP2 = MineverseChatAPI.getOnlineMineverseChatPlayer(sender2);
                            senderMCP2.getPlayer().sendMessage(LocalizedMessage.MUTE_PLAYER_SENDER_TIME_REASON.toString().replace("{player}", playerToMute).replace("{channel_color}", chatChannelObj.getColor()).replace("{channel_name}", chatChannelObj.getName()).replace("{time}", timeString).replace("{reason}", reason));
                        }
                    } else if (reason.isEmpty()) {
                        if (senderIdentifier.equals("VentureChat:Console")) {
                            Bukkit.getConsoleSender().sendMessage(LocalizedMessage.MUTE_PLAYER_SENDER.toString().replace("{player}", playerToMute).replace("{channel_color}", chatChannelObj.getColor()).replace("{channel_name}", chatChannelObj.getName()));
                        } else {
                            sender = UUID.fromString(senderIdentifier);
                            senderMCP3 = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                            senderMCP3.getPlayer().sendMessage(LocalizedMessage.MUTE_PLAYER_SENDER.toString().replace("{player}", playerToMute).replace("{channel_color}", chatChannelObj.getColor()).replace("{channel_name}", chatChannelObj.getName()));
                        }
                    } else if (senderIdentifier.equals("VentureChat:Console")) {
                        Bukkit.getConsoleSender().sendMessage(LocalizedMessage.MUTE_PLAYER_SENDER_REASON.toString().replace("{player}", playerToMute).replace("{channel_color}", chatChannelObj.getColor()).replace("{channel_name}", chatChannelObj.getName()).replace("{reason}", reason));
                    } else {
                        sender = UUID.fromString(senderIdentifier);
                        senderMCP3 = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                        senderMCP3.getPlayer().sendMessage(LocalizedMessage.MUTE_PLAYER_SENDER_REASON.toString().replace("{player}", playerToMute).replace("{channel_color}", chatChannelObj.getColor()).replace("{channel_name}", chatChannelObj.getName()).replace("{reason}", reason));
                    }
                    return;
                }
                if (identifier.equals("Offline")) {
                    String senderIdentifier = msgin.readUTF();
                    String playerToMute = msgin.readUTF();
                    if (senderIdentifier.equals("VentureChat:Console")) {
                        Bukkit.getConsoleSender().sendMessage(LocalizedMessage.PLAYER_OFFLINE.toString().replace("{args}", playerToMute));
                        return;
                    }
                    UUID sender = UUID.fromString(senderIdentifier);
                    MineverseChatPlayer senderMCP4 = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                    senderMCP4.getPlayer().sendMessage(LocalizedMessage.PLAYER_OFFLINE.toString().replace("{args}", playerToMute));
                    return;
                }
                if (identifier.equals("AlreadyMuted")) {
                    String senderIdentifier = msgin.readUTF();
                    String playerToMute = msgin.readUTF();
                    String channelName = msgin.readUTF();
                    if (!ChatChannel.isChannel(channelName)) {
                        return;
                    }
                    ChatChannel chatChannelObj4 = ChatChannel.getChannel(channelName);
                    if (senderIdentifier.equals("VentureChat:Console")) {
                        Bukkit.getConsoleSender().sendMessage(LocalizedMessage.PLAYER_ALREADY_MUTED.toString().replace("{player}", playerToMute).replace("{channel_color}", chatChannelObj4.getColor()).replace("{channel_name}", chatChannelObj4.getName()));
                        return;
                    }
                    UUID sender = UUID.fromString(senderIdentifier);
                    senderMCP = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                    senderMCP.getPlayer().sendMessage(LocalizedMessage.PLAYER_ALREADY_MUTED.toString().replace("{player}", playerToMute).replace("{channel_color}", chatChannelObj4.getColor()).replace("{channel_name}", chatChannelObj4.getName()));
                    return;
                }
            }
            if (subchannel.equals("Unmute")) {
                String identifier = msgin.readUTF();
                if (identifier.equals("Send")) {
                    String server = msgin.readUTF();
                    String senderIdentifier = msgin.readUTF();
                    String temporaryDataInstanceUUIDString = msgin.readUTF();
                    String playerToUnmute = msgin.readUTF();
                    String channelName = msgin.readUTF();
                    MineverseChatPlayer playerToUnmuteMCP = MineverseChatAPI.getOnlineMineverseChatPlayer(playerToUnmute);
                    if (playerToUnmuteMCP == null) {
                        out.writeUTF("Unmute");
                        out.writeUTF("Offline");
                        out.writeUTF(server);
                        out.writeUTF(temporaryDataInstanceUUIDString);
                        out.writeUTF(senderIdentifier);
                        out.writeUTF(playerToUnmute);
                        MineverseChat.sendPluginMessage(stream);
                        return;
                    }
                    if (!ChatChannel.isChannel(channelName)) {
                        return;
                    }
                    chatChannelObj = ChatChannel.getChannel(channelName);
                    if (!playerToUnmuteMCP.isMuted(chatChannelObj.getName())) {
                        out.writeUTF("Unmute");
                        out.writeUTF("NotMuted");
                        out.writeUTF(server);
                        out.writeUTF(senderIdentifier);
                        out.writeUTF(playerToUnmute);
                        out.writeUTF(channelName);
                        MineverseChat.sendPluginMessage(stream);
                        return;
                    }
                    playerToUnmuteMCP.removeMute(chatChannelObj.getName());
                    playerToUnmuteMCP.getPlayer().sendMessage(LocalizedMessage.UNMUTE_PLAYER_PLAYER.toString().replace("{player}", player.getName()).replace("{channel_color}", chatChannelObj.getColor()).replace("{channel_name}", chatChannelObj.getName()));
                    MineverseChat.synchronize(playerToUnmuteMCP, true);
                    out.writeUTF("Unmute");
                    out.writeUTF("Valid");
                    out.writeUTF(server);
                    out.writeUTF(senderIdentifier);
                    out.writeUTF(playerToUnmute);
                    out.writeUTF(channelName);
                    MineverseChat.sendPluginMessage(stream);
                    return;
                }
                if (identifier.equals("Valid")) {
                    String senderIdentifier = msgin.readUTF();
                    String playerToUnmute = msgin.readUTF();
                    String channelName = msgin.readUTF();
                    if (!ChatChannel.isChannel(channelName)) {
                        return;
                    }
                    ChatChannel chatChannelObj5 = ChatChannel.getChannel(channelName);
                    if (senderIdentifier.equals("VentureChat:Console")) {
                        Bukkit.getConsoleSender().sendMessage(LocalizedMessage.UNMUTE_PLAYER_SENDER.toString().replace("{player}", playerToUnmute).replace("{channel_color}", chatChannelObj5.getColor()).replace("{channel_name}", chatChannelObj5.getName()));
                    } else {
                        UUID sender = UUID.fromString(senderIdentifier);
                        senderMCP = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                        senderMCP.getPlayer().sendMessage(LocalizedMessage.UNMUTE_PLAYER_SENDER.toString().replace("{player}", playerToUnmute).replace("{channel_color}", chatChannelObj5.getColor()).replace("{channel_name}", chatChannelObj5.getName()));
                    }
                    return;
                }
                if (identifier.equals("Offline")) {
                    String senderIdentifier = msgin.readUTF();
                    String playerToUnmute = msgin.readUTF();
                    if (senderIdentifier.equals("VentureChat:Console")) {
                        Bukkit.getConsoleSender().sendMessage(LocalizedMessage.PLAYER_OFFLINE.toString().replace("{args}", playerToUnmute));
                        return;
                    }
                    UUID sender = UUID.fromString(senderIdentifier);
                    MineverseChatPlayer senderMCP5 = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                    senderMCP5.getPlayer().sendMessage(LocalizedMessage.PLAYER_OFFLINE.toString().replace("{args}", playerToUnmute));
                    return;
                }
                if (identifier.equals("NotMuted")) {
                    String senderIdentifier = msgin.readUTF();
                    String playerToUnmute = msgin.readUTF();
                    String channelName = msgin.readUTF();
                    if (!ChatChannel.isChannel(channelName)) {
                        return;
                    }
                    ChatChannel chatChannelObj6 = ChatChannel.getChannel(channelName);
                    if (senderIdentifier.equals("VentureChat:Console")) {
                        Bukkit.getConsoleSender().sendMessage(LocalizedMessage.PLAYER_NOT_MUTED.toString().replace("{player}", playerToUnmute).replace("{channel_color}", chatChannelObj6.getColor()).replace("{channel_name}", chatChannelObj6.getName()));
                        return;
                    }
                    UUID sender = UUID.fromString(senderIdentifier);
                    senderMCP = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                    senderMCP.getPlayer().sendMessage(LocalizedMessage.PLAYER_NOT_MUTED.toString().replace("{player}", playerToUnmute).replace("{channel_color}", chatChannelObj6.getColor()).replace("{channel_name}", chatChannelObj6.getName()));
                    return;
                }
            }
            if (subchannel.equals("Message")) {
                String identifier = msgin.readUTF();
                if (identifier.equals("Send")) {
                    String server = msgin.readUTF();
                    String receiver = msgin.readUTF();
                    MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(receiver);
                    UUID sender = UUID.fromString(msgin.readUTF());
                    String sName = msgin.readUTF();
                    String send = msgin.readUTF();
                    String echo = msgin.readUTF();
                    String spy = msgin.readUTF();
                    String msg = msgin.readUTF();
                    if (!this.getConfig().getBoolean("bungeecordmessaging", true) || p == null) {
                        out.writeUTF("Message");
                        out.writeUTF("Offline");
                        out.writeUTF(server);
                        out.writeUTF(receiver);
                        out.writeUTF(sender.toString());
                        MineverseChat.sendPluginMessage(stream);
                        return;
                    }
                    if (p.getIgnores().contains(sender)) {
                        out.writeUTF("Message");
                        out.writeUTF("Ignore");
                        out.writeUTF(server);
                        out.writeUTF(receiver);
                        out.writeUTF(sender.toString());
                        MineverseChat.sendPluginMessage(stream);
                        return;
                    }
                    if (!p.getMessageToggle()) {
                        out.writeUTF("Message");
                        out.writeUTF("Blocked");
                        out.writeUTF(server);
                        out.writeUTF(receiver);
                        out.writeUTF(sender.toString());
                        MineverseChat.sendPluginMessage(stream);
                        return;
                    }
                    p.getPlayer().sendMessage(Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)p.getPlayer(), (String)send.replaceAll("receiver_", ""))) + msg);
                    if (p.hasNotifications()) {
                        Format.playMessageSound(p);
                    }
                    if (MineverseChatAPI.getMineverseChatPlayer(sender) == null) {
                        senderMCP2 = new MineverseChatPlayer(sender, sName);
                        MineverseChatAPI.addMineverseChatPlayerToMap(senderMCP2);
                        MineverseChatAPI.addNameToMap(senderMCP2);
                    }
                    p.setReplyPlayer(sender);
                    out.writeUTF("Message");
                    out.writeUTF("Echo");
                    out.writeUTF(server);
                    out.writeUTF(receiver);
                    out.writeUTF(p.getUUID().toString());
                    out.writeUTF(sender.toString());
                    out.writeUTF(sName);
                    out.writeUTF(Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)p.getPlayer(), (String)echo.replaceAll("receiver_", ""))) + msg);
                    out.writeUTF(Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)p.getPlayer(), (String)spy.replaceAll("receiver_", ""))) + msg);
                    MineverseChat.sendPluginMessage(stream);
                    return;
                }
                if (identifier.equals("Offline")) {
                    String receiver = msgin.readUTF();
                    UUID sender = UUID.fromString(msgin.readUTF());
                    MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                    p.getPlayer().sendMessage(LocalizedMessage.PLAYER_OFFLINE.toString().replace("{args}", receiver));
                    p.setReplyPlayer(null);
                }
                if (identifier.equals("Ignore")) {
                    String receiver = msgin.readUTF();
                    UUID sender = UUID.fromString(msgin.readUTF());
                    MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                    p.getPlayer().sendMessage(LocalizedMessage.IGNORING_MESSAGE.toString().replace("{player}", receiver));
                }
                if (identifier.equals("Blocked")) {
                    String receiver = msgin.readUTF();
                    UUID sender = UUID.fromString(msgin.readUTF());
                    MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                    p.getPlayer().sendMessage(LocalizedMessage.BLOCKING_MESSAGE.toString().replace("{player}", receiver));
                }
                if (identifier.equals("Echo")) {
                    String receiverName = msgin.readUTF();
                    UUID receiverUUID = UUID.fromString(msgin.readUTF());
                    UUID senderUUID = UUID.fromString(msgin.readUTF());
                    MineverseChatPlayer senderMCP6 = MineverseChatAPI.getOnlineMineverseChatPlayer(senderUUID);
                    String echo = msgin.readUTF();
                    if (MineverseChatAPI.getMineverseChatPlayer(receiverUUID) == null) {
                        MineverseChatPlayer receiverMCP = new MineverseChatPlayer(receiverUUID, receiverName);
                        MineverseChatAPI.addMineverseChatPlayerToMap(receiverMCP);
                        MineverseChatAPI.addNameToMap(receiverMCP);
                    }
                    senderMCP6.setReplyPlayer(receiverUUID);
                    senderMCP6.getPlayer().sendMessage(echo);
                }
                if (identifier.equals("Spy")) {
                    String receiverName = msgin.readUTF();
                    String senderName = msgin.readUTF();
                    String spy = msgin.readUTF();
                    if (!spy.startsWith("VentureChat:NoSpy")) {
                        for (MineverseChatPlayer pl : MineverseChatAPI.getOnlineMineverseChatPlayers()) {
                            if (!pl.isSpy() || pl.getName().equals(senderName) || pl.getName().equals(receiverName)) continue;
                            pl.getPlayer().sendMessage(spy);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        players = new HashSet<MineverseChatPlayer>();
        onlinePlayers = new HashSet<MineverseChatPlayer>();
        permission = null;
        chat = null;
    }
}

