(* Trigonometric tables.

   These tables are defined by Allegro itself, but for some reason can't import
   them properly so I copied and ported directly from Allegro 4.4.1.1.
 *)

  var
  (*** @exclude *)
    _al_fix_cos_tbl: array [0..511] of AL_FIXED = (
    (* precalculated fixed point (16.16) cosines for a full circle (0-255) *)
      65536,  65531,  65516,  65492,  65457,  65413,  65358,  65294,
      65220,  65137,  65043,  64940,  64827,  64704,  64571,  64429,
      64277,  64115,  63944,  63763,  63572,  63372,  63162,  62943,
      62714,  62476,  62228,  61971,  61705,  61429,  61145,  60851,
      60547,  60235,  59914,  59583,  59244,  58896,  58538,  58172,
      57798,  57414,  57022,  56621,  56212,  55794,  55368,  54934,
      54491,  54040,  53581,  53114,  52639,  52156,  51665,  51166,
      50660,  50146,  49624,  49095,  48559,  48015,  47464,  46906,
      46341,  45769,  45190,  44604,  44011,  43412,  42806,  42194,
      41576,  40951,  40320,  39683,  39040,  38391,  37736,  37076,
      36410,  35738,  35062,  34380,  33692,  33000,  32303,  31600,
      30893,  30182,  29466,  28745,  28020,  27291,  26558,  25821,
      25080,  24335,  23586,  22834,  22078,  21320,  20557,  19792,
      19024,  18253,  17479,  16703,  15924,  15143,  14359,  13573,
      12785,  11996,  11204,  10411,  9616,   8820,   8022,   7224,
      6424,   5623,   4821,   4019,   3216,   2412,   1608,   804,
      0,      -804,   -1608,  -2412,  -3216,  -4019,  -4821,  -5623,
      -6424,  -7224,  -8022,  -8820,  -9616,  -10411, -11204, -11996,
      -12785, -13573, -14359, -15143, -15924, -16703, -17479, -18253,
      -19024, -19792, -20557, -21320, -22078, -22834, -23586, -24335,
      -25080, -25821, -26558, -27291, -28020, -28745, -29466, -30182,
      -30893, -31600, -32303, -33000, -33692, -34380, -35062, -35738,
      -36410, -37076, -37736, -38391, -39040, -39683, -40320, -40951,
      -41576, -42194, -42806, -43412, -44011, -44604, -45190, -45769,
      -46341, -46906, -47464, -48015, -48559, -49095, -49624, -50146,
      -50660, -51166, -51665, -52156, -52639, -53114, -53581, -54040,
      -54491, -54934, -55368, -55794, -56212, -56621, -57022, -57414,
      -57798, -58172, -58538, -58896, -59244, -59583, -59914, -60235,
      -60547, -60851, -61145, -61429, -61705, -61971, -62228, -62476,
      -62714, -62943, -63162, -63372, -63572, -63763, -63944, -64115,
      -64277, -64429, -64571, -64704, -64827, -64940, -65043, -65137,
      -65220, -65294, -65358, -65413, -65457, -65492, -65516, -65531,
      -65536, -65531, -65516, -65492, -65457, -65413, -65358, -65294,
      -65220, -65137, -65043, -64940, -64827, -64704, -64571, -64429,
      -64277, -64115, -63944, -63763, -63572, -63372, -63162, -62943,
      -62714, -62476, -62228, -61971, -61705, -61429, -61145, -60851,
      -60547, -60235, -59914, -59583, -59244, -58896, -58538, -58172,
      -57798, -57414, -57022, -56621, -56212, -55794, -55368, -54934,
      -54491, -54040, -53581, -53114, -52639, -52156, -51665, -51166,
      -50660, -50146, -49624, -49095, -48559, -48015, -47464, -46906,
      -46341, -45769, -45190, -44604, -44011, -43412, -42806, -42194,
      -41576, -40951, -40320, -39683, -39040, -38391, -37736, -37076,
      -36410, -35738, -35062, -34380, -33692, -33000, -32303, -31600,
      -30893, -30182, -29466, -28745, -28020, -27291, -26558, -25821,
      -25080, -24335, -23586, -22834, -22078, -21320, -20557, -19792,
      -19024, -18253, -17479, -16703, -15924, -15143, -14359, -13573,
      -12785, -11996, -11204, -10411, -9616,  -8820,  -8022,  -7224,
      -6424,  -5623,  -4821,  -4019,  -3216,  -2412,  -1608,  -804,
      0,      804,    1608,   2412,   3216,   4019,   4821,   5623,
      6424,   7224,   8022,   8820,   9616,   10411,  11204,  11996,
      12785,  13573,  14359,  15143,  15924,  16703,  17479,  18253,
      19024,  19792,  20557,  21320,  22078,  22834,  23586,  24335,
      25080,  25821,  26558,  27291,  28020,  28745,  29466,  30182,
      30893,  31600,  32303,  33000,  33692,  34380,  35062,  35738,
      36410,  37076,  37736,  38391,  39040,  39683,  40320,  40951,
      41576,  42194,  42806,  43412,  44011,  44604,  45190,  45769,
      46341,  46906,  47464,  48015,  48559,  49095,  49624,  50146,
      50660,  51166,  51665,  52156,  52639,  53114,  53581,  54040,
      54491,  54934,  55368,  55794,  56212,  56621,  57022,  57414,
      57798,  58172,  58538,  58896,  59244,  59583,  59914,  60235,
      60547,  60851,  61145,  61429,  61705,  61971,  62228,  62476,
      62714,  62943,  63162,  63372,  63572,  63763,  63944,  64115,
      64277,  64429,  64571,  64704,  64827,  64940,  65043,  65137,
      65220,  65294,  65358,  65413,  65457,  65492,  65516,  65531
    );
  (*** @exclude *)
    _al_fix_tan_tbl: array [0..255] of AL_FIXED = (
    (* precalculated fixed point (16.16) tangents for a half circle (0-127) *)
      0,      804,    1609,   2414,   3220,   4026,   4834,   5644,
      6455,   7268,   8083,   8901,   9721,   10545,  11372,  12202,
      13036,  13874,  14717,  15564,  16416,  17273,  18136,  19005,
      19880,  20762,  21650,  22546,  23449,  24360,  25280,  26208,
      27146,  28093,  29050,  30018,  30996,  31986,  32988,  34002,
      35030,  36071,  37126,  38196,  39281,  40382,  41500,  42636,
      43790,  44963,  46156,  47369,  48605,  49863,  51145,  52451,
      53784,  55144,  56532,  57950,  59398,  60880,  62395,  63947,
      65536,  67165,  68835,  70548,  72308,  74116,  75974,  77887,
      79856,  81885,  83977,  86135,  88365,  90670,  93054,  95523,
      98082,  100736, 103493, 106358, 109340, 112447, 115687, 119071,
      122609, 126314, 130198, 134276, 138564, 143081, 147847, 152884,
      158218, 163878, 169896, 176309, 183161, 190499, 198380, 206870,
      216043, 225990, 236817, 248648, 261634, 275959, 291845, 309568,
      329472, 351993, 377693, 407305, 441808, 482534, 531352, 590958,
      665398, 761030, 888450, 1066730,1334016,1779314,2669641,5340086,
      -2147483647,-5340086,-2669641,-1779314,-1334016,-1066730,-888450,-761030,
      -665398,-590958,-531352,-482534,-441808,-407305,-377693,-351993,
      -329472,-309568,-291845,-275959,-261634,-248648,-236817,-225990,
      -216043,-206870,-198380,-190499,-183161,-176309,-169896,-163878,
      -158218,-152884,-147847,-143081,-138564,-134276,-130198,-126314,
      -122609,-119071,-115687,-112447,-109340,-106358,-103493,-100736,
      -98082, -95523, -93054, -90670, -88365, -86135, -83977, -81885,
      -79856, -77887, -75974, -74116, -72308, -70548, -68835, -67165,
      -65536, -63947, -62395, -60880, -59398, -57950, -56532, -55144,
      -53784, -52451, -51145, -49863, -48605, -47369, -46156, -44963,
      -43790, -42636, -41500, -40382, -39281, -38196, -37126, -36071,
      -35030, -34002, -32988, -31986, -30996, -30018, -29050, -28093,
      -27146, -26208, -25280, -24360, -23449, -22546, -21650, -20762,
      -19880, -19005, -18136, -17273, -16416, -15564, -14717, -13874,
      -13036, -12202, -11372, -10545, -9721,  -8901,  -8083,  -7268,
      -6455,  -5644,  -4834,  -4026,  -3220,  -2414,  -1609,  -804
    );


  (*** @exclude *)
    _al_fix_acos_tbl: array [0..512] of AL_FIXED = (
    (* precalculated fixed point (16.16) inverse cosines (-1 to 1) *)
      $800000,  $7C65C7,  $7AE75A,  $79C19E,  $78C9BE,  $77EF25,  $772953,  $76733A,
      $75C991,  $752A10,  $74930C,  $740345,  $7379C1,  $72F5BA,  $72768F,  $71FBBC,
      $7184D3,  $711174,  $70A152,  $703426,  $6FC9B5,  $6F61C9,  $6EFC36,  $6E98D1,
      $6E3777,  $6DD805,  $6D7A5E,  $6D1E68,  $6CC40B,  $6C6B2F,  $6C13C1,  $6BBDAF,
      $6B68E6,  $6B1558,  $6AC2F5,  $6A71B1,  $6A217E,  $69D251,  $698420,  $6936DF,
      $68EA85,  $689F0A,  $685465,  $680A8D,  $67C17D,  $67792C,  $673194,  $66EAAF,
      $66A476,  $665EE5,  $6619F5,  $65D5A2,  $6591E7,  $654EBF,  $650C26,  $64CA18,
      $648890,  $64478C,  $640706,  $63C6FC,  $63876B,  $63484F,  $6309A5,  $62CB6A,
      $628D9C,  $625037,  $621339,  $61D69F,  $619A68,  $615E90,  $612316,  $60E7F7,
      $60AD31,  $6072C3,  $6038A9,  $5FFEE3,  $5FC56E,  $5F8C49,  $5F5372,  $5F1AE7,
      $5EE2A7,  $5EAAB0,  $5E7301,  $5E3B98,  $5E0473,  $5DCD92,  $5D96F3,  $5D6095,
      $5D2A76,  $5CF496,  $5CBEF2,  $5C898B,  $5C545E,  $5C1F6B,  $5BEAB0,  $5BB62D,
      $5B81E1,  $5B4DCA,  $5B19E7,  $5AE638,  $5AB2BC,  $5A7F72,  $5A4C59,  $5A1970,
      $59E6B6,  $59B42A,  $5981CC,  $594F9B,  $591D96,  $58EBBD,  $58BA0E,  $588889,
      $58572D,  $5825FA,  $57F4EE,  $57C40A,  $57934D,  $5762B5,  $573243,  $5701F5,
      $56D1CC,  $56A1C6,  $5671E4,  $564224,  $561285,  $55E309,  $55B3AD,  $558471,
      $555555,  $552659,  $54F77B,  $54C8BC,  $549A1B,  $546B98,  $543D31,  $540EE7,
      $53E0B9,  $53B2A7,  $5384B0,  $5356D4,  $532912,  $52FB6B,  $52CDDD,  $52A068,
      $52730C,  $5245C9,  $52189E,  $51EB8B,  $51BE8F,  $5191AA,  $5164DC,  $513825,
      $510B83,  $50DEF7,  $50B280,  $50861F,  $5059D2,  $502D99,  $500175,  $4FD564,
      $4FA967,  $4F7D7D,  $4F51A6,  $4F25E2,  $4EFA30,  $4ECE90,  $4EA301,  $4E7784,
      $4E4C19,  $4E20BE,  $4DF574,  $4DCA3A,  $4D9F10,  $4D73F6,  $4D48EC,  $4D1DF1,
      $4CF305,  $4CC829,  $4C9D5A,  $4C729A,  $4C47E9,  $4C1D45,  $4BF2AE,  $4BC826,
      $4B9DAA,  $4B733B,  $4B48D9,  $4B1E84,  $4AF43B,  $4AC9FE,  $4A9FCD,  $4A75A7,
      $4A4B8D,  $4A217E,  $49F77A,  $49CD81,  $49A393,  $4979AF,  $494FD5,  $492605,
      $48FC3F,  $48D282,  $48A8CF,  $487F25,  $485584,  $482BEC,  $48025D,  $47D8D6,
      $47AF57,  $4785E0,  $475C72,  $47330A,  $4709AB,  $46E052,  $46B701,  $468DB7,
      $466474,  $463B37,  $461201,  $45E8D0,  $45BFA6,  $459682,  $456D64,  $45444B,
      $451B37,  $44F229,  $44C920,  $44A01C,  $44771C,  $444E21,  $44252A,  $43FC38,
      $43D349,  $43AA5F,  $438178,  $435894,  $432FB4,  $4306D8,  $42DDFE,  $42B527,
      $428C53,  $426381,  $423AB2,  $4211E5,  $41E91A,  $41C051,  $41978A,  $416EC5,
      $414601,  $411D3E,  $40F47C,  $40CBBB,  $40A2FB,  $407A3C,  $40517D,  $4028BE,
      $400000,  $3FD742,  $3FAE83,  $3F85C4,  $3F5D05,  $3F3445,  $3F0B84,  $3EE2C2,
      $3EB9FF,  $3E913B,  $3E6876,  $3E3FAF,  $3E16E6,  $3DEE1B,  $3DC54E,  $3D9C7F,
      $3D73AD,  $3D4AD9,  $3D2202,  $3CF928,  $3CD04C,  $3CA76C,  $3C7E88,  $3C55A1,
      $3C2CB7,  $3C03C8,  $3BDAD6,  $3BB1DF,  $3B88E4,  $3B5FE4,  $3B36E0,  $3B0DD7,
      $3AE4C9,  $3ABBB5,  $3A929C,  $3A697E,  $3A405A,  $3A1730,  $39EDFF,  $39C4C9,
      $399B8C,  $397249,  $3948FF,  $391FAE,  $38F655,  $38CCF6,  $38A38E,  $387A20,
      $3850A9,  $38272A,  $37FDA3,  $37D414,  $37AA7C,  $3780DB,  $375731,  $372D7E,
      $3703C1,  $36D9FB,  $36B02B,  $368651,  $365C6D,  $36327F,  $360886,  $35DE82,
      $35B473,  $358A59,  $356033,  $353602,  $350BC5,  $34E17C,  $34B727,  $348CC5,
      $346256,  $3437DA,  $340D52,  $33E2BB,  $33B817,  $338D66,  $3362A6,  $3337D7,
      $330CFB,  $32E20F,  $32B714,  $328C0A,  $3260F0,  $3235C6,  $320A8C,  $31DF42,
      $31B3E7,  $31887C,  $315CFF,  $313170,  $3105D0,  $30DA1E,  $30AE5A,  $308283,
      $305699,  $302A9C,  $2FFE8B,  $2FD267,  $2FA62E,  $2F79E1,  $2F4D80,  $2F2109,
      $2EF47D,  $2EC7DB,  $2E9B24,  $2E6E56,  $2E4171,  $2E1475,  $2DE762,  $2DBA37,
      $2D8CF4,  $2D5F98,  $2D3223,  $2D0495,  $2CD6EE,  $2CA92C,  $2C7B50,  $2C4D59,
      $2C1F47,  $2BF119,  $2BC2CF,  $2B9468,  $2B65E5,  $2B3744,  $2B0885,  $2AD9A7,
      $2AAAAB,  $2A7B8F,  $2A4C53,  $2A1CF7,  $29ED7B,  $29BDDC,  $298E1C,  $295E3A,
      $292E34,  $28FE0B,  $28CDBD,  $289D4B,  $286CB3,  $283BF6,  $280B12,  $27DA06,
      $27A8D3,  $277777,  $2745F2,  $271443,  $26E26A,  $26B065,  $267E34,  $264BD6,
      $26194A,  $25E690,  $25B3A7,  $25808E,  $254D44,  $2519C8,  $24E619,  $24B236,
      $247E1F,  $2449D3,  $241550,  $23E095,  $23ABA2,  $237675,  $23410E,  $230B6A,
      $22D58A,  $229F6B,  $22690D,  $22326E,  $21FB8D,  $21C468,  $218CFF,  $215550,
      $211D59,  $20E519,  $20AC8E,  $2073B7,  $203A92,  $20011D,  $1FC757,  $1F8D3D,
      $1F52CF,  $1F1809,  $1EDCEA,  $1EA170,  $1E6598,  $1E2961,  $1DECC7,  $1DAFC9,
      $1D7264,  $1D3496,  $1CF65B,  $1CB7B1,  $1C7895,  $1C3904,  $1BF8FA,  $1BB874,
      $1B7770,  $1B35E8,  $1AF3DA,  $1AB141,  $1A6E19,  $1A2A5E,  $19E60B,  $19A11B,
      $195B8A,  $191551,  $18CE6C,  $1886D4,  $183E83,  $17F573,  $17AB9B,  $1760F6,
      $17157B,  $16C921,  $167BE0,  $162DAF,  $15DE82,  $158E4F,  $153D0B,  $14EAA8,
      $14971A,  $144251,  $13EC3F,  $1394D1,  $133BF5,  $12E198,  $1285A2,  $1227FB,
      $11C889,  $11672F,  $1103CA,  $109E37,  $10364B,  $FCBDA,   $F5EAE,   $EEE8C,
      $E7B2D,   $E0444,   $D8971,   $D0A46,   $C863F,   $BFCBB,   $B6CF4,   $AD5F0,
      $A366F,   $98CC6,   $8D6AD,   $810DB,   $73642,   $63E62,   $518A6,   $39A39,
      $0
    );
