# Allegro.pas #

This is the official GitHub mirror of the _Allegro.pas_ (a.k.a. _Allegro for Pascal_ or _Allegro4Pascal_)

**Allegro.pas** is a wrapper that allows to use the [Allegro game programming library](https://liballeg.org) with Pascal and Object Pascal compilers as [Free Pascal](https://www.freepascal.org/) and [Delphi](https://www.embarcadero.com/es/products/delphi) (including the free [Community Edition](https://www.embarcadero.com/products/delphi/starter)).

**Allegro** is a cross-platform library mainly aimed at video game and multimedia programming.  It handles common, low-level tasks such as creating windows, accepting user input, loading data, drawing images, playing sounds, etc. and generally abstracting away the underlying platform.  However, Allegro is not a game engine: you are free to design and structure your program as you like.

Note that the _Allegro.pas_ project is hosted [at SourceForge](http://allegro-pas.sf.net/).  I'll try to keep this GitHub mirror synchronized with it so those who want to fork it will be able to keep their branches up-to-date with the latest commits (as possible).

You can download [the Game Demo](https://sourceforge.net/projects/allegro-pas/files/5.2.b.1/furiouspaladin-5.2.b.1-bin-win32.zip/download) (Windows and WineHQ), a simple game that shows some of the capabilities of Allegro.pas.  Such a simple game isn't enough to show everything that Allegro can offer.  If you want to know more about what you can do with Allegro.pas, take a peek to the [documentation](http://allegro-pas.sourceforge.net/docs/5.2/).

Use one of the [support tools](https://sf.net/p/allegro-pas/support) if you need help, or visit one of next forums:

  * [Allegro community](http://www.allegro.cc/)
  * [Pascal Game Development](http://www.pascalgamedevelopment.com/)
  * [PGD Telegram Chat](https://t.me/joinchat/AAAAAA53Fi94SyjjD5xYnA)
  * [Lazarus forum (Games section)](https://forum.lazarus.freepascal.org/index.php/board,74.0.html)
  * [Club Delphi (Spanish community)](http://www.clubdelphi.com/)
