//THIS CODE INCLUDES CREATION DELETION AND COUNTING NUMBER OF NODES PRESENT IN A LINKED LIST
#include <iostream>
using namespace std;

class Node {
 public:
  int data;
  Node *next;

  // constructor
  Node(int data) {
    this->data = data;
    this->next = NULL;
  }
  // destructor
  ~Node() {
    int value = this->data;
    // memory free
    if (this->next != NULL) {
      delete next;
      this->next = NULL;
    }
    cout << " memory is free for node with data " << value << endl;
    
  }
};
void insertatHead(Node *&head, int d) {

  Node *temp = new Node(d);
  temp->next = head;
  head = temp;
}
void insertatTail(Node *&tail, int d) {
  // new node create
  Node *temp = new Node(d);
  tail->next = temp;
  tail = temp;
}
void print(Node *&head) {
  Node *temp = head;

  while (temp != NULL) {
    cout << temp->data << " ";
    temp = temp->next;
  }
  cout << endl;
}
void insertatPosition(Node *&tail, Node *&head, int position, int d) {
  // insert at Start
  if (position == 1) {
    insertatHead(head, d);
    return;
  }
  Node *temp = head;
  int cnt = 1;

  while (cnt < position - 1) {
    temp = temp->next;
    cnt++;
  }
  // inserting at Last Position
  if (temp->next == NULL) {
    insertatTail(tail, d);
    return;
  }
  // creating a node for d
  Node *nodeToInsert = new Node(d);

  nodeToInsert->next = temp->next;

  temp->next = nodeToInsert;
}
void deleteNode(int position, Node *&head, Node *&tail) {

  // deleting first or start node
  if(position == 1){
    Node *temp = head;
    head = head->next;
    // memory free start ndoe
    temp->next = NULL;
    delete temp;
  } 
  else{
    // deleting any middle node or last node
    Node *curr = head;
    Node *prev = NULL;

    int cnt = 1;
    while(cnt < position){
      prev = curr;
      curr = curr->next;
      cnt++;
    }

    prev->next = curr->next;
    curr->next = NULL;

    delete curr;
  }
}
int countNodes(Node *head) {
  int count = 0;
  Node *curr = head;
  while (curr != NULL) {
    count++;
    curr = curr->next;
  }
  return count;
}
int main() {

  // created a new node
  Node *node1 = new Node(10);
  // cout<<node1->data<<endl;
  // cout<<node1->next<<endl;

  // head pointed to node1
  Node *head = node1;
  Node *tail = node1;

  print(head);

  insertatTail(tail, 12);
  print(head);

  insertatTail(tail, 15);
  print(head);

  insertatPosition(tail, head, 4, 22);
  print(head);
  cout << countNodes(head) << endl;

  cout << "head " << head->data << endl;
  cout << "tail " << tail->data << endl;

  deleteNode(4, head, tail);
  print(head);

  cout << "head " << head->data << endl;
  cout << "tail " << tail->data << endl;
}
