# ac-inferno (Animate Components for Inferno)
![version](https://img.shields.io/badge/ac--inferno-1.0.3-blue.svg)
![gzip](https://img.shields.io/badge/gzip%20size-4.4%20KB-brightgreen.svg)
![size](https://img.shields.io/badge/size-17.3%20KB-brightgreen.svg)

<p align="center">
	<img src="https://i.gyazo.com/64801677fb24b4492eb0b90870ead297.gif" />
</p>

## Install

**npm**

```
npm install ac-inferno
```

**yarn**

```
yarn add ac-inferno
```

The [UMD](https://github.com/umdjs/umd) build is also available on [unpkg](https://unpkg.com):

```html
<script src="https://unpkg.com/ac-inferno@1.0.3/dist/ac-inferno.min.js"></script>
```

#### Why a separate package for InfernoJS instead of using `animate-components` with `Inferno-compat` ?

* Cost in performance.
* Strange errors (specially with `Disappear` component).
* Reduce build size with Inferno.

## Docs
View the complete documentation [here](https://github.com/nitin42/animate-components/tree/master/packages/animate-components/docs) (API is similar for both React and Inferno).

## Animations

Below is a list of all available animations (Components).

### Bounce

* `Bounce`
* `BounceUp`
* `BounceRight`
* `BounceLeft`
* `BounceDown`

### Fade

* `FadeIn`
* `FadeInRightBig`
* `FadeInRight`
* `FadeInLeftBig`
* `FadeInLeft`
* `FadeInDown`
* `FadeInDownBig`
* `FadeInUp`
* `FadeInUpBig`

### Flip

* `Flip`
* `FlipX`
* `FlipY`

### LightSpeed

* `LightOut`
* `LightIn`

### Rotate

* `RotateIn`
* `RotateRight`
* `RotateLeft`
* `RotateUpRight`
* `RotateUpLeft`

### Slide

* `SlideUp`
* `SlideDown`
* `SlideLeft`
* `SlideRight`

### Special

* `Flash`
* `RollOut`
* `RollIn`
* `Rubber`
* `Swing`
* `Zoom`
* `Hinge`
* `Pulse`
* `ExpandUp`
* `Entrance`
* `Hatch`
* `StarWars`

## 🚀 New
### Perspective

* `PDown`
* `PUp`
* `PLeft`
* `PRight`

### Bingo

* `PuffOut`
* `PuffIn`
* `VanishOut`
* `VanishIn`

### Expanse (in space)

* `ExpanseUp`
* `ExpanseDown`
* `ExpanseLeft`
* `ExpanseRight`
