**Looking for maintainers. Please reach out to me if you're interested!**

# Animate Components

> ***Elemental components for doing animation in React***

## Packages
This repository uses [Lerna](https://lernajs.io/) to organise the codebase.

| Package        | Version           | Description  |
| ------------- |:-------------:| -----:|
| [`animate-keyframes`](./packages/animate-keyframes)       | ![](https://img.shields.io/badge/npm-v0.1.5-blue.svg)  | Keyframes for animations |
| [`animate-components`](./packages/animate-components)      | ![](https://img.shields.io/badge/npm-v1.4.2-blue.svg)      |   Components for animations |
| [`element-utils`](./packages/element-utils)      | ![](https://img.shields.io/badge/npm-v0.1.2-blue.svg)      |   Utility functions for `animate-components` |
| [`ac-inferno`](./packages/ac-inferno)      | ![](https://img.shields.io/badge/npm-v1.0.3-blue.svg)      |   `animate-components` for InfernoJS |

## Docs
View the docs [here](./packages)

## Support

Animate Components also supports [InfernoJS](infernojs.org) (separate package so `inferno-compat` is not required) and [Preact](preactjs.com) (with `preact-compat`). 

Why a separate package for InfernoJS  ? Read [here](https://github.com/nitin42/animate-components/tree/master/packages/ac-inferno#why-a-separate-package-for-infernojs-instead-of-using-animate-components-with-inferno-compat-).

<a href="https://app.codesponsor.io/link/FCRW65HPiwhNtebDx2tTc53E/nitin42/animate-components" rel="nofollow"><img src="https://app.codesponsor.io/embed/FCRW65HPiwhNtebDx2tTc53E/nitin42/animate-components.svg" style="width: 888px; height: 68px;" alt="Sponsor" /></a>
