# operating-system-logos

[![EgoistDeveloper operating-system-logos](https://preview.dragon-code.pro/EgoistDeveloper/operating-system-logos.svg)](https://github.com/EgoistDeveloper/operating-system-logos)

OS (Operating System) logos list in different sizes. This package contains +80 OS logos and it helps statistic or log listing and graph visualizing.

## Installation

```
npm i @egoistdeveloper/operating-system-logos
```

## Available Sizes

- 16x16
- 24x24
- 32x32
- 48x48
- 64x64
- 128x128

All icons listing `.png` format.

## List of operating system names and short codes

Image files are named according to these name (\*see the **[reference](https://github.com/matomo-org/device-detector/blob/228eef9a40f611a6661f1c93ee64c2c687dd3f11/Parser/OperatingSystem.php#L40)\***). Current and frequently used logos defining operating systems were selected. Therefore, the version or naming differences were ignored when listing.

There is no standard or formula for OS cataloging. This project uses above referenced alpha3 codes and generic names. There are many solution for OS name showing and we can use below listing methods. We can search in `slug/name` list then use matched result code for showing os icon file (yes, I know it is not the best way. we can discuss).

Alpha3 list [alpha3-list.json](./src/alpha3-list.json) and slug list [slug-list.json](./src/os-list.json).

## Preview List

<!-- TABLE_START -->

⚠️ Total: 83, Available: 83, Unavailable: 0

| Preview                                                                                                              | Code | Name                 | Status |
| -------------------------------------------------------------------------------------------------------------------- | ---- | -------------------- | ------ |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/AIX.png "AIX (48x48)") | AIX  | AIX                  | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/AND.png "AND (48x48)") | AND  | Android              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/AMG.png "AMG (48x48)") | AMG  | AmigaOS              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/ATV.png "ATV (48x48)") | ATV  | tvOS                 | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/ARL.png "ARL (48x48)") | ARL  | Arch Linux           | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/BTR.png "BTR (48x48)") | BTR  | BackTrack            | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/SBA.png "SBA (48x48)") | SBA  | Bada                 | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/BEO.png "BEO (48x48)") | BEO  | BeOS                 | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/BLB.png "BLB (48x48)") | BLB  | BlackBerry OS        | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/QNX.png "QNX (48x48)") | QNX  | BlackBerry Tablet OS | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/CAI.png "CAI (48x48)") | CAI  | Caixa Mágica         | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/CES.png "CES (48x48)") | CES  | CentOS               | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/COS.png "COS (48x48)") | COS  | Chrome OS            | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/CYN.png "CYN (48x48)") | CYN  | CyanogenMod          | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/DEB.png "DEB (48x48)") | DEB  | Debian               | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/DEE.png "DEE (48x48)") | DEE  | Deepin               | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/DFB.png "DFB (48x48)") | DFB  | DragonFly            | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/FED.png "FED (48x48)") | FED  | Fedora               | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/FOS.png "FOS (48x48)") | FOS  | Firefox OS           | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/FIR.png "FIR (48x48)") | FIR  | Fire OS              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/BSD.png "BSD (48x48)") | BSD  | FreeBSD              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/FYD.png "FYD (48x48)") | FYD  | FydeOS               | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/GNT.png "GNT (48x48)") | GNT  | Gentoo               | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/GTV.png "GTV (48x48)") | GTV  | Google TV            | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/HPX.png "HPX (48x48)") | HPX  | HP-UX                | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/HAI.png "HAI (48x48)") | HAI  | Haiku OS             | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/IPA.png "IPA (48x48)") | IPA  | iPadOS               | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/HAR.png "HAR (48x48)") | HAR  | HarmonyOS            | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/KOS.png "KOS (48x48)") | KOS  | KaiOS                | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/KNO.png "KNO (48x48)") | KNO  | Knoppix              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/KBT.png "KBT (48x48)") | KBT  | Kubuntu              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/LIN.png "LIN (48x48)") | LIN  | GNU/Linux            | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/LBT.png "LBT (48x48)") | LBT  | Lubuntu              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/MAC.png "MAC (48x48)") | MAC  | Mac                  | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/MAE.png "MAE (48x48)") | MAE  | Maemo                | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/MAG.png "MAG (48x48)") | MAG  | Mageia               | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/MDR.png "MDR (48x48)") | MDR  | Mandriva             | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/SMG.png "SMG (48x48)") | SMG  | MeeGo                | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/MIN.png "MIN (48x48)") | MIN  | Mint                 | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/MOR.png "MOR (48x48)") | MOR  | MorphOS              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/NBS.png "NBS (48x48)") | NBS  | NetBSD               | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/WII.png "WII (48x48)") | WII  | Nintendo             | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/NDS.png "NDS (48x48)") | NDS  | Nintendo Mobile      | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/OS2.png "OS2 (48x48)") | OS2  | OS/2                 | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/OBS.png "OBS (48x48)") | OBS  | OpenBSD              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/OWR.png "OWR (48x48)") | OWR  | OpenWrt              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/PCL.png "PCL (48x48)") | PCL  | PCLinuxOS            | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/PSP.png "PSP (48x48)") | PSP  | PlayStation Portable | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/PS3.png "PS3 (48x48)") | PS3  | PlayStation          | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/RAS.png "RAS (48x48)") | RAS  | Raspberry Pi         | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/RHT.png "RHT (48x48)") | RHT  | Red Hat              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/ROS.png "ROS (48x48)") | ROS  | RISC OS              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/ROK.png "ROK (48x48)") | ROK  | Roku OS              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/RSO.png "RSO (48x48)") | RSO  | Rosa                 | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/REM.png "REM (48x48)") | REM  | Remix OS             | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/REX.png "REX (48x48)") | REX  | REX                  | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/SAB.png "SAB (48x48)") | SAB  | Sabayon              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/SSE.png "SSE (48x48)") | SSE  | SUSE                 | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/SAF.png "SAF (48x48)") | SAF  | Sailfish OS          | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/SLW.png "SLW (48x48)") | SLW  | Slackware            | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/SOS.png "SOS (48x48)") | SOS  | Solaris              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/SYL.png "SYL (48x48)") | SYL  | Syllable             | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/SYM.png "SYM (48x48)") | SYM  | Symbian              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/SYS.png "SYS (48x48)") | SYS  | Symbian OS           | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/S40.png "S40 (48x48)") | S40  | Symbian OS Series 40 | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/S60.png "S60 (48x48)") | S60  | Symbian OS Series 60 | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/SY3.png "SY3 (48x48)") | SY3  | Symbian^3            | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/TDX.png "TDX (48x48)") | TDX  | ThreadX              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/TIZ.png "TIZ (48x48)") | TIZ  | Tizen                | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/UBT.png "UBT (48x48)") | UBT  | Ubuntu               | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/WAS.png "WAS (48x48)") | WAS  | watchOS              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/WHS.png "WHS (48x48)") | WHS  | Whale OS             | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/WIN.png "WIN (48x48)") | WIN  | Windows              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/WCE.png "WCE (48x48)") | WCE  | Windows CE           | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/WIO.png "WIO (48x48)") | WIO  | Windows IoT          | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/WMO.png "WMO (48x48)") | WMO  | Windows Mobile       | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/WPH.png "WPH (48x48)") | WPH  | Windows Phone        | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/WRT.png "WRT (48x48)") | WRT  | Windows RT           | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/XBX.png "XBX (48x48)") | XBX  | Xbox                 | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/XBT.png "XBT (48x48)") | XBT  | Xubuntu              | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/YNS.png "YNS (48x48)") | YNS  | YunOs                | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/IOS.png "IOS (48x48)") | IOS  | iOS                  | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/POS.png "POS (48x48)") | POS  | palmOS               | ✅     |
| ![](https://raw.githubusercontent.com/EgoistDeveloper/operating-system-logos/master/src/48x48/WOS.png "WOS (48x48)") | WOS  | webOS                | ✅     |

<!-- TABLE_END -->

## Contribution

When you find a lost os icon, add related folders with required sizes (_listed above_). Then add unique uppercase alpha3 short code (_also this is going to be filename_) and with name to `list.json`. Finally go to `src` folder and run `node list.js` command (_obviously nodejs must be installed_). `list.js` generates automatically preview list and updates this `readme.md` file (_this option useful for multiple icons_). All files must be `.png` format.

Also this repo open for SVG support, waiting PR's.

## Legal

All logos and trademarks are the property of their respective owners!
If you represent the entity that has the rights over a logo and you want, for whatever reason, that logo removed from this project, **[open an issue](https://github.com/EgoistDeveloper/operating-system-logos/issues/new)** requesting its takedown and we will remove it as soon as possible.
