import React, { useState, useEffect } from 'react';
import { BrowserRouter } from 'react-router-dom';
import styled from 'styled-components';
import { Trash, Edit, SettingsFilled } from '@rainbow-modules/icons';
import { Application, ButtonGroup, ButtonIcon, Badge } from 'react-rainbow-components';
import RecordHeader from '../../src/components/RecordHeader';
import RecordField from '../../src/components/RecordField';
import RecordPrimaryDetails from '../../src/components/RecordPrimaryDetails';

const Container = styled.div`
    background-color: ${(props) => props.theme.rainbow.palette.background.main};
    padding: 0 32px 32px 32px;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100%;
    border-radius: 20px;
    margin: 36px;
`;

const Actions = () => {
    return (
        <ButtonGroup>
            <ButtonIcon variant="border-filled" icon={<Trash />} />
            <ButtonIcon variant="border-filled" icon={<Edit />} />
            <ButtonIcon variant="border-filled" icon={<SettingsFilled />} />
        </ButtonGroup>
    );
};

const useChangeLoading = () => {
    const [loading, setLoading] = useState(true);

    useEffect(() => {
        setTimeout(() => {
            setLoading(false);
        }, 1500);
    }, []);

    return loading;
};

// eslint-disable-next-line react/prop-types
const StatusBadge = ({ value }) => {
    return <Badge label={value} variant="success" size="small" />;
};

export const BasicRecordHeader = () => {
    const loading = useChangeLoading();

    return (
        <BrowserRouter>
            <Application>
                <Container>
                    <RecordHeader
                        label="CUSTOMER"
                        description="John Doe"
                        actions={<Actions />}
                        tags={<Badge label="active" />}
                        isLoading={loading}
                    >
                        <RecordPrimaryDetails>
                            <RecordField label="Organization" isLoading={loading} value="Google" />
                            <RecordField
                                label="Date & Time"
                                isLoading={loading}
                                value={new Date()}
                                type="dateTime"
                            />
                            <RecordField
                                label="Web page"
                                isLoading={loading}
                                value="https://google.com"
                                href="https://google.com"
                                type="url"
                            />
                            <RecordField
                                label="Price"
                                isLoading={loading}
                                value={50.5}
                                type="currency"
                            />
                            <RecordField
                                label="Status"
                                component={StatusBadge}
                                isLoading={loading}
                                value="success"
                            />
                        </RecordPrimaryDetails>
                    </RecordHeader>
                </Container>
            </Application>
        </BrowserRouter>
    );
};

export const LargeDescriptionRecordHeader = () => {
    const loading = useChangeLoading();

    return (
        <BrowserRouter>
            <Application>
                <Container>
                    <RecordHeader
                        label="CONTENT"
                        description="Lorem ipsum is placeholder text commonly used in the graphic, print, and publishing industries."
                        actions={<Actions />}
                        isLoading={loading}
                    />
                </Container>
            </Application>
        </BrowserRouter>
    );
};

export default {
    title: 'Modules/Record/Stories/RecordHeader',
    parameters: {
        viewOnGithub: {
            fileName: __filename,
        },
    },
};
