import React from 'react';
import PropTypes from 'prop-types';

export default function Icon(props) {
    const { className, style } = props;

    return (
        <svg className={className} style={style} width="8px" height="16px" viewBox="0 0 8 16">
            <g
                id="column-customization"
                stroke="none"
                strokeWidth="1"
                fill="none"
                fillRule="evenodd"
            >
                <g
                    id="dispatch/rides-colum-customization-show-the-info"
                    transform="translate(-1073.000000, -473.000000)"
                    fill="currentColor"
                    fillRule="nonzero"
                >
                    <g id="Group-28" transform="translate(1049.000000, 277.000000)">
                        <g id="Group-26" transform="translate(13.000000, 180.000000)">
                            <path
                                d="M12.6138057,29.4383886 C13.3211752,29.4383886 13.8946114,30.0118248 13.8946114,30.7191943 C13.8946114,31.4265638 13.3211752,32 12.6138057,32 C11.9064362,32 11.333,31.4265638 11.333,30.7191943 C11.333,30.0118248 11.9064362,29.4383886 12.6138057,29.4383886 Z M16.8164166,29.4383886 C17.523786,29.4383886 18.0972223,30.0118248 18.0972223,30.7191943 C18.0972223,31.4265638 17.523786,32 16.8164166,32 C16.1090471,32 15.5356109,31.4265638 15.5356109,30.7191943 C15.5356109,30.0118248 16.1090471,29.4383886 16.8164166,29.4383886 Z M12.6138057,24.9656099 C13.3211752,24.9656099 13.8946114,25.5390461 13.8946114,26.2464156 C13.8946114,26.953785 13.3211752,27.5272213 12.6138057,27.5272213 C11.9064362,27.5272213 11.333,26.953785 11.333,26.2464156 C11.333,25.5390461 11.9064362,24.9656099 12.6138057,24.9656099 Z M16.8164166,24.9656099 C17.523786,24.9656099 18.0972223,25.5390461 18.0972223,26.2464156 C18.0972223,26.953785 17.523786,27.5272213 16.8164166,27.5272213 C16.1090471,27.5272213 15.5356109,26.953785 15.5356109,26.2464156 C15.5356109,25.5390461 16.1090471,24.9656099 16.8164166,24.9656099 Z M12.6138057,20.4828049 C13.3211752,20.4828049 13.8946114,21.0562412 13.8946114,21.7636106 C13.8946114,22.4709801 13.3211752,23.0444163 12.6138057,23.0444163 C11.9064362,23.0444163 11.333,22.4709801 11.333,21.7636106 C11.333,21.0562412 11.9064362,20.4828049 12.6138057,20.4828049 Z M16.8164166,20.4828049 C17.523786,20.4828049 18.0972223,21.0562412 18.0972223,21.7636106 C18.0972223,22.4709801 17.523786,23.0444163 16.8164166,23.0444163 C16.1090471,23.0444163 15.5356109,22.4709801 15.5356109,21.7636106 C15.5356109,21.0562412 16.1090471,20.4828049 16.8164166,20.4828049 Z M12.6138057,16 C13.3211752,16 13.8946114,16.5734362 13.8946114,17.2808057 C13.8946114,17.9881752 13.3211752,18.5616114 12.6138057,18.5616114 C11.9064362,18.5616114 11.333,17.9881752 11.333,17.2808057 C11.333,16.5734362 11.9064362,16 12.6138057,16 Z M16.8164166,16 C17.523786,16 18.0972223,16.5734362 18.0972223,17.2808057 C18.0972223,17.9881752 17.523786,18.5616114 16.8164166,18.5616114 C16.1090471,18.5616114 15.5356109,17.9881752 15.5356109,17.2808057 C15.5356109,16.5734362 16.1090471,16 16.8164166,16 Z"
                                id="Combined-Shape"
                            />
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
}

Icon.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

Icon.defaultProps = {
    className: undefined,
    style: undefined,
};
