import React from 'react';
import PropTypes from 'prop-types';
import { IconProps } from '../types';

const Info = (props: IconProps): JSX.Element => {
    const { className, style, title } = props;
    return (
        <svg className={className} style={style} width="18px" height="18px" viewBox="0 0 18 18">
            <title>{title}</title>
            <g id="modules" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="logs"
                    transform="translate(-115.000000, -286.000000)"
                    fill="#01B6F5"
                    fillRule="nonzero"
                >
                    <g id="info" transform="translate(115.000000, 286.000000)">
                        <path
                            d="M8.99961905,0 C4.02971429,0 0,4.02971429 0,8.99961905 C0,13.9695238 4.02971429,18 8.99961905,18 C13.9695238,18 18,13.9695238 18,8.99961905 C18,4.02971429 13.9695238,0 8.99961905,0 Z"
                            id="Path"
                            fillOpacity="0.2"
                        />
                        <path
                            d="M8.51809524,7.1992381 C9.07504762,7.1992381 9.5047619,7.33485714 9.8072381,7.60304762 C10.1081905,7.872 10.2598095,8.22171429 10.2598095,8.65142857 C10.2598095,8.74057143 10.2491429,8.89752381 10.2285714,9.12152381 C10.208,9.34628571 10.1691429,9.5512381 10.1127619,9.73942857 L9.536,11.7813333 C9.4887619,11.9451429 9.44685714,12.1325714 9.4087619,12.3420952 C9.37142857,12.551619 9.35314286,12.711619 9.35314286,12.8190476 C9.35314286,13.0902857 9.41333333,13.2754286 9.5352381,13.3737143 C9.65561905,13.472 9.86666667,13.5215238 10.1653333,13.5215238 C10.3062857,13.5215238 10.464,13.496381 10.6422857,13.447619 C10.8190476,13.3988571 10.9470476,13.3554286 11.0278095,13.3180952 L10.8731429,13.9481905 C10.4099048,14.1310476 10.0411429,14.2697143 9.76457143,14.3657143 C9.4887619,14.4617143 9.168,14.5097143 8.80304762,14.5097143 C8.24228571,14.5097143 7.80571429,14.3725714 7.49485714,14.0990476 C7.184,13.8255238 7.02933333,13.4788571 7.02933333,13.0575238 C7.02933333,12.8937143 7.0407619,12.7260952 7.06361905,12.5554286 C7.0872381,12.3847619 7.12457143,12.1927619 7.17561905,11.9771429 L7.75542857,9.92914286 C7.80647619,9.73257143 7.85066667,9.54590476 7.88571429,9.37219048 C7.9207619,9.19695238 7.93752381,9.03619048 7.93752381,8.88990476 C7.93752381,8.62933333 7.88342857,8.44647619 7.776,8.34361905 C7.66704762,8.2407619 7.46209524,8.19047619 7.15657143,8.19047619 C7.0072381,8.19047619 6.85333333,8.21257143 6.69561905,8.25904762 C6.53942857,8.30704762 6.40380952,8.35047619 6.29257143,8.39314286 L6.44571429,7.76228571 C6.82514286,7.60761905 7.18857143,7.47504762 7.5352381,7.36533333 C7.88190476,7.25409524 8.20952381,7.1992381 8.51809524,7.1992381 Z M9.79961905,3.46133333 C10.1782857,3.46133333 10.5028571,3.58704762 10.7710476,3.84 C11.04,4.09219048 11.1748571,4.39695238 11.1748571,4.7512381 C11.1748571,5.10704762 11.04,5.41028571 10.7710476,5.66019048 C10.5020952,5.91009524 10.1782857,6.03504762 9.79961905,6.03504762 C9.42171429,6.03504762 9.09561905,5.91009524 8.82438095,5.66019048 C8.55466667,5.41028571 8.41828571,5.10628571 8.41828571,4.7512381 C8.41828571,4.39695238 8.55542857,4.09219048 8.82438095,3.84 C9.09561905,3.58704762 9.42171429,3.46133333 9.79961905,3.46133333 Z"
                            id="Combined-Shape"
                        />
                    </g>
                </g>
            </g>
        </svg>
    );
};

Info.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

Info.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default Info;
