import React from 'react';
import { IconProps } from '../../types';

const YarnLockFile: React.FC<IconProps> = (props: IconProps) => {
    const { className, style, title } = props;
    return (
        <svg
            className={className}
            style={style}
            fill="currentColor"
            width="19px"
            height="21px"
            viewBox="0 0 19 21"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
        >
            <title>{title}</title>
            <g id="marketplace" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="marketplace/functions-source-code/download"
                    transform="translate(-184.000000, -713.000000)"
                    fill="#008FBF"
                    fillRule="nonzero"
                >
                    <path
                        d="M202.068776,729.25796 C201.038172,729.502729 200.516429,729.728173 199.241057,730.559097 C197.250703,731.847352 195.073552,732.446391 195.073552,732.446391 C195.073552,732.446391 194.893196,732.716924 194.371453,732.839309 C193.469675,733.058312 190.075123,733.245109 189.765942,733.251689 C188.935017,733.257991 188.426157,733.038988 188.284449,732.697601 C187.852883,731.666997 188.902811,731.216108 188.902811,731.216108 C188.902811,731.216108 188.670925,731.074399 188.535658,730.945574 C188.413274,730.82319 188.284449,730.578421 188.245801,730.668599 C188.084769,731.061517 188.001033,732.021267 187.569467,732.452832 C186.97687,733.051871 185.856088,732.852191 185.192637,732.504362 C184.464773,732.117886 185.244167,731.209666 185.244167,731.209666 C185.244167,731.209666 184.851249,731.441552 184.535627,730.964898 C184.252211,730.526891 183.988119,729.779703 184.058973,728.858601 C184.136268,727.808673 185.30858,726.790952 185.30858,726.790952 C185.30858,726.790952 185.102459,725.238605 185.778793,723.64761 C186.390714,722.198323 188.03968,721.032453 188.03968,721.032453 C188.03968,721.032453 186.654806,719.499429 187.170108,718.120996 C187.505054,717.219218 187.640321,717.225659 187.749823,717.187012 C188.136299,717.038862 188.509893,716.877831 188.786868,716.575091 C190.171742,715.080715 191.936651,715.364131 191.936651,715.364131 C191.936651,715.364131 192.774017,712.819828 193.54697,713.315806 C193.785297,713.470396 194.641987,715.377014 194.641987,715.377014 C194.641987,715.377014 195.556648,714.842388 195.659708,715.042067 C196.213658,716.11776 196.27807,718.172527 196.033302,719.422134 C195.62106,721.483342 194.590456,722.591241 194.178215,723.286899 C194.081596,723.44793 195.286114,723.956791 196.046184,726.063088 C196.748283,727.989029 196.12348,729.605789 196.232981,729.786145 C196.252305,729.818351 196.258746,729.831233 196.258746,729.831233 C196.258746,729.831233 197.063906,729.895646 198.680666,728.897249 C199.543797,728.362623 200.567959,727.763584 201.73383,727.750702 C202.861053,727.731378 202.919024,729.051839 202.068776,729.25796 L202.068776,729.25796 Z"
                        id="yarn.lock"
                    />
                </g>
            </g>
        </svg>
    );
};

YarnLockFile.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default YarnLockFile;
