import React from 'react';
import PropTypes from 'prop-types';

const Wireless = (props) => {
    const { className, style, title } = props;
    return (
        <svg
            width="15px"
            height="14px"
            viewBox="0 0 15 14"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            className={className}
            style={style}
        >
            <title>{title}</title>
            <g id="Groups" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="contacts_groups-details-with-contacts-with-options"
                    transform="translate(-1259.000000, -470.000000)"
                    fill="currentColor"
                    fillRule="nonzero"
                >
                    <g id="Group-16" transform="translate(1248.000000, 449.000000)">
                        <path
                            d="M18.3684211,25.4210526 C19.1823144,25.4210526 19.8421053,26.0808435 19.8421053,26.8947368 C19.8389465,27.4180584 19.5584867,27.9004492 19.1052632,28.1621053 L19.1052632,28.1621053 L19.1052632,34.2631579 C19.1052632,34.6701046 18.7753677,35 18.3684211,35 C17.9614744,35 17.6315789,34.6701046 17.6315789,34.2631579 L17.6315789,34.2631579 L17.6315789,28.1621053 C17.1783554,27.9004492 16.8978956,27.4180584 16.8947368,26.8947368 C16.8947368,26.0808435 17.5545277,25.4210526 18.3684211,25.4210526 Z M23.5778947,21.6852632 C26.4543932,24.5626305 26.4543932,29.2268432 23.5778947,32.1042105 C23.4388388,32.2421374 23.2505917,32.3190271 23.0547368,32.3179071 C22.8614338,32.3170808 22.676192,32.2403378 22.5389474,32.1042105 C22.2532563,31.8168145 22.2532563,31.3526592 22.5389474,31.0652632 C23.6458436,29.9595976 24.267795,28.4592545 24.267795,26.8947368 C24.267795,25.3302192 23.6458436,23.829876 22.5389474,22.7242105 C22.2885855,22.4318608 22.3054183,21.9960675 22.577585,21.7239008 C22.8497517,21.4517341 23.2855451,21.4349013 23.5778947,21.6852632 Z M13.8909403,21.4481399 C14.1601091,21.5128875 14.3702703,21.7230488 14.435018,21.9922176 C14.4997656,22.2613864 14.4081719,22.5441338 14.1978947,22.7242105 C13.0909985,23.829876 12.4690471,25.3302192 12.4690471,26.8947368 C12.4690471,28.4592545 13.0909985,29.9595976 14.1978947,31.0652632 C14.4835858,31.3526592 14.4835858,31.8168145 14.1978947,32.1042105 C14.0606501,32.2403378 13.8754083,32.3170808 13.6821053,32.3179071 C13.4862504,32.3190271 13.2980033,32.2421374 13.1589474,32.1042105 C10.2824489,29.2268432 10.2824489,24.5626305 13.1589474,21.6852632 C13.3390241,21.474986 13.6217714,21.3833923 13.8909403,21.4481399 Z M21.4926316,23.7705263 C23.2165673,25.4966087 23.2165673,28.292865 21.4926316,30.0189474 C21.3565881,30.1577789 21.1711984,30.2372316 20.9768421,30.24 C20.7799241,30.2391825 20.5915263,30.1595778 20.4536842,30.0189474 C20.1679931,29.7315513 20.1679931,29.267396 20.4536842,28.98 C21.0071323,28.4271672 21.318108,27.6769957 21.318108,26.8947368 C21.318108,26.112478 21.0071323,25.3623064 20.4536842,24.8094737 C20.2033224,24.517124 20.2201552,24.0813306 20.4923218,23.8091639 C20.7644885,23.5369973 21.2002819,23.5201645 21.4926316,23.7705263 Z M16.2445203,23.8091639 C16.5166869,24.0813306 16.5335197,24.517124 16.2831579,24.8094737 C15.7297098,25.3623064 15.4187341,26.112478 15.4187341,26.8947368 C15.4187341,27.6769957 15.7297098,28.4271672 16.2831579,28.98 C16.568849,29.267396 16.568849,29.7315513 16.2831579,30.0189474 C16.1453158,30.1595778 15.956918,30.2391825 15.76,30.24 C15.5656437,30.2372316 15.380254,30.1577789 15.2442105,30.0189474 C13.5202748,28.292865 13.5202748,25.4966087 15.2442105,23.7705263 C15.5365602,23.5201645 15.9723536,23.5369973 16.2445203,23.8091639 Z"
                            id="wireless"
                        />
                    </g>
                </g>
            </g>
        </svg>
    );
};

Wireless.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};
Wireless.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default Wireless;
