import React from 'react';
import PropTypes from 'prop-types';

const WaitingTime = (props) => {
    const { className, style, title } = props;
    return (
        <svg
            className={className}
            style={style}
            width="140px"
            height="120px"
            viewBox="0 0 140 120"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
        >
            <title>{title}</title>
            <g id="gnet-integration" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <path
                    d="M101.454545,0 C104.467091,0 106.909091,2.442 106.909091,5.45454545 C106.909091,8.39361419 104.58476,10.7896295 101.67393,10.9047599 L101.454545,10.9090909 L96,10.9090909 L96,22.1228182 C105.239492,23.1492211 113.712676,26.7490819 120.685427,32.1887828 L121.169455,32.5712727 L125.239364,28.5016364 C127.369364,26.3713636 130.822909,26.3716364 132.953182,28.5016364 C135.02428,30.5724697 135.081811,33.8943394 133.125773,36.0349254 L132.953182,36.2154545 L128.883273,40.2850909 C135.608182,48.6867273 139.636364,59.3353636 139.636364,70.9090909 C139.636364,97.9778182 117.614182,120 90.5454545,120 C63.4767273,120 41.4545455,97.9778182 41.4545455,70.9090909 C41.4545455,59.545795 45.3375796,49.0742562 51.8435056,40.7455825 L52.2076364,40.2850909 L48.1377273,36.2154545 C46.0074545,34.0854545 46.0077273,30.6319091 48.1377273,28.5016364 C50.2085606,26.4305379 53.5304303,26.3730074 55.6710163,28.3290448 L55.8515455,28.5016364 L59.9214545,32.5712727 C66.8240207,27.0461281 75.2440934,23.3440231 84.447546,22.1985757 L85.0909091,22.1228182 L85.0909091,10.9090909 L79.6363636,10.9090909 C76.6238182,10.9090909 74.1818182,8.46709091 74.1818182,5.45454545 C74.1818182,2.51547672 76.5061489,0.11946136 79.4169789,0.00433096655 L79.6363636,0 L101.454545,0 Z M31.011,87.2727273 C34.0232727,87.2727273 36.4655455,89.7147273 36.4655455,92.7272727 C36.4655455,95.7398182 34.0235455,98.1818182 31.011,98.1818182 L31.011,98.1818182 L16.3636364,98.1818182 C13.3510909,98.1818182 10.9090909,95.7398182 10.9090909,92.7272727 C10.9090909,89.7147273 13.3510909,87.2727273 16.3636364,87.2727273 L16.3636364,87.2727273 Z M90.5454545,43.6363636 C87.5329091,43.6363636 85.0909091,46.0783636 85.0909091,49.0909091 L85.0909091,70.9090909 C85.0909091,73.9216364 87.5329091,76.3636364 90.5454545,76.3636364 L112.363636,76.3636364 C115.376182,76.3636364 117.818182,73.9216364 117.818182,70.9090909 C117.818182,67.8965455 115.376182,65.4545455 112.363636,65.4545455 L96,65.4545455 L96,49.0909091 C96,46.0783636 93.558,43.6363636 90.5454545,43.6363636 Z M27.2727273,65.4545455 C30.2852727,65.4545455 32.7272727,67.8965455 32.7272727,70.9090909 C32.7272727,73.9216364 30.2852727,76.3636364 27.2727273,76.3636364 L27.2727273,76.3636364 L5.45454545,76.3636364 C2.442,76.3636364 -2.66453526e-13,73.9216364 -2.66453526e-13,70.9090909 C-2.66453526e-13,67.8965455 2.442,65.4545455 5.45454545,65.4545455 L5.45454545,65.4545455 Z M31.011,43.6363636 C34.0232727,43.6363636 36.4655455,46.0783636 36.4655455,49.0909091 C36.4655455,52.1034545 34.0235455,54.5454545 31.011,54.5454545 L31.011,54.5454545 L16.3636364,54.5454545 C13.3510909,54.5454545 10.9090909,52.1034545 10.9090909,49.0909091 C10.9090909,46.0783636 13.3510909,43.6363636 16.3636364,43.6363636 L16.3636364,43.6363636 Z"
                    id="waiting-time"
                    fill="currentColor"
                    fillRule="nonzero"
                />
            </g>
        </svg>
    );
};

export default WaitingTime;

WaitingTime.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

WaitingTime.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};
