import React from 'react';
import PropTypes from 'prop-types';

const UsersFilled = (props) => {
    const { className, style, title } = props;
    return (
        <svg
            className={className}
            style={style}
            width="30px"
            height="26px"
            viewBox="0 0 48 42"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
        >
            <title>{title}</title>
            <g id="modules" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <path
                    d="M17.6934,3.1146 C23.9734,3.0676 27.4954,6.3426 28.1004,12.7906 C28.6884,19.0866 27.9794,21.8166 23.8364,28.9716 C26.4734,29.7446 29.0924,30.4346 31.6594,31.2826 C34.9934,32.3826 36.8514,36.7116 35.1914,39.8436 C34.7644,40.6506 33.4034,41.3866 32.4454,41.4206 C25.4594,41.6686 18.4674,41.7816 11.4764,41.8266 C8.6494,41.8436 5.8214,41.5806 2.9924,41.4526 C1.0594,41.3636 0.2484,40.2676 0.0624,38.4236 C-0.3276,34.5536 1.0904,32.2406 4.7854,31.0716 C7.0804,30.3456 9.4084,29.7246 12.1154,28.9426 C8.0504,24.0986 7.0504,18.6996 7.6314,12.8336 C8.2704,6.3736 11.5224,3.1606 17.6934,3.1146 Z M40.1607,10.0519 C40.4887,15.3259 39.4497,20.1429 35.6947,24.4599 C38.5347,25.2789 41.0267,25.9299 43.4727,26.7219 C46.9057,27.8319 48.7327,31.8169 47.2867,35.1789 C46.9897,35.8679 46.1544963,36.8263348 45.4251795,36.8263348 L38.1569837,36.8263348 L38.1569837,36.8263348 C37.0894226,30.0391085 32.8087,29.2039 30.4117,28.5169 C28.0177,27.8309 27.9908791,26.7715458 29.0677,24.0419 C34.2433202,10.9221603 29.0677,3.43938001 24.2872961,1.68444447 C24.2066155,1.65482581 24.1292816,1.63264457 24.0557,1.6179 C32.1637,-2.5361 39.6407,1.6779 40.1607,10.0519 Z"
                    id="filled"
                    fill="currentColor"
                />
            </g>
        </svg>
    );
};

export default UsersFilled;

UsersFilled.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

UsersFilled.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};
