import React from 'react';
import PropTypes from 'prop-types';

const Users = (props) => {
    const { className, style, title } = props;
    return (
        <svg className={className} style={style} width="43px" height="38px" viewBox="0 0 43 38">
            <title>{title}</title>
            <g id="functions" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <path
                    d="M26.1812236,11.9155614 C26.6598658,17.0406134 26.1526454,19.6178466 23.3286574,24.7607003 L23.0879337,25.19532 L23.014,25.327 L25.1515818,25.9366179 L26.5442139,26.3429912 L27.4764089,26.6265892 L28.562083,26.9750539 C32.0375288,28.1217217 33.8826393,32.5342402 32.1725836,35.7606821 C31.6386244,36.7698276 30.1514119,37.607403 28.960735,37.6496609 L28.8380269,37.6539263 L28.8380269,37.6539263 L28.7121419,37.6581239 L27.5940594,37.689263 L25.1956455,37.733318 L22.3008733,37.7641011 L18.4833928,37.7830504 L14.6780341,37.7851291 L10.9177691,37.7730045 L6.75764519,37.7400148 L4.14745824,37.6970562 L3.52961138,37.6767739 C1.41753442,37.5795288 0.275646094,36.3204298 0.0588477098,34.1710952 C-0.316794579,30.4435679 1.12950554,28.0565748 4.54357584,26.8800376 L4.81719853,26.7896655 L5.45001349,26.5926345 L6.11567877,26.3915023 L7.21256743,26.0704196 L9.733,25.354 L9.62021019,25.1972292 C7.13284281,21.6382983 6.18255104,17.6139665 6.4953412,12.8872632 L6.53082034,12.4122428 L6.57316325,11.9475519 C7.17476067,5.86567497 10.4088495,2.72437734 16.2210002,2.68105229 C22.1511437,2.63667064 25.6125827,5.85507078 26.1812236,11.9155614 Z M16.235938,4.6809965 C11.4740795,4.71649245 9.06691827,7.05458836 8.56343743,12.144551 C8.05833942,17.2442153 9.05205694,21.3497845 11.9270587,24.9426559 L12.1936157,25.2678816 L13.1813983,26.4449588 L11.7051349,26.8714227 L7.39150354,28.1007813 L6.35860558,28.4066944 L5.42044467,28.69652 C2.72592416,29.5489949 1.75687976,31.0741234 2.04875959,33.9704695 C2.16569644,35.1297789 2.53143617,35.5845789 3.46811606,35.6686174 L3.62080451,35.6788542 L4.07863689,35.6946439 L6.28006761,35.7341417 L12.0296126,35.7780463 L17.4544736,35.7850866 L20.9095567,35.7732963 L23.9784224,35.7483692 L26.5827407,35.7103487 L28.1151616,35.6751988 L28.8897895,35.6509196 C29.3979066,35.6328862 30.2235143,35.1679165 30.4051209,34.8246932 C31.5291984,32.7038435 30.2467576,29.6369304 27.9350877,28.8742318 L27.7234436,28.8046973 L26.6578362,28.466886 L25.1803367,28.0266924 L22.2979302,27.2030905 L20.0119398,26.5369533 L20.6502574,25.4345727 L21.1145638,24.6247267 L21.5423959,23.8604133 L21.6437853,23.6759622 L21.6437853,23.6759622 L21.7429821,23.4940322 L22.1181908,22.7902227 L22.2066853,22.6199232 L22.2066853,22.6199232 L22.2930917,22.4517549 L22.6181824,21.7990952 C23.9941699,18.9592546 24.4170988,16.9797008 24.3298968,14.2067934 L24.3140169,13.8050883 L24.2757302,13.1494523 L24.2221268,12.460359 L24.1899293,12.1019666 L24.158361,11.7971502 C23.6100298,6.96555987 21.0161296,4.64522118 16.235938,4.6809965 Z M26.2839028,0.000486111119 C32.0501528,-0.0432638889 35.4150139,3.08631944 35.9672361,8.97798611 C36.4455694,14.0996528 35.9118194,16.6040972 32.9601528,21.8900694 L32.9601528,21.8900694 L32.8882083,22.0174306 L34.9668194,22.6104861 L36.3201528,23.0052083 L37.2272361,23.2803472 L38.2820972,23.6196528 C41.6615417,24.7338194 43.4552917,29.0252083 41.7918194,32.1615972 C41.273625,33.1425694 39.8279306,33.9572917 38.6690417,33.998125 C38.5912639,34.0010417 38.5105694,34.0039583 38.4279306,34.0059028 L38.4279306,34.0059028 L37.3409861,34.0360417 L35.2560752,34.0360417 L35.2560752,32.1120139 L36.3580694,32.1120139 L37.8484861,32.0779861 L38.6009861,32.0546528 C39.094875,32.0371528 39.8979306,31.5840972 40.074875,31.2515972 C41.1676528,29.1895139 39.9202917,26.2077083 37.6725139,25.4659028 C37.6044583,25.4435417 37.5344583,25.4211806 37.467375,25.3988194 L37.467375,25.3988194 L36.4309861,25.0702083 L34.9940417,24.6424306 L32.1920972,23.8413194 L29.9695972,23.1938194 L30.5908472,22.1224306 L31.0419583,21.3339583 L31.4570972,20.5921528 C31.5241806,20.4715972 31.5893194,20.3529861 31.6534861,20.2353472 L31.6534861,20.2353472 L32.0180694,19.5509028 C32.0754306,19.4400694 32.1327917,19.3302083 32.1872361,19.2222917 L32.1872361,19.2222917 L32.5041806,18.5874306 C33.9051528,15.6950694 34.2901528,13.7204861 34.1520972,10.8154861 L34.1520972,10.8154861 L34.1151528,10.1786806 L34.0626528,9.50784722 L34.0315417,9.15979167 L34.0014028,8.86326389 C33.4676528,4.16548611 30.9457083,1.90993056 26.2984861,1.94493056 C25.4637243,1.95122047 24.4818984,2.12821521 23.3530085,2.47591478 C23.3530085,2.47591478 21.1529923,1.21786348 21.1529923,1.21786348 C22.5350216,0.424420962 24.2452445,0.015161516 26.2839028,0.000486111119 Z"
                    id="Combined-Shape"
                    fill="currentColor"
                    fillRule="nonzero"
                />
            </g>
        </svg>
    );
};

export default Users;

Users.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

Users.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};
