import React from 'react';
import PropTypes from 'prop-types';

const UnionPay = (props) => {
    const { className, style, title } = props;
    return (
        <svg
            className={className}
            style={style}
            width="51px"
            height="36px"
            viewBox="0 0 51 36"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
        >
            <title>{title}</title>
            <g id="modules" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="rainbow-UniversalPicker-"
                    transform="translate(-359.000000, -570.000000)"
                    fillRule="nonzero"
                >
                    <g id="union" transform="translate(359.750000, 570.950000)">
                        <g id="dinners-copy">
                            <path
                                d="M46.04875,33.85 L3.12730634,33.85 C1.53820423,33.85 0.25,32.5605141 0.25,30.9698532 L0.25,3.13005166 C0.25,1.53939073 1.53820423,0.25 3.12730634,0.25 L46.04875,0.25 C47.6379472,0.25 48.9260563,1.53948589 48.9260563,3.13005166 L48.9260563,30.9698532 C48.9260563,32.5605141 47.6378521,33.85 46.04875,33.85 Z"
                                id="Shape"
                                fill="#FBFBFC"
                            />
                            <path
                                d="M46.04875,1.88293825e-13 L3.12730634,1.88293825e-13 C1.40006551,1.88293825e-13 1.70530257e-13,1.40138703 1.70530257e-13,3.13005166 L1.70530257e-13,30.9698532 C1.70530257e-13,32.6985334 1.40008109,34.1 3.12730634,34.1 L46.04875,34.1 C47.7759753,34.1 49.1760563,32.6985334 49.1760563,30.9698532 L49.1760563,3.13005166 C49.1760563,1.40141901 47.7760228,1.88293825e-13 46.04875,1.88293825e-13 Z M3.12730634,0.5 L46.04875,0.5 C47.4997696,0.5 48.6760563,1.67745074 48.6760563,3.13005166 L48.6760563,30.9698532 C48.6760563,32.4225017 47.4997221,33.6 46.04875,33.6 L3.12730634,33.6 C1.67633423,33.6 0.5,32.4225017 0.5,30.9698532 L0.5,3.13005166 C0.5,1.67742386 1.67631354,0.5 3.12730634,0.5 Z"
                                id="border"
                                fill="#EDEFF2"
                            />
                        </g>
                        <g id="UnionPay_logo" transform="translate(9.250000, 7.050000)">
                            <path
                                d="M6.25520388,8.34454131e-05 L14.2275264,8.34454131e-05 C15.3403909,8.34454131e-05 16.0325547,0.907164181 15.7729448,2.02372071 L12.0612589,17.959427 C11.7993171,19.0720971 10.6850924,19.9799551 9.57145063,19.9799551 L1.59990541,19.9799551 C0.4885955,19.9799551 -0.205123055,19.0720971 0.054487026,17.959427 L3.76772733,2.02372071 C4.02733741,0.907164181 5.14097916,8.34454131e-05 6.25520388,8.34454131e-05"
                                id="Path"
                                fill="#E21836"
                            />
                            <path
                                d="M13.5641604,8.34454131e-05 L22.7321272,8.34454131e-05 C23.8447972,8.34454131e-05 23.3430659,0.907164181 23.0813182,2.02372071 L19.3702155,17.959427 C19.1098281,19.0720971 19.1910534,19.9799551 18.0760514,19.9799551 L8.90808469,19.9799551 C7.79308269,19.9799551 7.10305619,19.0720971 7.36499812,17.959427 L11.0759066,2.02372071 C11.339403,0.907164181 12.4507129,8.34454131e-05 13.5641604,8.34454131e-05"
                                id="Path"
                                fill="#00447C"
                            />
                            <path
                                d="M22.3684787,8.34454131e-05 L30.3408011,8.34454131e-05 C31.4552202,8.34454131e-05 32.1473842,0.907164181 31.8856366,2.02372071 L28.1745339,17.959427 C27.912592,19.0720971 26.7975899,19.9799551 25.6833652,19.9799551 L17.7147349,19.9799551 C16.5997329,19.9799551 15.9081519,19.0720971 16.1693165,17.959427 L19.8810021,2.02372071 C20.1406124,0.907164181 21.2534767,8.34454131e-05 22.3684787,8.34454131e-05"
                                id="Path"
                                fill="#007B84"
                            />
                            <path
                                d="M8.33729225,5.10701793 C7.51746075,5.11537364 7.27533938,5.10701793 7.19800044,5.08875195 C7.16826963,5.2300218 6.61504363,7.78201225 6.61348906,7.78414975 C6.49437156,8.30045513 6.40770538,8.66849513 6.11331219,8.90614719 C5.94619791,9.04430794 5.75110171,9.11095931 5.52491449,9.11095931 C5.16134379,9.11095931 4.94953615,8.93043706 4.91397579,8.58804713 L4.90717464,8.47048419 C4.90717464,8.47048419 5.01793641,7.77890313 5.01793641,7.77501675 C5.01793641,7.77501675 5.59856136,5.44940786 5.70252199,5.14199534 C5.70796291,5.12450664 5.70951746,5.11537364 5.71087769,5.10701793 C4.58071884,5.11692819 4.38037603,5.10701793 4.36657939,5.08875195 C4.35900094,5.11381909 4.33101903,5.25800373 4.33101903,5.25800373 L3.73815199,7.87917169 L3.68724043,8.10147256 L3.58872074,8.82861394 C3.58872074,9.04430794 3.63108226,9.22036088 3.71541668,9.36920919 C3.98551998,9.84120988 4.75599451,9.91194194 5.19185185,9.91194194 C5.75343354,9.91194194 6.28023213,9.79263013 6.63622438,9.57479863 C7.25415856,9.20967338 7.41583194,8.63895869 7.56001656,8.13178631 L7.62686225,7.87159325 C7.62686225,7.87159325 8.22497594,5.45620904 8.32660469,5.14199534 C8.33049113,5.12450664 8.33204562,5.11537364 8.33729225,5.10701793 Z M10.3723361,7.0555315 C10.2281514,7.0555315 9.96465494,7.09050888 9.7279745,7.20651731 C9.64208556,7.25062769 9.56086025,7.30153925 9.47516556,7.3522565 L9.5525045,7.07302019 L9.510143,7.025995 C9.00821719,7.12762381 8.89590088,7.14122613 8.43225594,7.20651731 L8.39339213,7.23236169 C8.33956581,7.67871231 8.29176331,8.01430106 8.09219781,8.891651 C8.01621913,9.21499769 7.93732563,9.5414535 7.85823781,9.86402288 L7.87961288,9.90502419 C8.35472269,9.87995706 8.49890731,9.87995706 8.911835,9.88675819 L8.94525788,9.85042056 C8.997724,9.5816775 9.00452513,9.51871819 9.12072788,8.97443088 C9.1753315,8.71637531 9.28920238,8.14935269 9.34536056,7.94745538 C9.44854388,7.89965288 9.550367,7.85262769 9.64752644,7.85262769 C9.87896031,7.85262769 9.85078406,8.05452506 9.84184538,8.13497313 C9.83193513,8.27002475 9.74760069,8.71112875 9.66112881,9.08985631 L9.60341606,9.3343095 C9.56319206,9.51483181 9.51908163,9.69030175 9.47885763,9.8692695 L9.49634631,9.90502419 C9.96465494,9.87995706 10.1074794,9.87995706 10.5073877,9.88675819 L10.5544129,9.85042056 C10.6266995,9.43069169 10.6478803,9.31837538 10.7761308,8.70724231 L10.8406446,8.4264515 C10.9659804,7.87691756 11.0289397,7.59826425 10.9341121,7.37129975 C10.8338435,7.11693625 10.5932767,7.0555315 10.3723361,7.0555315 Z M12.645712,7.63089038 C12.3967894,7.67869288 12.2380309,7.71056113 12.0802439,7.73115894 C11.9238172,7.75622613 11.7712768,7.77896144 11.53071,7.81238425 L11.5116667,7.82967863 L11.4941781,7.84347531 C11.4691109,8.02263738 11.4516222,8.1775095 11.4183937,8.35958638 C11.3902174,8.54788138 11.3468843,8.7618265 11.2763466,9.06923906 C11.2217429,9.30455925 11.1935667,9.38656188 11.1624756,9.46934175 C11.1321619,9.55212156 11.0987391,9.63256963 11.0373343,9.86400344 L11.0517139,9.88537856 L11.0637616,9.90500475 C11.2885886,9.89431719 11.4356881,9.88673875 11.5868682,9.88537856 C11.737854,9.87993763 11.8942807,9.88537856 12.1364021,9.88673875 L12.1575829,9.86944438 L12.1803182,9.85040113 C12.2152956,9.64170263 12.2205422,9.58554444 12.2419173,9.48372131 C12.263098,9.37451406 12.29963,9.223334 12.389211,8.81953925 C12.4315726,8.629884 12.4787921,8.44081169 12.5227081,8.24727 C12.5683731,8.05450563 12.6161755,7.86465606 12.6616461,7.67500081 L12.654845,7.65207119 L12.645712,7.63089038 Z M12.6510169,6.85513037 C12.4248297,6.72163331 12.0278361,6.76399481 11.7606476,6.9484035 C11.4942364,7.12912006 11.4639226,7.38562106 11.6893326,7.520867 C11.9116334,7.65067206 12.3101815,7.61200263 12.5750381,7.42603938 C12.8408665,7.24143644 12.874095,6.98726725 12.6510169,6.85513037 Z M14.0189249,9.94684162 C14.476546,9.94684162 14.9456319,9.82072862 15.2987094,9.44647038 C15.5703673,9.14294425 15.6949256,8.69134706 15.7380645,8.50538387 C15.8785571,7.88900425 15.7691555,7.60121787 15.631772,7.42594225 C15.4230735,7.15875369 15.0542563,7.07305906 14.6716423,7.07305906 C14.4415686,7.07305906 13.8935893,7.09579438 13.4655048,7.49045612 C13.1580921,7.77513331 13.016045,8.16143938 12.9303504,8.53181119 C12.8438785,8.90917856 12.7443871,9.5885175 13.3691225,9.84132644 C13.5618869,9.92410631 13.839763,9.94684162 14.0189249,9.94684162 Z M13.9831702,8.55998744 C14.0886855,8.09323344 14.2132439,7.70148644 14.5311496,7.70148644 C14.7802665,7.70148644 14.7983381,7.99296488 14.6875764,8.46127344 C14.6677559,8.56523406 14.5768146,8.95173444 14.4538108,9.11632256 C14.3679218,9.23777188 14.266293,9.31141875 14.1539766,9.31141875 C14.1205537,9.31141875 13.9217655,9.31141875 13.9186564,9.01624831 C13.9171019,8.87050913 13.9468326,8.72166081 13.9831702,8.55998744 Z M16.88202,9.8868165 L16.9177746,9.85047888 C16.9684919,9.58173581 16.9768476,9.51858213 17.089164,8.97448919 C17.1453221,8.71643363 17.2615247,8.149411 17.3161285,7.94751363 C17.4195061,7.89951687 17.5195804,7.85249169 17.6198489,7.85249169 C17.8497281,7.85249169 17.8217463,8.05438906 17.8126134,8.13483706 C17.8042575,8.27008306 17.7199233,8.71099269 17.6318966,9.08972025 L17.5772931,9.3341735 C17.5355145,9.51489006 17.4900439,9.69016575 17.4498199,9.86932781 L17.4673086,9.9050825 C17.9371718,9.88001531 18.0745551,9.88001531 18.4767954,9.8868165 L18.5253751,9.85047888 C18.5959129,9.43055569 18.6149561,9.31823931 18.747093,8.70730063 L18.8100524,8.4263155 C18.935971,7.87678156 18.9997075,7.59832256 18.9064345,7.37135806 C18.8032511,7.11699456 18.5611298,7.05558981 18.3432983,7.05558981 C18.1989193,7.05558981 17.9340626,7.09037287 17.6987424,7.20657563 C17.6146024,7.250686 17.5302679,7.30140325 17.447488,7.35231481 L17.5195804,7.0730785 L17.4809109,7.025859 C16.9791795,7.12768212 16.8645312,7.14128444 16.4014693,7.20657563 L16.3659089,7.23242 C16.3097507,7.67877056 16.2640857,8.01416506 16.0645203,8.89170931 C15.9885416,9.215056 15.9096481,9.54151175 15.8307546,9.86408119 L15.8519354,9.9050825 C16.3278224,9.88001531 16.4698696,9.88001531 16.88202,9.8868165 Z M20.3341928,9.90498531 C20.3637293,9.76080069 20.5391992,8.90618606 20.5407538,8.90618606 C20.5407538,8.90618606 20.690185,8.27911888 20.6993181,8.25638356 C20.6993181,8.25638356 20.7463432,8.19109244 20.7933684,8.165248 L20.8625459,8.165248 C21.5152633,8.165248 22.2523149,8.165248 22.830025,7.7402725 C23.2231323,7.44879413 23.4918753,7.01837769 23.61177,6.49527119 C23.6428611,6.36702069 23.6657908,6.21448033 23.6657908,6.06193999 C23.6657908,5.86159717 23.6255668,5.66339186 23.509364,5.50851969 C23.2147765,5.09636925 22.6281278,5.08879081 21.9509262,5.0856817 C21.9487888,5.0856817 21.6170863,5.08879081 21.6170863,5.08879081 C20.7502296,5.09947835 20.402593,5.09636925 20.2597686,5.07888055 C20.2477209,5.14203419 20.2249855,5.25435054 20.2249855,5.25435054 C20.2249855,5.25435054 19.9144639,6.6934765 19.9144639,6.69580831 C19.9144639,6.69580831 19.1713884,9.75555406 19.1364109,9.89973869 C19.8932831,9.89060575 20.2036105,9.89060575 20.3341928,9.90498531 Z M20.9095711,7.34852556 C20.9095711,7.34852556 21.239719,5.91231441 21.2381645,5.91775534 L21.2488519,5.84410847 L21.2535156,5.7879503 L21.3854581,5.80155261 C21.3854581,5.80155261 22.0663516,5.86004261 22.0822859,5.86159717 C22.3510289,5.9655578 22.4617906,6.23352359 22.3844517,6.58329763 C22.313914,6.90295225 22.1065757,7.17169538 21.8401645,7.30150038 C21.6207784,7.41148488 21.3520352,7.42061788 21.0751309,7.42061788 L20.8959689,7.42061788 L20.9095711,7.34852556 Z M22.9651545,8.58658975 C22.8779053,8.95851612 22.7776366,9.63785513 23.3992629,9.8799765 C23.5974681,9.96431088 23.7750756,9.989378 23.955598,9.98024506 C24.1462249,9.96994612 24.3228608,9.87434125 24.4864773,9.73676344 C24.4717091,9.79331025 24.4569409,9.84985706 24.4421726,9.90659819 L24.4703488,9.94293581 C24.9174766,9.92408688 25.0562204,9.92408688 25.5406574,9.92777894 L25.5845735,9.89435606 C25.6553056,9.47851356 25.721957,9.07471888 25.9057828,8.27917719 C25.9953636,7.89811775 26.0847504,7.52075044 26.1766633,7.14124556 L26.1622838,7.099467 C25.6621068,7.19215713 25.5284154,7.21197769 25.0472816,7.28018363 L25.0107498,7.30991438 C25.0058918,7.34858388 25.0008395,7.38569875 24.9961758,7.42281369 C24.921363,7.30194731 24.8129331,7.198764 24.6456245,7.13444444 C24.4316793,7.05030431 23.9291706,7.15873425 23.4971996,7.55203575 C23.1936735,7.83282663 23.0479344,8.21757806 22.9651545,8.58658975 Z M24.0156425,8.60932506 C24.1227122,8.15092669 24.2457161,7.76306612 24.5643993,7.76306612 C24.7659079,7.76306612 24.872006,7.94902931 24.8504366,8.26615781 C24.8333366,8.34524563 24.8148763,8.42860844 24.7929181,8.52285313 C24.76105,8.65907069 24.7264611,8.79412231 24.692844,8.92936831 C24.6586437,9.02186413 24.6188085,9.10911331 24.5750868,9.16721469 C24.4930841,9.28341738 24.297988,9.35550969 24.1856716,9.35550969 C24.1538032,9.35550969 23.9571525,9.35550969 23.9503514,9.06558588 C23.9487967,8.92120694 23.9785276,8.77255294 24.0156425,8.60932506 Z M29.5013629,7.0957555 L29.4626935,7.05164513 C28.9677631,7.15191369 28.878182,7.16784781 28.4234759,7.22925263 L28.3900529,7.26267544 C28.3884985,7.26811638 28.3871381,7.27647213 28.3848064,7.28405056 L28.3832518,7.27647213 C28.0447483,8.05743988 28.0546585,7.88896538 27.7791143,8.50379044 C27.7775596,8.4758085 27.7775596,8.45831981 27.7760053,8.428589 L27.7070219,7.0957555 L27.6636888,7.05164513 C27.145246,7.15191369 27.1330039,7.16784781 26.654202,7.22925263 L26.6168929,7.26267544 C26.6116461,7.27860963 26.6116461,7.29609831 26.6085371,7.31514156 L26.6116461,7.32194275 C26.6714964,7.62780075 26.6571168,7.55959481 26.7171614,8.042283 C26.7451433,8.27915775 26.7824525,8.51739275 26.8104344,8.75135275 C26.857654,9.14290538 26.8840814,9.33566975 26.941794,9.93320044 C26.6184472,10.4668002 26.5418856,10.6686976 26.2305868,11.1370062 L26.2327243,11.1416698 L26.0135325,11.4883348 C25.9884654,11.5248668 25.9657301,11.5499339 25.9338617,11.5606214 C25.8988844,11.5779158 25.8534138,11.5810249 25.79026,11.5810249 L25.6688107,11.5810249 L25.4882885,12.1814704 L26.1075829,12.1921579 C26.4711535,12.1906034 26.6996726,12.0205743 26.8226765,11.7920553 L27.2120916,11.1247641 L27.2058734,11.1247641 L27.2468747,11.0777389 C27.5088166,10.5138254 29.5013629,7.0957555 29.5013629,7.0957555 Z M22.965135,14.9817031 L22.7024157,14.9817031 L23.6747877,11.7655307 L23.9973571,11.7655307 L24.0997631,11.4342169 L24.1096734,11.8026456 C24.0976256,12.0303874 24.2767877,12.2322848 24.7474281,12.1988619 L25.2917154,12.1988619 L25.4790389,11.5795675 L25.2742267,11.5795675 C25.1564695,11.5795675 25.1018659,11.5498367 25.1086671,11.4861001 L25.0987567,11.1112589 L24.0908245,11.1112589 L24.0908245,11.1132021 C23.7649517,11.1200033 22.7918025,11.1444874 22.5947631,11.1969536 C22.3563339,11.2583583 22.1050794,11.4390749 22.1050794,11.4390749 L22.2037934,11.1073725 L21.260958,11.1073725 L21.0645016,11.7655307 L20.0791104,15.0308659 L19.8879005,15.0308659 L19.7003827,15.645691 L21.5782809,15.645691 L21.5153215,15.8506974 L22.4406681,15.8506974 L22.502073,15.645691 L22.7616831,15.645691 L22.965135,14.9817031 Z M22.1946605,12.4190253 C22.0436748,12.4608038 21.7626895,12.5874998 21.7626895,12.5874998 L22.0125836,11.7655307 L22.7616831,11.7655307 L22.5809665,12.3644216 C22.5809665,12.3644216 22.3495326,12.3780239 22.1946605,12.4190253 Z M22.2090401,13.5932945 C22.2090401,13.5932945 21.9737199,13.622831 21.8188476,13.6578084 C21.6663072,13.7040564 21.3802699,13.8497955 21.3802699,13.8497955 L21.6383254,12.9944036 L22.3913112,12.9944036 L22.2090401,13.5932945 Z M21.7893113,14.9892816 L21.03788,14.9892816 L21.2557115,14.2673869 L22.0048109,14.2673869 L21.7893113,14.9892816 Z M23.5989255,12.9944036 L24.6820593,12.9944036 L24.5264098,13.4984669 L23.4288966,13.4984669 L23.264114,14.0495554 L24.2244381,14.0495554 L23.4972969,15.0734218 C23.4463853,15.1486232 23.4007203,15.1752449 23.3500031,15.1964256 C23.2990915,15.22227 23.2322459,15.2525837 23.1549069,15.2525837 L22.8884956,15.2525837 L22.7054471,15.8561384 L23.4022748,15.8561384 C23.7644853,15.8561384 23.9784304,15.6913559 24.1364118,15.4750789 L24.6350341,14.7926309 L24.7421039,15.4855723 C24.7648391,15.6153771 24.8581123,15.6913559 24.9212659,15.7208924 C24.9910264,15.7558698 25.0631188,15.8159144 25.1649419,15.824853 C25.274149,15.8295166 25.3530425,15.8332088 25.4055086,15.8332088 L25.7478986,15.8332088 L25.953488,15.1577561 L25.8184364,15.1577561 C25.740903,15.1577561 25.607406,15.1447367 25.5846708,15.1204469 C25.5619354,15.0909104 25.5619354,15.0454397 25.5496933,14.9762623 L25.441069,14.2817664 L24.9962729,14.2817664 L25.1913693,14.0495554 L26.2867449,14.0495554 L26.4552194,13.4984669 L25.441069,13.4984669 L25.5990503,12.9944036 L26.6100916,12.9944036 L26.7976094,12.3727774 L23.7833343,12.3727774 L23.5989255,12.9944036 Z M14.4507405,15.1296383 L14.7035494,14.288626 L15.7425728,14.288626 L15.9324223,13.6631134 L14.8924274,13.6631134 L15.051186,13.1454478 L16.0674739,13.1454478 L16.255769,12.5397556 L13.7129115,12.5397556 L13.5285029,13.1454478 L14.106213,13.1454478 L13.9521181,13.6631134 L13.3728534,13.6631134 L13.1808664,14.2993135 L13.7583821,14.2993135 L13.4214331,15.4119836 C13.3759625,15.5592774 13.4428083,15.6154355 13.4851698,15.6838358 C13.5285029,15.7504871 13.572419,15.7945975 13.671133,15.8196646 C13.7729561,15.8424 13.8427166,15.8560023 13.9375443,15.8560023 L15.1088988,15.8560023 L15.3175973,15.163061 L14.798377,15.2343761 C14.6981085,15.2343761 14.4204268,15.2223284 14.4507405,15.1296383 Z M14.5699163,11.1035833 L14.3066141,11.5794704 C14.2502616,11.6834309 14.1995444,11.7479449 14.1538795,11.7776756 C14.1136555,11.8027428 14.0339848,11.813236 13.9185593,11.813236 L13.7811757,11.813236 L13.5975444,12.4220372 L14.0538052,12.4220372 C14.2731912,12.4220372 14.4416658,12.3415892 14.5221139,12.3013651 C14.6085857,12.2551173 14.631321,12.2815446 14.6981668,12.2170308 L14.8522618,12.0835336 L16.277008,12.0835336 L16.4660804,11.4496653 L15.4231706,11.4496653 L15.6052475,11.1035833 L14.5699163,11.1035833 Z M16.673302,15.1418609 C16.6490121,15.1068834 16.6665009,15.0452844 16.7036158,14.9170339 L17.0930309,13.6281165 L18.4783305,13.6281165 C18.6802279,13.6252018 18.825967,13.6228699 18.9207946,13.6160688 C19.0226178,13.6053811 19.1333796,13.5690435 19.2540516,13.5037524 C19.3786101,13.4353521 19.4423466,13.3632598 19.496173,13.2804799 C19.5562175,13.1978944 19.6525998,13.0171778 19.7353796,12.7385245 L20.224869,11.1074114 L18.7872976,11.1157671 C18.7872976,11.1157671 18.3446391,11.1810583 18.1497373,11.2531506 C17.9530865,11.3335986 17.6721013,11.5582313 17.6721013,11.5582313 L17.8019064,11.1111034 L16.9138688,11.1111034 L15.6706164,15.2343568 C15.626506,15.3944754 15.5969695,15.5106781 15.5901272,15.5804386 C15.5878365,15.6556401 15.684996,15.7300643 15.7479554,15.7862224 C15.8223795,15.8423806 15.9323639,15.8332476 16.0378791,15.8423806 C16.1488353,15.8507364 16.3066223,15.8559829 16.5244536,15.8559829 L17.2069018,15.8559829 L17.4163775,15.148662 L16.8054389,15.2063748 C16.7401478,15.2063748 16.6929283,15.1713973 16.673302,15.1418609 Z M17.3442853,12.7575676 L18.7993454,12.7575676 L18.7068496,13.0474915 C18.6938303,13.0542926 18.6627391,13.0331119 18.5146681,13.0506006 L17.2547043,13.0506006 L17.3442853,12.7575676 Z M17.6357636,11.7851958 L19.1030657,11.7851958 L18.9975506,12.1343869 C18.9975506,12.1343869 18.3059696,12.1275858 18.1952079,12.1479892 C17.7078559,12.2323236 17.4231788,12.492711 17.4231788,12.492711 L17.6357636,11.7851958 Z M18.7394174,14.0183671 C18.7273696,14.0617003 18.7083264,14.0881276 18.6817048,14.1079481 C18.6521681,14.1269914 18.6043657,14.1337925 18.5330508,14.1337925 L18.3257124,14.1337925 L18.3379545,13.7807151 L17.4755671,13.7807151 L17.4405898,15.5068501 C17.4392295,15.6314085 17.4512773,15.7035009 17.5424129,15.7612136 C17.6335484,15.8333059 17.9143393,15.8424389 18.2922895,15.8424389 L18.8326905,15.8424389 L19.0277867,15.1963285 L18.5573405,15.2221729 L18.4009139,15.2313059 C18.3795387,15.2221729 18.3591353,15.2138171 18.3364,15.1910819 C18.3165794,15.1714556 18.2831566,15.1835035 18.2885975,15.058945 L18.2922895,14.6164809 L18.7856654,14.5960774 C19.0520766,14.5960774 19.1659475,14.509411 19.2631069,14.4268255 C19.355797,14.3477378 19.3861108,14.2567965 19.4210882,14.1337925 L19.5038681,13.7420456 L18.8258892,13.7420456 L18.7394174,14.0183671 Z"
                                id="Shape"
                                fill="#FEFEFE"
                            />
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

UnionPay.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

UnionPay.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default UnionPay;
