import React from 'react';
import PropTypes from 'prop-types';

const TrashFilled = (props) => {
    const { className, style, title } = props;
    return (
        <svg
            className={className}
            style={style}
            fill="currentColor"
            width="16px"
            height="18px"
            viewBox="0 0 16 18"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
        >
            <title>{title}</title>
            <g id="modules" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="RecordSection"
                    transform="translate(-968.000000, -101.000000)"
                    fill="currentColor"
                    fillRule="nonzero"
                >
                    <g id="Group" transform="translate(953.000000, 90.000000)">
                        <path
                            d="M29.3199368,16.2771011 C29.4563346,16.4220942 29.526788,16.6168274 29.51467,16.8153651 C29.1463396,22.8663734 28.9541427,26.0244239 28.9380793,26.2895165 C28.8455035,27.8094783 27.5803012,29 26.0575213,29 L19.5256451,29 C18.0028651,29 16.7376628,27.8094783 16.6450871,26.2895165 L16.0684964,16.8153651 C16.0563784,16.6168274 16.1268318,16.4220942 16.2632296,16.2771011 C16.3996274,16.1322489 16.5897107,16.0501002 16.7886711,16.0501002 L28.7944952,16.0501002 C28.9934557,16.0501002 29.183539,16.1322489 29.3199368,16.2771011 Z M30.5831663,14.352314 C30.5831663,14.7507985 30.2602079,15.0737569 29.8617234,15.0737569 L15.7214429,15.0737569 C15.3229584,15.0737569 15,14.7507985 15,14.352314 C15,13.9538295 15.3229584,13.6308711 15.7214429,13.6308711 L19.5569264,13.6308711 C19.6865606,12.1586767 20.9255542,11 22.4308617,11 L23.1523046,11 C24.6576121,11 25.8966057,12.1586767 26.02624,13.6308711 L29.8617234,13.6308711 C30.2602079,13.6308711 30.5831663,13.9538295 30.5831663,14.352314 Z M21.0109438,13.6308711 L24.5722226,13.6308711 C24.4514654,12.9564911 23.860925,12.4428858 23.1523046,12.4428858 L22.4308617,12.4428858 C21.7222414,12.4428858 21.1317009,12.9564911 21.0109438,13.6308711 Z M22.0701403,19.6933868 L22.0701403,25.4649299 C22.0701403,25.8634143 22.3930987,26.1863727 22.7915832,26.1863727 C23.1900676,26.1863727 23.5130261,25.8634143 23.5130261,25.4649299 L23.5130261,19.6933868 C23.5130261,19.2949023 23.1900676,18.9719439 22.7915832,18.9719439 C22.3930987,18.9719439 22.0701403,19.2949023 22.0701403,19.6933868 Z M19.8769257,20.0546718 C19.478864,20.0705943 19.1690099,20.4062344 19.1849324,20.804437 L19.3292209,24.4116514 C19.3447207,24.7998497 19.6644383,25.1042084 20.0495366,25.1042084 C20.0594,25.1042084 20.0691226,25.1040675 20.0789861,25.1036448 C20.4770479,25.0877223 20.7869019,24.7519414 20.7709795,24.3538796 L20.6266909,20.7466652 C20.6107684,20.3486034 20.2747056,20.037763 19.8769257,20.0546718 Z M24.9564755,20.7466652 L24.8121869,24.3538796 C24.7962644,24.7520823 25.1061185,25.0877223 25.5041802,25.1036448 C25.5140437,25.1040675 25.5237663,25.1042084 25.5336298,25.1042084 C25.9187281,25.1042084 26.2384457,24.7998497 26.2539454,24.4116514 L26.398234,20.804437 C26.4141564,20.4062344 26.1043024,20.0705943 25.7062406,20.0546718 C25.3081789,20.037763 24.9723979,20.3486034 24.9564755,20.7466652 L24.9564755,20.7466652 Z"
                            id="Shape"
                        />
                    </g>
                </g>
            </g>
        </svg>
    );
};

TrashFilled.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};
TrashFilled.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default TrashFilled;
