import React from 'react';
import { IconProps } from '../../types';

const SvgFile: React.FC<IconProps> = (props: IconProps) => {
    const { className, style, title } = props;
    return (
        <svg
            className={className}
            style={style}
            fill="currentColor"
            width="20px"
            height="21px"
            viewBox="0 0 20 21"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
        >
            <title>{title}</title>
            <g id="marketplace" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="marketplace/functions-source-code/download"
                    transform="translate(-183.000000, -609.000000)"
                    fill="#F2A916"
                >
                    <path
                        d="M191.542141,615.980764 C191.707906,614.49912 191.905619,613.274866 191.416159,612.089792 C191.013499,611.11509 191.152139,610.298318 192.003873,609.69915 C192.678991,609.224759 193.454172,609.244651 194.096137,609.775101 C194.838767,610.38753 194.985244,611.172355 194.557267,612.071709 C193.988239,613.268235 194.401146,614.512382 194.258889,616.126035 C195.495802,614.951208 196.615775,614.24354 197.106441,612.90114 C197.420491,612.042775 198.122735,611.693763 199.034145,611.816731 C199.887084,611.932465 200.406081,612.452065 200.534474,613.270646 C200.672512,614.1483 200.354845,614.889122 199.476588,615.2092 C198.179397,615.68118 197.467509,616.770411 196.435542,617.838544 C197.82496,618.13632 199.0462,618.261699 200.215602,617.805391 C201.189701,617.425637 201.982362,617.48471 202.622519,618.326197 C203.140913,619.007343 203.111979,619.756604 202.60323,620.417255 C201.95825,621.254522 201.131833,621.322637 200.183654,620.891646 C199.033542,620.369032 197.826768,620.76265 196.565141,620.800626 C197.383722,621.803056 198.031715,622.910973 199.312028,623.400434 C200.212588,623.744623 200.672512,624.423961 200.530255,625.403485 C200.408492,626.238341 199.887084,626.763969 199.054036,626.892362 C198.077526,627.043058 197.369255,626.597601 197.046163,625.689808 C196.596486,624.427578 195.483746,623.815752 194.46263,622.740988 C194.237188,624.220823 194.059367,625.45653 194.57957,626.672949 C194.967763,627.580742 194.834547,628.360142 194.064189,628.958104 C193.405949,629.468662 192.661511,629.503623 191.971323,628.996682 C191.178059,628.414392 190.982154,627.627759 191.381197,626.735036 C191.921292,625.524645 191.643408,624.294363 191.606036,622.78258 C190.474007,623.677714 189.470974,624.377547 188.990555,625.555387 C188.596334,626.519842 187.963411,627.050292 186.9218,626.902007 C186.100808,626.784464 185.572769,626.268481 185.453418,625.416144 C185.30453,624.349819 185.827747,623.724732 186.789188,623.349197 C188.000181,622.877217 188.667463,621.824153 189.607806,620.727689 C188.053226,620.686699 186.745184,620.409419 185.438951,621.020642 C184.607712,621.409438 183.842779,621.087551 183.329809,620.356977 C182.892791,619.733095 182.890982,619.01759 183.317151,618.381653 C183.821681,617.629981 184.604698,617.317136 185.422073,617.678204 C186.732526,618.257479 188.023087,618.041683 189.608409,617.932579 C188.536659,616.790303 187.808496,615.684194 186.461273,615.198953 C185.574577,614.879477 185.325025,614.116352 185.470899,613.232068 C185.598689,612.456888 186.074286,611.97466 186.848863,611.840842 C187.730134,611.688941 188.507725,611.925835 188.824187,612.813133 C189.306414,614.167589 190.430004,614.883094 191.542141,615.980764"
                        id="svg"
                    />
                </g>
            </g>
        </svg>
    );
};

SvgFile.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default SvgFile;
