import React from 'react';
import PropTypes from 'prop-types';

const Store = (props) => {
    const { className, style, title } = props;
    return (
        <svg width="48px" height="35px" viewBox="0 0 48 35" className={className} style={style}>
            <title>{title}</title>
            <g id="marketplace" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="marketplace-copy-7"
                    transform="translate(-54.000000, -82.000000)"
                    fill="currentColor"
                    fillRule="nonzero"
                >
                    <path
                        d="M96.9415141,82.4116072 C97.3475929,82.4116072 97.714306,82.6423468 97.8926178,82.99958 L97.9403103,83.1104405 L101.548383,93.0017156 C101.590951,93.1184413 101.612745,93.2417391 101.612745,93.3659919 C101.612745,94.2695749 101.435333,95.1479401 101.085724,95.9745649 C100.748276,96.7723857 100.264918,97.489359 99.6501281,98.1041489 C99.239248,98.515029 98.7826223,98.8672991 98.2866021,99.1565421 L97.966,99.331 L97.966145,115.027249 C97.966145,115.466092 97.9045415,115.896432 97.7826497,116.311458 L97.7022906,116.558582 L97.6075255,116.801703 C97.3779777,117.34437 97.0491459,117.832171 96.631201,118.250116 C96.2132228,118.668094 95.7254445,118.996923 95.182767,119.226475 C94.7007169,119.430356 94.1927187,119.548196 93.6705467,119.577703 L93.4083341,119.585086 L62.5900897,119.585086 C61.975775,119.585086 61.3780402,119.464333 60.8156356,119.226466 C60.2729793,118.996923 59.785201,118.668094 59.3672228,118.250116 C58.9492642,117.832158 58.6204331,117.344346 58.3909233,116.801702 C58.1870204,116.319658 58.0691715,115.811657 58.0396616,115.289482 L58.0322789,115.027268 L58.031,99.329 L57.8950152,99.2595252 C57.5168364,99.0546931 57.1603196,98.8143129 56.8280934,98.5402566 L56.5835194,98.3284293 L56.3483008,98.1041489 C55.7335109,97.489359 55.2501527,96.7723857 54.9127066,95.9745679 C54.5630893,95.1479892 54.3856842,94.2696232 54.3856842,93.3659919 C54.3856842,93.2831567 54.3953702,93.200746 54.4144442,93.1204133 L54.4500591,93.0016796 L58.0581123,83.1104578 C58.1972593,82.7289527 58.5397058,82.4635308 58.9364211,82.4184252 L59.0569148,82.4116072 L96.9415141,82.4116072 Z M66.724,96.986 L66.6845897,97.0507139 C66.4357575,97.4282078 66.1483756,97.7803881 65.8246069,98.1041568 C65.2097915,98.7189447 64.492813,99.2023133 63.6950208,99.5397486 C62.868406,99.8893536 61.9900408,100.066766 61.0864578,100.066766 C60.876775,100.066766 60.6683562,100.057212 60.4615375,100.038146 L60.157,100.003 L60.1586465,115.027249 C60.1586465,116.313909 61.1642883,117.371024 62.4304825,117.453534 L62.59006,117.458718 L63.952,117.458 L63.9530559,106.957388 C63.9530559,106.246321 64.2056584,105.571854 64.6671347,105.039528 L64.8118001,104.8842 C65.3146217,104.381379 65.9701564,104.083072 66.6728655,104.03299 L66.8849879,104.025456 L72.5446266,104.025456 C73.3268518,104.025456 74.0647434,104.331099 74.6178144,104.8842 C75.120636,105.387022 75.4189424,106.042557 75.4690244,106.745296 L75.4765586,106.957428 L75.475,117.458 L93.4083341,117.458718 C94.6949973,117.458718 95.7521087,116.453073 95.8346189,115.186806 L95.84,115.02722 L95.84,100.003 L95.5368872,100.038146 C95.4334787,100.047679 95.3296703,100.054834 95.2255036,100.059606 L94.9119711,100.066766 C94.0083719,100.066766 93.1300314,99.8893572 92.3033982,99.5397444 C91.5056049,99.2023087 90.7886253,98.7189346 90.1738396,98.1041489 C89.850083,97.7803923 89.5627058,97.4282196 89.3138696,97.0507289 L89.274,96.987 L89.2349502,97.050697 C89.0483231,97.3338159 88.8400092,97.6026997 88.6109238,97.8560392 L88.3749485,98.1041489 C87.7601549,98.7189425 87.0431714,99.2023145 86.2453545,99.5397486 C85.4187397,99.8893536 84.5403745,100.066766 83.6367915,100.066766 C82.7331878,100.066766 81.8548456,99.8893555 81.0282498,99.5397468 C80.2304371,99.2023145 79.5134536,98.7189425 78.89866,98.1041489 C78.5748907,97.7803797 78.2875105,97.4282073 78.0386763,97.0507188 L77.999,96.987 L77.9597739,97.0507153 C77.7731484,97.3338344 77.5648363,97.6027122 77.3357484,97.8560454 L77.0997689,98.1041489 C76.4849753,98.7189425 75.7679918,99.2023145 74.9701804,99.5397463 C74.1435886,99.8893532 73.2652214,100.066766 72.3616119,100.066766 C71.4580244,100.066766 70.5796575,99.8893519 69.7530702,99.5397468 C68.9552575,99.2023145 68.238274,98.7189425 67.6234804,98.1041489 C67.2997053,97.7803738 67.0123149,97.4281889 66.7634787,97.050697 L66.724,96.986 Z M72.5446266,106.151824 L66.8849879,106.151824 C66.4753673,106.151824 66.1355714,106.460111 66.0857188,106.856592 L66.0794236,106.957422 L66.078,117.458 L73.349,117.458 L73.3501909,106.957388 C73.3501909,106.547758 73.0419171,106.20797 72.6454526,106.158119 L72.5446266,106.151824 Z M89.0179001,102.024885 C90.5858037,102.024885 91.8953138,103.2075 92.0631929,104.75675 L92.0631929,104.75675 L92.0719388,104.864662 L92.0810712,105.088056 L92.0810712,110.936803 C92.0810712,112.504693 90.8984715,113.814232 89.3492175,113.98212 L89.3492175,113.98212 L89.1254557,113.997106 L89.0179001,114 L81.0631711,114 C79.4952546,114 78.1857552,112.817351 78.0178782,111.268108 L78.0178782,111.268108 L78.0091323,111.160197 L78,110.936803 L78,105.088056 C78,103.520153 79.1826147,102.210642 80.7318653,102.042763 L80.7318653,102.042763 L80.839777,102.034017 L81.0631711,102.024885 Z M89.0179001,104.024885 L81.0631711,104.024885 L80.9473269,104.031124 C80.4146471,104.088846 80,104.540028 80,105.088056 L80,105.088056 L80,110.936803 L80.0062385,111.052648 C80.0639602,111.585329 80.5151408,112 81.0631711,112 L81.0631711,112 L89.0179001,112 L89.1337447,111.993761 C89.666426,111.936036 90.0810712,111.48483 90.0810712,110.936803 L90.0810712,110.936803 L90.0810712,105.088056 L90.0748327,104.972212 C90.0171107,104.439532 89.5659284,104.024885 89.0179001,104.024885 L89.0179001,104.024885 Z M67.411,84.537 L59.8,84.537 L56.516,93.541 L56.5217136,93.6653519 C56.6719882,95.9810607 58.5528159,97.8288409 60.8742413,97.9355306 L61.0864578,97.9403979 C63.5362892,97.9403979 65.5431937,96.0034885 65.6593322,93.6371639 L65.6637722,93.4203025 L65.6628273,93.3072499 L65.6703656,93.2250869 L65.6825074,93.1532193 L67.411,84.537 Z M76.935,84.537 L69.578,84.537 L67.788,93.457 L67.7912316,93.5593219 C67.8900335,95.9272472 69.7946476,97.8257671 72.1466032,97.9353964 L72.3616119,97.9403979 C74.8114646,97.9403979 76.8183731,96.0034919 76.9310537,93.5809851 L76.9360434,93.3660112 L76.935,84.537 Z M86.418,84.537 L79.061,84.537 L79.0623855,93.3659919 C79.0623855,95.8158233 80.9992949,97.8227278 83.4218163,97.9354082 L83.6367915,97.9403979 C86.069894,97.9403979 88.0688999,96.0287849 88.2039505,93.6255462 L88.208,93.458 L86.418,84.537 Z M96.197,84.537 L88.586,84.537 L90.3279747,93.2292893 L90.3364323,93.3248267 L90.3376052,93.3640561 C90.3375651,95.8878772 92.3900858,97.9403979 94.9119711,97.9403979 C97.330037,97.9403979 99.3218847,96.051232 99.4766916,93.665356 L99.481,93.541 L96.197,84.537 Z"
                        id="store"
                    />
                </g>
            </g>
        </svg>
    );
};

Store.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};
Store.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default Store;
