import React from 'react';
import PropTypes from 'prop-types';

const ShoppingCartFilled = (props) => {
    const { className, style, title } = props;

    return (
        <svg className={className} style={style} width="41px" height="36px" viewBox="0 0 41 36">
            <title>{title}</title>
            <g id="notifications" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <path
                    d="M17.5417649,29.8527615 C19.2441892,29.8592956 20.607759,31.2362474 20.6022385,32.9431835 C20.5967356,34.6310466 19.2218347,36.0002051 17.5325873,36 C15.8344698,35.9997949 14.4493659,34.6149473 14.4533565,32.9212393 C14.457313,31.2237884 15.8436987,29.8463239 17.5417649,29.8527615 Z M32.7825168,29.8523247 C34.482732,29.8466529 35.8570098,31.2138574 35.8660217,32.9200183 C35.8748469,34.61193 34.4825782,36.006864 32.7923067,35.9995632 C31.0993699,35.992256 29.7251946,34.6247953 29.7205176,32.9426735 C29.7157122,31.2389729 31.0839418,29.8581343 32.7825168,29.8523247 Z M4.19082667,-2.44118961e-15 L7.02630856,0.00314843648 C8.76176033,0.00952926774 10.1774317,1.09400192 10.6278512,2.76772754 C10.9225191,4.09335332 11.0780383,4.79298915 11.0944088,4.86663502 L11.0958532,4.87313319 L12.0263456,4.87284764 L13.1493956,4.87202544 C15.8411853,4.86964037 19.7810319,4.86366304 23.7803027,4.85664595 L24.980678,4.85451218 C30.179728,4.8451528 35.2783258,4.83446759 37.6650453,4.82806437 C39.5864815,4.8229597 40.7164931,6.39808469 40.1120605,8.22864443 C39.2015494,10.9862382 38.2917772,13.7441006 37.3822065,16.5019631 L37.3433758,16.6301674 L37.3433758,16.6301674 L37.3067112,16.759077 L36.0904576,20.3791577 C36.035381,20.4269803 36.0406871,20.4915274 36.0416275,20.5549328 C35.9518257,20.8156737 35.862091,21.0764818 35.7722221,21.3372227 C35.0679126,22.6341434 33.9744396,23.2123139 32.5036244,23.2078137 C27.1666972,23.1914251 21.8296356,23.2012314 16.4926412,23.2012986 C16.1038806,23.2012986 16.1037463,23.2017016 16.2018096,23.5665508 C16.3642185,24.1705804 16.542143,24.7710502 16.6823198,25.3802517 C16.7447847,25.6513363 16.8606472,25.7213911 17.1342169,25.7209881 C23.4222911,25.7121221 29.710298,25.7142043 35.998305,25.7143386 C36.46827,25.7143386 36.938235,25.7102414 37.4080657,25.7160849 C38.1781984,25.7256897 38.7155988,26.2352159 38.7166734,26.9489287 C38.717618,27.612808 38.2341952,28.1114534 37.5472187,28.1712462 L37.4071925,28.1772723 L15.9249487,28.1769365 C15.2951529,28.1768125 14.8801441,27.8980319 14.6794468,27.333463 L14.6337371,27.1863628 L8.27460065,3.47908947 C8.09096705,2.7949972 7.67198152,2.4639328 6.96995574,2.46285814 C5.0572512,2.45996997 3.14454665,2.46480597 1.23184211,2.45902964 C0.606520644,2.45714897 0.101158809,2.01619995 0.0135735037,1.42372297 C-0.0737431346,0.833261 0.267530588,0.263419185 0.826491406,0.0733375803 C0.997094684,0.0153055992 1.17475046,0.000528937328 1.3552944,0.000730437263 L4.19082667,-2.44118961e-15 Z M30.2656789,14.9403655 C26.5619757,14.9458059 22.8582054,14.9460074 19.1545023,14.9400938 C18.6128033,14.9392236 18.1894519,15.1272902 17.9384502,15.6142484 C17.6828139,16.1102741 17.8041169,16.5831944 18.0820525,17.0330094 C18.6278934,17.4365914 19.2291095,17.4341883 19.8331814,17.4029285 L20.1955471,17.3837268 C20.3764812,17.3754116 20.5567269,17.3712875 20.7348663,17.3815372 C21.2925677,17.4137268 21.8524605,17.4080218 22.4121927,17.4054243 L27.6037304,17.4059858 L27.8141635,17.4003186 L27.8141635,17.4003186 L28.0245966,17.3947018 L28.2044689,17.3901345 C28.8560525,17.3900673 29.5077704,17.3836193 30.1592869,17.3930227 C30.4624771,17.3974557 30.7532415,17.3658202 31.0290278,17.2347109 C31.0921644,17.1241546 31.1975489,17.0624956 31.30159,16.9994261 C31.30159,16.9994261 31.3030005,16.9976798 31.3029334,16.9976798 C31.6374232,16.5729179 31.7233294,16.1055724 31.479313,15.6182784 C31.2343562,15.1290366 30.8073779,14.9394923 30.2656789,14.9403655 Z M17.6093773,9.63775866 L17.5087785,9.63978206 C16.9140178,9.67054438 16.4333733,10.1294269 16.373998,10.7219039 C16.2962862,11.4984846 16.8404032,12.0808866 17.6688366,12.0827001 L21.326329,12.0855547 L21.326329,12.0855547 L24.9838215,12.0845808 L29.4130588,12.0845136 C30.4309021,12.0841778 31.4489469,12.0959991 32.4663873,12.0773268 C33.2172432,12.0635576 33.7259634,11.4577145 33.6522144,10.712702 C33.5927853,10.1132711 33.1333261,9.69738477 32.4823337,9.64443357 L32.3399796,9.63870739 L17.7100769,9.63830439 L17.6093773,9.63775866 Z"
                    id="shopping-cart-filled"
                    fill="currentColor"
                />
            </g>
        </svg>
    );
};

ShoppingCartFilled.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

ShoppingCartFilled.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default ShoppingCartFilled;
