import React from 'react';
import PropTypes from 'prop-types';

const ShoppingCart = (props) => {
    const { className, style, title } = props;

    return (
        <svg className={className} style={style} width="41px" height="37px" viewBox="0 0 41 37">
            <title>{title}</title>
            <g id="functions" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="functions/installed-function-details-docs"
                    transform="translate(-32.000000, -143.000000)"
                    fill="currentColor"
                >
                    <path
                        d="M65.7824435,171.398555 C67.9570636,171.391301 69.7148013,173.139992 69.7263278,175.322216 C69.7376154,177.486216 67.9568669,179.270374 65.794965,179.261036 C63.6296541,179.25169 61.8720476,177.502671 61.8660656,175.351193 C61.8599194,173.172115 63.6099212,171.405986 65.7824435,171.398555 Z M50.9135381,171.398982 C53.0903216,171.407336 54.8338332,173.167959 54.8267744,175.350511 C54.8197383,177.508676 53.0617384,179.259334 50.9018032,179.259071 C48.7305265,179.258809 46.9594806,177.488091 46.9645831,175.322452 C46.9696421,173.152028 48.7423269,171.39075 50.9135381,171.398982 Z M50.9016721,173.792647 C50.0734795,173.78925 49.3813195,174.471249 49.3703058,175.301671 C49.3590298,176.153071 50.035587,176.852311 50.8814147,176.863456 C51.721211,176.874469 52.4294327,176.179884 52.4356607,175.338973 C52.4418887,174.499177 51.7444185,173.796134 50.9016721,173.792647 Z M65.8061754,173.793249 C64.9767372,173.788359 64.2793326,174.466686 64.262812,175.294485 C64.2459636,176.138019 64.9320923,176.851419 65.7713642,176.862892 C66.6148318,176.874496 67.3218078,176.187318 67.3320349,175.346145 C67.3421963,174.505038 66.6476763,173.798193 65.8061754,173.793249 Z M36.9478611,143.261253 L39.7154276,143.264326 C41.4093119,143.270554 42.7910752,144.329051 43.2307062,145.962688 L43.2307062,145.962688 L47.5308437,162.397128 C47.6183634,162.670045 47.7519048,163.368302 47.9927644,163.489519 C48.1533157,163.570352 48.3622486,163.554946 48.573345,163.535213 L48.573345,163.535213 L64.7836431,163.488536 C64.9386219,163.503876 65.1736469,163.526428 65.3366237,163.450512 C65.583908,163.196016 65.6174736,163.027008 65.6958153,162.755467 L65.6958153,162.755467 L68.1841299,155.230997 C68.6862376,153.720609 69.1802162,152.207468 69.6878963,150.698982 C69.766828,150.464415 69.7822341,150.370143 69.4721454,150.371389 C63.2573903,150.395973 57.0425697,150.409216 50.827749,150.42613 C50.2271078,150.427703 49.6265322,150.441208 49.0258909,150.44383 C48.2530292,150.447174 47.7121768,149.956735 47.7045065,149.252185 C47.6970329,148.563368 48.2528325,148.034972 49.0104848,148.031694 C51.0420577,148.022975 53.0736306,148.023565 55.1052034,148.017665 C59.943571,148.003635 64.7820041,147.986656 69.6203061,147.973675 C71.4957202,147.968693 72.5986658,149.506091 72.0087105,151.292805 C71.120008,153.984349 70.2320266,156.676155 69.3442419,159.367961 C69.3169699,159.450695 69.295008,159.535265 69.2705549,159.618917 C68.8748476,160.796729 68.4791403,161.974542 68.083433,163.152289 C68.0296755,163.198966 68.0348546,163.261968 68.0357724,163.323854 C67.9481215,163.57835 67.8605362,163.832911 67.7728198,164.087407 C67.0853799,165.353264 66.0180978,165.917586 64.5825115,165.913193 C59.3734142,165.897197 54.1641858,165.906769 48.9550229,165.906834 C48.5755739,165.906834 48.5754428,165.907228 48.6711573,166.263338 C48.8296762,166.8529 49.003339,167.438987 49.1401583,168.033597 C49.2011271,168.298189 49.3142145,168.366566 49.5812317,168.366172 C55.718694,168.357519 61.8560908,168.359551 67.9934876,168.359682 C68.452196,168.359682 68.9109044,168.355683 69.3694817,168.361387 C70.1211683,168.370761 70.6456968,168.868083 70.6467457,169.564701 C70.6477291,170.255878 70.1108101,170.763558 69.3686295,170.763624 C62.3794393,170.764476 55.3901835,170.764122 48.4009278,170.763296 C47.7349909,170.763165 47.3150927,170.443832 47.1406432,169.796448 L47.1406432,169.796448 L40.9338207,146.657011 C40.7545854,145.989304 40.3456354,145.666169 39.6604246,145.66512 C37.7935331,145.662301 35.9266416,145.667022 34.0597501,145.661384 C33.4494063,145.659548 32.9561489,145.229161 32.8706614,144.650875 C32.7854362,144.074555 33.1185357,143.518362 33.6641083,143.332834 C33.8306253,143.276192 34.0040259,143.261769 34.1802455,143.261966 C36.0253062,143.263604 37.8704325,143.257639 39.7154276,143.264326 Z M62.3981692,157.843767 C62.9268934,157.842915 63.3436448,158.027919 63.5827343,158.505442 C63.8209061,158.981065 63.7370576,159.437216 63.4105794,159.851804 L63.4092682,159.853509 C63.3077191,159.915068 63.2048588,159.97525 63.1432344,160.083158 C62.8740537,160.211127 62.5902537,160.242005 62.2943255,160.237678 C61.6584141,160.2285 61.0223061,160.234793 60.3863292,160.234859 C60.3278516,160.236432 60.2693084,160.237809 60.2107652,160.239317 C60.0738148,160.242923 59.93693,160.246659 59.7999796,160.250331 L57.9576723,160.249544 L55.2789777,160.249741 C54.5510231,160.244496 53.8214295,160.268359 53.0956384,160.226468 C52.2262754,160.176447 51.3055151,160.477161 50.5063647,159.886288 C50.2350862,159.447247 50.1166887,158.985654 50.3662019,158.501509 C50.6111917,158.026214 51.024403,157.842652 51.5531272,157.843502 C55.1681193,157.849274 58.783177,157.849077 62.3981692,157.843767 Z M64.4227863,152.669094 C65.1310736,152.669291 65.6414416,153.0905 65.7035905,153.717364 C65.775573,154.444532 65.2790377,155.035864 64.5461662,155.049304 C63.5530956,155.067529 62.559435,155.05599 61.565971,155.056318 L57.2428227,155.056384 L57.2428227,155.056384 C54.8628753,155.056318 52.4829935,155.059596 50.1030461,155.054548 C49.2944553,155.052778 48.763371,154.484326 48.8392215,153.726346 C48.8971746,153.14806 49.3663067,152.700168 49.9468217,152.670143 L50.045011,152.668168 L50.045011,152.668168 L50.1432986,152.668701 C54.9031934,152.668635 59.6630227,152.668111 64.4227863,152.669094 Z"
                        id="shopping-cart"
                    />
                </g>
            </g>
        </svg>
    );
};

ShoppingCart.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

ShoppingCart.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default ShoppingCart;
