import React from 'react';
import PropTypes from 'prop-types';

const SettingsFilled = (props) => {
    const { className, style, title } = props;
    return (
        <svg
            width="18px"
            height="18px"
            viewBox="0 0 18 18"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            className={className}
            style={style}
        >
            <title>{title}</title>
            <g id="modules" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <path
                    d="M9.71888889,1.77635684e-15 C10.2788889,1.77635684e-15 10.7522222,0.42 10.82,0.977777778 L10.82,0.977777778 L10.9955556,2.36777778 C11.3488889,2.48222222 11.69,2.62333333 12.0133333,2.78888889 L12.0133333,2.78888889 L13.12,1.92888889 C13.57,1.58222222 14.2022222,1.62222222 14.5911111,2.02333333 L14.5911111,2.02333333 L15.7577778,3.19 C16.1555556,3.57555556 16.1955556,4.20777778 15.8477778,4.65666667 L15.8477778,4.65666667 L14.9877778,5.76333333 C15.1544444,6.08666667 15.2955556,6.42777778 15.41,6.78111111 L15.41,6.78111111 L16.8022222,6.95888889 C17.3577778,7.02555556 17.7777778,7.49888889 17.7788889,8.05888889 L17.7788889,8.05888889 L17.7788889,9.71777778 C17.7788889,10.2788889 17.3588889,10.7522222 16.8011111,10.8188889 L16.8011111,10.8188889 L15.4111111,10.9955556 C15.2955556,11.3488889 15.1544444,11.69 14.9888889,12.0133333 L14.9888889,12.0133333 L15.8488889,13.12 C16.1966667,13.5688889 16.1555556,14.2011111 15.7544444,14.5911111 L15.7544444,14.5911111 L14.5877778,15.7577778 C14.2022222,16.1555556 13.5688889,16.1955556 13.1211111,15.8477778 L13.1211111,15.8477778 L12.0144444,14.9877778 C11.6911111,15.1544444 11.35,15.2955556 10.9966667,15.41 L10.9966667,15.41 L10.8188889,16.8022222 C10.7522222,17.3577778 10.2788889,17.7777778 9.71777778,17.7777778 L9.71777778,17.7777778 L8.05888889,17.7777778 C7.49777778,17.7777778 7.02444444,17.3577778 6.95777778,16.8 L6.95777778,16.8 L6.78111111,15.41 C6.42777778,15.2944444 6.08666667,15.1533333 5.76333333,14.9877778 L5.76333333,14.9877778 L4.65666667,15.8477778 C4.20777778,16.1955556 3.57666667,16.1555556 3.18666667,15.7544444 L3.18666667,15.7544444 L2.02,14.5877778 C1.62222222,14.2022222 1.58222222,13.57 1.93,13.1211111 L1.93,13.1211111 L2.79,12.0144444 C2.62333333,11.6911111 2.48222222,11.35 2.36777778,10.9966667 L2.36777778,10.9966667 L0.975555556,10.8188889 C0.42,10.7522222 1.10134124e-13,10.2788889 1.10134124e-13,9.71777778 L1.10134124e-13,9.71777778 L1.10134124e-13,8.05888889 C1.10134124e-13,7.49888889 0.42,7.02555556 0.977777778,6.95777778 L0.977777778,6.95777778 L2.36666667,6.78111111 C2.48222222,6.42777778 2.62333333,6.08666667 2.78888889,5.76333333 L2.78888889,5.76333333 L1.92888889,4.65666667 C1.58111111,4.20777778 1.62222222,3.57555556 2.02333333,3.18555556 L2.02333333,3.18555556 L3.19,2.01888889 C3.57666667,1.62111111 4.20888889,1.58111111 4.65666667,1.92888889 L4.65666667,1.92888889 L5.76333333,2.78888889 C6.08666667,2.62333333 6.42777778,2.48333333 6.78111111,2.36777778 L6.78111111,2.36777778 L6.95888889,0.975555556 C7.02555556,0.42 7.49888889,1.77635684e-15 8.06,1.77635684e-15 L8.06,1.77635684e-15 Z M8.88888889,5.18555556 C6.84666667,5.18555556 5.18555556,6.84666667 5.18555556,8.88888889 C5.18555556,10.9311111 6.84666667,12.5922222 8.88888889,12.5922222 C10.9311111,12.5922222 12.5922222,10.9311111 12.5922222,8.88888889 C12.5922222,6.84666667 10.9311111,5.18555556 8.88888889,5.18555556 Z"
                    id="settings"
                    fill="currentColor"
                    fillRule="nonzero"
                />
            </g>
        </svg>
    );
};

SettingsFilled.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};
SettingsFilled.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default SettingsFilled;
