import React from 'react';
import PropTypes from 'prop-types';

const Settings = (props) => {
    const { className, style, title } = props;
    return (
        <svg width="18px" height="18px" viewBox="0 0 18 18" className={className} style={style}>
            <title>{title}</title>
            <g stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    transform="translate(-83.000000, -191.000000)"
                    fill="currentColor"
                    fillRule="nonzero"
                >
                    <g transform="translate(65.000000, 175.500000)">
                        <path d="M27.84,15.5 C28.40775,15.5 28.887,15.92525 28.9545,16.49 L29.13375,17.897 C29.49225,18.01325 29.83725,18.1565 30.165,18.32375 L31.2855,17.453 C31.74075,17.10125 32.37975,17.14175 32.77425,17.54825 L33.9555,18.7295 C34.35825,19.12025 34.39875,19.76 34.047,20.21375 L33.17625,21.335 C33.34425,21.66275 33.4875,22.00775 33.603,22.3655 L35.013,22.54475 C35.57475,22.613 36,23.09225 36,23.66 L36,25.34 C36,25.90775 35.57475,26.387 35.01,26.4545 L33.603,26.63375 C33.48675,26.9915 33.3435,27.3365 33.17625,27.66425 L34.047,28.78475 C34.3995,29.23925 34.35825,29.879 33.95175,30.2735 L32.7705,31.45475 C32.37975,31.8575 31.73925,31.89875 31.28625,31.54625 L30.165,30.6755 C29.83725,30.8435 29.49225,30.98675 29.1345,31.10225 L28.95525,32.51225 C28.887,33.07475 28.40775,33.5 27.84,33.5 L26.16,33.5 C25.59225,33.5 25.113,33.07475 25.0455,32.51 L24.86625,31.103 C24.5085,30.98675 24.1635,30.8435 23.83575,30.67625 L22.71525,31.547 C22.26075,31.89875 21.621,31.85825 21.2265,31.4525 L20.04525,30.27125 C19.6425,29.8805 19.602,29.24075 19.95375,28.787 L20.8245,27.66575 C20.6565,27.338 20.51325,26.993 20.39775,26.63525 L18.98775,26.456 C18.42525,26.387 18,25.90775 18,25.34 L18,23.66 C18,23.09225 18.42525,22.613 18.99,22.5455 L20.397,22.36625 C20.51325,22.0085 20.6565,21.6635 20.82375,21.33575 L19.95375,20.21525 C19.60125,19.76075 19.6425,19.12025 20.049,18.72575 L21.23025,17.5445 C21.621,17.14175 22.2615,17.102 22.7145,17.453 L23.835,18.3245 C24.16275,18.15725 24.50775,18.014 24.86625,17.89775 L25.0455,16.48775 C25.113,15.92525 25.59225,15.5 26.16,15.5 L27.84,15.5 Z M27.84,16.25 L26.16,16.25 C25.97475,16.25 25.812,16.39475 25.79025,16.57925 L25.5795,18.23225 C25.56075,18.38075 25.455,18.50375 25.311,18.54575 C24.84,18.68075 24.39225,18.86675 23.9805,19.097 C23.84925,19.17125 23.6865,19.15775 23.56725,19.06625 L22.25475,18.04625 C22.10325,17.9285 21.8925,17.939 21.76425,18.071 L20.5755,19.2605 C20.43975,19.3925 20.42925,19.604 20.54625,19.7555 L21.56625,21.068 C21.6585,21.1865 21.67125,21.34925 21.59775,21.4805 C21.366,21.89375 21.18075,22.3415 21.04575,22.811 C21.0045,22.955 20.8815,23.06075 20.733,23.0795 L19.083,23.2895 C18.89475,23.312 18.75,23.47475 18.75,23.66 L18.75,25.34 C18.75,25.52525 18.89475,25.688 19.07925,25.70975 L20.73225,25.9205 C20.88075,25.93925 21.00375,26.045 21.045,26.189 C21.18,26.6585 21.366,27.10625 21.597,27.5195 C21.6705,27.65075 21.6585,27.8135 21.5655,27.932 L20.5455,29.2445 C20.42775,29.396 20.43825,29.6075 20.57025,29.735 L21.759,30.92375 C21.89025,31.0595 22.101,31.07 22.254,30.953 L23.5665,29.933 C23.63475,29.882 23.71575,29.855 23.7975,29.855 C23.85975,29.855 23.9235,29.87075 23.9805,29.90225 C24.39375,30.13325 24.8415,30.31925 25.311,30.45425 C25.455,30.4955 25.56075,30.6185 25.5795,30.767 L25.7895,32.417 C25.812,32.60525 25.97475,32.75 26.16,32.75 L27.84,32.75 C28.02525,32.75 28.188,32.60525 28.20975,32.42075 L28.4205,30.76775 C28.43925,30.61925 28.545,30.49625 28.689,30.455 C29.1585,30.32 29.60625,30.134 30.0195,29.903 C30.15075,29.8295 30.31425,29.84225 30.432,29.9345 L31.7445,30.9545 C31.89525,31.0715 32.10675,31.06175 32.23575,30.929 L33.4245,29.74025 C33.56025,29.60825 33.57075,29.39675 33.45375,29.24525 L32.43375,27.93275 C32.3415,27.81425 32.32875,27.6515 32.40225,27.52025 C32.63325,27.107 32.81925,26.65925 32.95425,26.18975 C32.9955,26.04575 33.1185,25.94 33.267,25.92125 L34.917,25.71125 C35.10525,25.688 35.25,25.52525 35.25,25.34 L35.25,23.66 C35.25,23.47475 35.10525,23.312 34.92075,23.29025 L33.26775,23.0795 C33.11925,23.06075 32.99625,22.955 32.955,22.811 C32.82,22.3415 32.634,21.89375 32.403,21.4805 C32.3295,21.34925 32.3415,21.1865 32.4345,21.068 L33.4545,19.7555 C33.57225,19.604 33.56175,19.3925 33.42975,19.265 L32.241,18.07625 C32.10975,17.93975 31.8975,17.92925 31.746,18.047 L30.4335,19.067 C30.31425,19.15925 30.1515,19.172 30.02025,19.0985 C29.6085,18.8675 29.16075,18.68225 28.68975,18.5465 C28.54575,18.50525 28.44,18.38225 28.42125,18.23375 L28.21125,16.58375 C28.188,16.39475 28.02525,16.25 27.84,16.25 Z M27,20.75 C29.06775,20.75 30.75,22.43225 30.75,24.5 C30.75,26.56775 29.06775,28.25 27,28.25 C24.93225,28.25 23.25,26.56775 23.25,24.5 C23.25,22.43225 24.93225,20.75 27,20.75 Z M27,21.5 C25.3455,21.5 24,22.8455 24,24.5 C24,26.1545 25.3455,27.5 27,27.5 C28.6545,27.5 30,26.1545 30,24.5 C30,22.8455 28.6545,21.5 27,21.5 Z" />
                    </g>
                </g>
            </g>
        </svg>
    );
};

Settings.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};
Settings.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default Settings;
