import React from 'react';
import PropTypes from 'prop-types';

const RainbowModulesLogo = (props) => {
    const { className, style, title } = props;
    return (
        <svg className={className} style={style} width="67px" height="64px" viewBox="0 0 67 64">
            <title>{title}</title>
            <g id="modules" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="rainbow-modules-getting-started-overview"
                    transform="translate(-319.000000, -102.000000)"
                >
                    <g id="Group" transform="translate(319.000000, 102.000000)">
                        <polygon
                            id="Fill-1"
                            fill="#424A52"
                            points="2.94491446 11.0578501 1.0297675 14.1601728 1.0297675 51.9869148 33.3378455 63.4068771 65.6446701 52.0823322 65.6534436 13.9982142 64.3349 11.246174 33.4117942 0.824328449"
                        />
                        <path
                            d="M1.70082096,40.6393944 C1.90888012,40.6393944 2.11443254,40.6770591 2.30745128,40.7523887 L9.66472395,43.563437 C10.3239957,43.8157911 10.760168,44.4485595 10.760168,45.1566574 L10.760168,54.4598589 C10.760168,55.400223 9.99811995,56.1635626 9.059347,56.1635626 C8.8525412,56.1635626 8.64824215,56.1258978 8.45647678,56.0518237 L1.09795074,53.2596078 C0.437425581,53.0085092 8.6563582e-15,52.3744854 8.6563582e-15,51.665132 L8.6563582e-15,42.3430981 C8.6563582e-15,41.402734 0.760794636,40.6393944 1.70082096,40.6393944"
                            id="Fill-2"
                            fill="#FFCC00"
                        />
                        <path
                            d="M64.9297487,40.7301665 C65.869775,40.7301665 66.6305697,41.4922506 66.6305697,42.4338702 L66.6305697,51.7295387 C66.6305697,52.4376367 66.1943974,53.0716605 65.5326189,53.3227591 L58.1966535,56.1074421 C58.0048881,56.1815161 57.8005891,56.2179254 57.5937833,56.2179254 C56.653757,56.2179254 55.8929623,55.4558413 55.8929623,54.5142217 L55.8929623,45.2386411 C55.8929623,44.5305431 56.3291345,43.8965193 56.987153,43.6454207 L64.3243717,40.8419053 C64.5173905,40.7678313 64.7229429,40.7301665 64.9297487,40.7301665"
                            id="Fill-4"
                            fill="#37C0F7"
                        />
                        <path
                            d="M1.70082096,26.8044917 C1.91013348,26.8044917 2.11568591,26.8421564 2.30995801,26.917486 L9.66723068,29.7448558 C10.3252491,29.9972098 10.760168,30.6299782 10.760168,31.3355651 L10.760168,40.6237007 C10.760168,41.5653203 9.99811995,42.3274044 9.059347,42.3274044 C8.85128784,42.3274044 8.64573541,42.2897396 8.45271668,42.2156655 L1.09419064,39.4033617 C0.434918844,39.1522632 8.6563582e-15,38.5182393 8.6563582e-15,37.8126524 L8.6563582e-15,28.5081954 C8.6563582e-15,27.5665758 0.760794636,26.8044917 1.70082096,26.8044917"
                            id="Fill-6"
                            fill="#FFCC00"
                        />
                        <path
                            d="M64.9297487,26.9233868 C65.869775,26.9233868 66.6305697,27.6854709 66.6305697,28.6270905 L66.6305697,37.9039267 C66.6305697,38.6107691 66.1956508,39.2435375 65.536379,39.4958915 L58.2004136,42.2994069 C58.0073949,42.373481 57.8018425,42.4111458 57.5937833,42.4111458 C56.653757,42.4111458 55.8929623,41.6490617 55.8929623,40.7074421 L55.8929623,31.4456718 C55.8929623,30.7400849 56.3278812,30.1073165 56.9846462,29.853707 L64.3206116,27.0363812 C64.5148838,26.9610516 64.7216895,26.9233868 64.9297487,26.9233868"
                            id="Fill-8"
                            fill="#37C0F7"
                        />
                        <path
                            d="M24.7351006,21.3423448 C24.940653,21.3423448 25.1449521,21.3787541 25.3367174,21.4528281 L31.6198534,23.8370089 C32.2816319,24.0881075 32.7178041,24.7221313 32.7178041,25.4302293 L32.7178041,34.7660736 C32.7178041,35.7064377 31.9570095,36.4710328 31.0169831,36.4710328 C30.808924,36.4710328 30.6033716,36.433368 30.4090995,36.3580384 L24.1284703,33.9525143 C23.4679451,33.7014157 23.0342796,33.0673919 23.0342796,32.3605494 L23.0342796,23.0460485 C23.0342796,22.1044289 23.7950743,21.3423448 24.7351006,21.3423448"
                            id="Fill-10"
                            fill="#FFCC00"
                        />
                        <path
                            d="M41.9432224,21.4722883 C42.8832487,21.4722883 43.6440434,22.2343724 43.6440434,23.175992 L43.6440434,32.4641276 C43.6440434,33.1697145 43.2091245,33.8037384 42.5498527,34.0548369 L36.2880241,36.4540836 C36.0950053,36.5269022 35.8894529,36.564567 35.6813937,36.564567 C34.7413674,36.564567 33.9793194,35.8024829 33.9793194,34.8608633 L33.9793194,25.5526398 C33.9793194,24.8445419 34.416745,24.210518 35.0785235,23.958164 L41.3403522,21.5827716 C41.5333709,21.5086976 41.73767,21.4722883 41.9432224,21.4722883"
                            id="Fill-12"
                            fill="#37C0F7"
                        />
                        <path
                            d="M13.2185248,17.2509449 C13.4240772,17.2509449 13.6296296,17.2873542 13.821395,17.3614283 L21.179921,20.1599217 C21.8404462,20.4122757 22.2778718,21.0450441 22.2778718,21.7543975 L22.2778718,31.0563435 C22.2778718,31.9979631 21.5158238,32.7613027 20.5757975,32.7613027 C20.3677383,32.7613027 20.1609325,32.7223824 19.9679138,32.6483084 L12.6093877,29.8259606 C11.9513693,29.572351 11.5164505,28.9408382 11.5164505,28.2339957 L11.5164505,18.9546486 C11.5164505,18.013029 12.2784985,17.2509449 13.2185248,17.2509449"
                            id="Fill-14"
                            fill="#FFCC00"
                        />
                        <path
                            d="M53.4364856,17.3882958 C54.3765119,17.3882958 55.1373065,18.1503799 55.1373065,19.0919995 L55.1373065,28.3462368 C55.1373065,29.0505682 54.703641,29.6845921 54.0443692,29.9369462 L46.7096572,32.7505055 C46.5153851,32.825835 46.3085793,32.8634998 46.1005201,32.8634998 C45.1604938,32.8634998 44.3996992,32.1014157 44.3996992,31.1597961 L44.3996992,21.88296 C44.3996992,21.1761175 44.8371248,20.5420937 45.4963966,20.2909951 L52.832362,17.5000347 C53.0253807,17.4259606 53.2296798,17.3882958 53.4364856,17.3882958"
                            id="Fill-16"
                            fill="#37C0F7"
                        />
                        <path
                            d="M1.70082096,13.0081326 C1.90762675,13.0081326 2.1119258,13.0457974 2.30369117,13.118616 L9.66221721,15.9133429 C10.3227424,16.1644414 10.760168,16.7984653 10.760168,17.5065632 L10.760168,26.9265256 C10.760168,27.8681451 9.99811995,28.6314848 9.059347,28.6314848 C8.85128784,28.6314848 8.64448205,28.59382 8.44895657,28.5184904 L1.0916839,25.6911207 C0.433665476,25.4387666 8.6563582e-15,24.8059983 8.6563582e-15,24.0991558 L8.6563582e-15,14.7118363 C8.6563582e-15,13.7702167 0.760794636,13.0081326 1.70082096,13.0081326"
                            id="Fill-18"
                            fill="#FFCC00"
                        />
                        <polygon
                            id="Clip-21"
                            points="55.892461 13.1036756 66.6311963 13.1036756 66.6311963 28.7433492 55.892461 28.7433492"
                        />
                        <path
                            d="M64.3263771,13.214159 C64.5193959,13.1413404 64.7236949,13.1036756 64.9292474,13.1036756 C65.8692737,13.1036756 66.6313217,13.8670152 66.6313217,14.8086348 L66.6313217,15.0120246 L66.6313217,24.2198087 C66.6313217,24.9266511 66.1964028,25.5594195 65.5396378,25.8117735 L58.2036724,28.6303548 C58.0094003,28.7044289 57.8025945,28.7433492 57.5945353,28.7433492 C56.654509,28.7433492 55.892461,27.9800096 55.892461,27.03839 L55.892461,17.5945733 C55.892461,16.8852198 56.3298866,16.251196 56.9904117,16.0000974 L64.3263771,13.214159 Z"
                            id="Fill-20"
                            fill="#37C0F7"
                        />
                        <path
                            d="M33.8672683,16.1089487 L41.7522091,19.0731671 C42.0805916,19.1886725 42.248543,19.533933 42.129473,19.8478062 C42.0655512,20.0147867 41.928934,20.145358 41.7547158,20.2081326 L34.1054083,22.9513843 C33.5326189,23.1535187 32.9021746,23.1497522 32.3306386,22.9413404 L24.4682584,20.0775613 C24.1411293,19.9582895 23.976938,19.6092625 24.1022749,19.2979003 C24.16745,19.1346863 24.3040672,19.0053705 24.477032,18.9451069 L32.1338597,16.1089487 C32.6928621,15.9143473 33.308266,15.9143473 33.8672683,16.1089487"
                            id="Fill-23"
                            fill="#F8752D"
                        />
                        <path
                            d="M23.6481795,12.46011 L30.5316789,14.9635626 C30.8650749,15.0790679 31.0380397,15.4318614 30.916463,15.7507566 C30.8500345,15.9215036 30.7096572,16.0558413 30.5304255,16.118616 L22.6454847,18.9133429 C22.0814689,19.1091998 21.4623049,19.1091998 20.8970358,18.9145984 L14.0160431,16.4048683 C13.6826471,16.289363 13.5096823,15.937825 13.6300056,15.6189298 C13.6951808,15.4469273 13.8355581,15.3113341 14.0147897,15.249815 L21.8947171,12.46011 C22.4612396,12.2629976 23.081657,12.2629976 23.6481795,12.46011"
                            id="Fill-25"
                            fill="#F8752D"
                        />
                        <path
                            d="M45.2773078,12.0702795 L53.4191891,14.8361301 C53.7563452,14.9554019 53.92931,15.3182393 53.8077333,15.6471784 C53.7413048,15.8229474 53.5996741,15.9623071 53.4179357,16.0250817 L45.3136554,18.9441025 C44.7408661,19.1462368 44.1129285,19.1449813 43.5401391,18.9415915 L35.4734599,16.0702795 C35.1363038,15.9497522 34.963339,15.5869148 35.0861691,15.2579757 C35.1525976,15.0834622 35.2929749,14.945358 35.4734599,14.8813278 L43.5000313,12.071535 C44.0740741,11.8668897 44.703265,11.8656342 45.2773078,12.0702795"
                            id="Fill-27"
                            fill="#F8752D"
                        />
                        <path
                            d="M11.6946795,7.67291602 L20.4970859,11.05898 C20.8568027,11.1820183 21.0423012,11.5586662 20.9132042,11.8989047 C20.8430156,12.0834622 20.6901047,12.2278438 20.4958325,12.2943849 L12.4492072,15.0891119 C11.846337,15.2950127 11.1870652,15.2950127 10.584195,15.0903674 L2.50372877,12.1939455 C1.92968603,11.9980887 1.63138435,11.3967076 1.83693677,10.8505682 C1.94848656,10.554272 2.1928934,10.3220058 2.50372877,10.2165444 L9.82590713,7.67040503 C10.4300307,7.46450422 11.0905559,7.46575971 11.6946795,7.67291602"
                            id="Fill-29"
                            fill="#F8752D"
                        />
                        <path
                            d="M57.3594034,7.71409618 L64.5136304,10.1836505 C65.0626058,10.3707189 65.345867,10.9394571 65.1465814,11.4554647 C65.0400451,11.7316731 64.808172,11.9488733 64.5148838,12.0493128 L56.929498,14.7774986 C56.344175,14.9783774 55.7037037,14.9771219 55.119634,14.7762431 L46.8298552,11.9576618 C46.4864323,11.840901 46.3109607,11.484341 46.4350442,11.1629349 C46.5014727,10.9921878 46.6431033,10.8578501 46.8248418,10.7950755 L55.5282321,7.72288463 C56.1185687,7.51447283 56.7665601,7.51196185 57.3594034,7.71409618"
                            id="Fill-31"
                            fill="#F8752D"
                        />
                        <path
                            d="M34.1451401,8.14749229 L41.5274801,10.8392688 C41.8558626,10.9585406 42.0250674,11.3226335 41.904744,11.6515726 C41.8420756,11.8260861 41.7029517,11.9641903 41.5287335,12.0282205 L33.8806793,14.799093 C33.3191703,15.0037384 32.702513,15.0037384 32.1384972,14.799093 L24.7498903,12.0997836 C24.4215078,11.9805118 24.2523031,11.6164188 24.3726264,11.2874797 C24.4365482,11.1129662 24.5744188,10.974862 24.7511437,10.9108319 L32.4079714,8.14749229 C32.9694805,7.94284697 33.5848844,7.94284697 34.1451401,8.14749229"
                            id="Fill-33"
                            fill="#F8752D"
                        />
                        <path
                            d="M22.7325938,3.89237616 L30.8757285,6.92188024 C31.2053644,7.04115205 31.3758225,7.40398947 31.2554992,7.73292857 C31.1915774,7.90869756 31.0524535,8.04680177 30.8769819,8.1108319 L23.4770947,10.8051194 C22.9155856,11.0085092 22.2989284,11.0085092 21.7386727,10.8038639 L13.3774519,7.65508802 C13.0490694,7.53456072 12.881118,7.17046781 13.000188,6.84278419 C13.0641098,6.6670152 13.2032337,6.528911 13.3799586,6.46488087 L21.0029454,3.89112067 C21.5619477,3.68898633 22.1748449,3.68898633 22.7325938,3.89237616"
                            id="Fill-35"
                            fill="#F8752D"
                        />
                        <path
                            d="M46.0276994,3.919997 L53.2496083,6.33305412 C53.5792442,6.44855946 53.7509557,6.80386392 53.6331391,7.12652556 C53.5704706,7.29852807 53.4313467,7.43663228 53.2558752,7.49940692 L44.8908943,10.5151006 C44.331892,10.7159794 43.7177414,10.7184904 43.1574857,10.521378 L36.0947547,8.03675783 C35.7651188,7.92125249 35.5946607,7.56594803 35.7137307,7.24328639 C35.7763991,7.07002839 35.915523,6.93443517 36.0909945,6.87166053 L44.3030645,3.92752996 C44.8583067,3.7279066 45.4699505,3.72539562 46.0276994,3.919997"
                            id="Fill-37"
                            fill="#F8752D"
                        />
                        <polygon
                            id="Clip-40"
                            points="24.2542176 0.000599635638 42.6720669 0.000599635638 42.6720669 6.90216884 24.2542176 6.90216884"
                        />
                        <path
                            d="M34.9407783,0.234372391 L42.1539136,2.59595431 C42.5512314,2.72401458 42.7655574,3.13832719 42.6327004,3.519997 C42.560005,3.72715331 42.393307,3.89287836 42.1802344,3.97071891 L34.9407783,6.60850924 C33.8566147,7.00398947 32.6583944,7.00022299 31.5767375,6.59595431 L24.7383593,4.00838369 C24.3473084,3.86274653 24.1542897,3.43964546 24.3059472,3.06299763 C24.3861628,2.86462977 24.5541142,2.70894866 24.7646801,2.63864107 L31.9063734,0.250693798 C32.8877609,-0.078245311 33.9556308,-0.0832672821 34.9407783,0.234372391"
                            id="Fill-39"
                            fill="#F8752D"
                        />
                        <path
                            d="M24.7351006,48.8823322 C24.9431597,48.8823322 25.1487122,48.919997 25.3417309,48.9953266 L31.6236135,51.3995952 C32.2828853,51.6519493 32.7178041,52.2847177 32.7178041,52.9915601 L32.7178041,62.2307315 C32.7178041,63.172351 31.9570095,63.9344352 31.0169831,63.9344352 C30.8114307,63.9344352 30.6071317,63.8980259 30.4141129,63.8239518 L24.1322304,61.4410265 C23.4704518,61.1899279 23.0342796,60.5546486 23.0342796,59.8465507 L23.0342796,50.5860359 C23.0342796,49.6444163 23.7950743,48.8823322 24.7351006,48.8823322"
                            id="Fill-42"
                            fill="#FFCC00"
                        />
                        <path
                            d="M41.9432224,48.9559041 C42.8832487,48.9559041 43.6440434,49.7179882 43.6440434,50.6596078 L43.6440434,59.8937572 C43.6440434,60.6018551 43.2078712,61.235879 42.5448393,61.4869775 L36.284264,63.8636254 C36.0912452,63.9376994 35.8869462,63.9741087 35.6813937,63.9741087 C34.7413674,63.9741087 33.9793194,63.2107691 33.9793194,62.2691495 L33.9793194,53.057599 C33.9793194,52.3507566 34.4154916,51.7167327 35.0747634,51.4656342 L41.3365921,49.067643 C41.5296108,48.9935689 41.7351633,48.9559041 41.9432224,48.9559041"
                            id="Fill-44"
                            fill="#37C0F7"
                        />
                        <path
                            d="M13.2185248,44.7554019 C13.4265839,44.7554019 13.6321364,44.7943222 13.8264085,44.8683962 L21.1836811,47.6919995 C21.8429529,47.9443536 22.2778718,48.5771219 22.2778718,49.2827089 L22.2778718,58.5520121 C22.2778718,59.4936317 21.5158238,60.2569713 20.5757975,60.2569713 C20.3689917,60.2569713 20.1646926,60.2193065 19.9716739,60.1464879 L12.6144012,57.344228 C11.953876,57.0931295 11.5164505,56.4591056 11.5164505,55.7522632 L11.5164505,46.4591056 C11.5164505,45.5187415 12.2784985,44.7554019 13.2185248,44.7554019"
                            id="Fill-46"
                            fill="#FFCC00"
                        />
                        <path
                            d="M53.4364856,44.7724766 C54.4116062,44.7724766 55.2024817,45.5646925 55.2024817,46.5414659 L55.2024817,55.8070026 C55.2024817,56.5414659 54.7500157,57.1993441 54.0644231,57.4604866 L46.7284577,60.2539581 C46.5279188,60.3305431 46.3148461,60.3694634 46.1005201,60.3694634 C45.1253995,60.3694634 44.3332707,59.5772475 44.3332707,58.5992186 L44.3332707,49.3550252 C44.3332707,48.6218175 44.7857367,47.9651947 45.4700758,47.7027967 L52.8047879,44.8892374 C53.0065802,44.8113969 53.2209062,44.7724766 53.4364856,44.7724766"
                            id="Fill-48"
                            fill="#37C0F7"
                        />
                        <path
                            d="M24.7351006,35.0632487 C24.9431597,35.0632487 25.1487122,35.1009135 25.3417309,35.1762431 L31.6236135,37.5817672 C32.2828853,37.8328658 32.7178041,38.4668897 32.7178041,39.1724766 L32.7178041,48.4581012 C32.7178041,49.3997208 31.9570095,50.1618049 31.0169831,50.1618049 C30.808924,50.1618049 30.6033716,50.1241401 30.4090995,50.0513215 L24.1284703,47.6445419 C23.4679451,47.3921878 23.0342796,46.7594195 23.0342796,46.0538325 L23.0342796,36.7669524 C23.0342796,35.8265883 23.7950743,35.0632487 24.7351006,35.0632487"
                            id="Fill-50"
                            fill="#FFCC00"
                        />
                        <path
                            d="M41.9432224,35.1650692 C42.8832487,35.1650692 43.6440434,35.9271533 43.6440434,36.8687729 L43.6440434,46.1280322 C43.6440434,46.8348746 43.2091245,47.4688984 42.5498527,47.719997 L36.2880241,50.1179882 C36.0950053,50.1920623 35.8894529,50.2297271 35.6813937,50.2297271 C34.7413674,50.2297271 33.9793194,49.467643 33.9793194,48.5260234 L33.9793194,39.2667641 C33.9793194,38.5599217 34.4154916,37.9271533 35.0747634,37.6747993 L41.3365921,35.2780635 C41.5296108,35.202734 41.7351633,35.1650692 41.9432224,35.1650692"
                            id="Fill-52"
                            fill="#37C0F7"
                        />
                        <path
                            d="M13.2185248,30.9375739 C13.4265839,30.9375739 13.6321364,30.9752387 13.8264085,31.0505682 L21.1836811,33.872916 C21.8429529,34.1252701 22.2778718,34.7580384 22.2778718,35.4636254 L22.2778718,44.74925 C22.2778718,45.6896141 21.5158238,46.4529537 20.5757975,46.4529537 C20.3677383,46.4529537 20.1609325,46.4140334 19.9679138,46.3412148 L12.6093877,43.5176116 C11.9513693,43.264002 11.5164505,42.6312337 11.5164505,41.9256467 L11.5164505,32.6412776 C11.5164505,31.699658 12.2784985,30.9375739 13.2185248,30.9375739"
                            id="Fill-54"
                            fill="#FFCC00"
                        />
                        <path
                            d="M53.4364856,31.0466762 C54.3765119,31.0466762 55.1373065,31.8100158 55.1373065,32.7503799 L55.1373065,42.0083837 C55.1373065,42.7152261 54.703641,43.3479945 54.0443692,43.6003485 L46.7096572,46.4151634 C46.5153851,46.4904929 46.3085793,46.5281577 46.1005201,46.5281577 C45.1604938,46.5281577 44.3996992,45.7648181 44.3996992,44.824454 L44.3996992,35.5664502 C44.3996992,34.8596078 44.834618,34.2268394 45.4926365,33.9744854 L52.8286019,31.1596706 C53.022874,31.0855965 53.2284264,31.0466762 53.4364856,31.0466762"
                            id="Fill-56"
                            fill="#37C0F7"
                        />
                    </g>
                </g>
            </g>
        </svg>
    );
};

RainbowModulesLogo.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

RainbowModulesLogo.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default RainbowModulesLogo;
