import React from 'react';
import { IconProps } from '../../types';

const NodeFile: React.FC<IconProps> = (props: IconProps) => {
    const { className, style, title } = props;
    return (
        <svg
            className={className}
            style={style}
            fill="currentColor"
            width="18px"
            height="20px"
            viewBox="0 0 18 20"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
        >
            <title>{title}</title>
            <g id="marketplace" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="marketplace/functions-source-code/download"
                    transform="translate(-184.000000, -681.000000)"
                    fill="#539E43"
                    fillRule="nonzero"
                >
                    <path
                        d="M192.858131,700.962891 C192.583034,700.962891 192.326277,700.889531 192.087859,700.761153 L189.648664,699.312307 C189.281867,699.110569 189.465265,699.03721 189.575304,699.00053 C190.070479,698.835472 190.162178,698.798792 190.675693,698.505355 C190.730713,698.468676 190.804072,698.487015 190.859091,698.523695 L192.729753,699.642424 C192.803112,699.679103 192.894811,699.679103 192.949831,699.642424 L200.267417,695.405926 C200.340777,695.369246 200.377456,695.295887 200.377456,695.204188 L200.377456,686.749533 C200.377456,686.657833 200.340777,686.584474 200.267417,686.547795 L192.949831,682.329637 C192.876471,682.292957 192.784772,682.292957 192.729753,682.329637 L185.412166,686.547795 C185.338807,686.584474 185.302127,686.676173 185.302127,686.749533 L185.302127,695.204188 C185.302127,695.277547 185.338807,695.369246 185.412166,695.405926 L187.411206,696.561335 C188.493255,697.111529 189.171828,696.469636 189.171828,695.827742 L189.171828,687.483125 C189.171828,687.373086 189.263527,687.263047 189.391906,687.263047 L190.327237,687.263047 C190.437276,687.263047 190.547315,687.354747 190.547315,687.483125 L190.547315,695.827742 C190.547315,697.276587 189.758703,698.120219 188.383216,698.120219 C187.9614,698.120219 187.631284,698.120219 186.695953,697.661724 L184.770272,696.561335 C184.293437,696.286237 184,695.772722 184,695.222528 L184,686.767872 C184,686.217678 184.293437,685.704163 184.770272,685.429066 L192.087859,681.192568 C192.546355,680.935811 193.169908,680.935811 193.628404,681.192568 L200.945991,685.429066 C201.422826,685.704163 201.716263,686.217678 201.716263,686.767872 L201.716263,695.222528 C201.716263,695.772722 201.422826,696.286237 200.945991,696.561335 L193.628404,700.797832 C193.389986,700.907871 193.114889,700.962891 192.858131,700.962891 L192.858131,700.962891 Z M195.113929,695.149169 C191.904461,695.149169 191.244228,693.681983 191.244228,692.434876 C191.244228,692.324837 191.335927,692.214798 191.464305,692.214798 L192.417976,692.214798 C192.528015,692.214798 192.619714,692.288157 192.619714,692.398196 C192.766432,693.370207 193.188248,693.847042 195.132269,693.847042 C196.672813,693.847042 197.333047,693.498585 197.333047,692.673293 C197.333047,692.196458 197.149649,691.848002 194.747133,691.609584 C192.748093,691.407846 191.500985,690.96769 191.500985,689.372126 C191.500985,687.886601 192.748093,687.00629 194.838832,687.00629 C197.186328,687.00629 198.341737,687.813242 198.488455,689.573864 C198.488455,689.628884 198.470115,689.683903 198.433436,689.738923 C198.396756,689.775602 198.341737,689.812282 198.286717,689.812282 L197.333047,689.812282 C197.241348,689.812282 197.149649,689.738923 197.131309,689.647224 C196.911231,688.638534 196.342697,688.308417 194.838832,688.308417 C193.151569,688.308417 192.949831,688.895291 192.949831,689.335447 C192.949831,689.867301 193.188248,690.03236 195.462386,690.325797 C197.718183,690.619234 198.781892,691.04105 198.781892,692.618274 C198.763552,694.232178 197.443086,695.149169 195.113929,695.149169 L195.113929,695.149169 Z"
                        id="node"
                    />
                </g>
            </g>
        </svg>
    );
};

NodeFile.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default NodeFile;
