import React from 'react';
import PropTypes from 'prop-types';

const MoneyBorder = (props) => {
    const { className, style, title } = props;

    return (
        <svg className={className} style={style} idth="32px" height="32px" viewBox="0 0 32 32">
            <title>{title}</title>
            <g id="modules" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <path
                    d="M16,0 C20.27375,0 24.29175,1.66425 27.31375,4.68625 C30.3356875,7.70825 32,11.72625 32,16 C32,20.27375 30.3356875,24.29175 27.31375,27.31375 C24.29175,30.33575 20.27375,32 16,32 C11.72625,32 7.70825,30.33575 4.68625,27.31375 C1.6643125,24.29175 0,20.27375 0,16 C0,11.72625 1.6643125,7.70825 4.68625,4.68625 C7.70825,1.66425 11.72625,0 16,0 Z M16,1.875 C8.2114375,1.875 1.875,8.2114375 1.875,16 C1.875,23.7885625 8.2114375,30.125 16,30.125 C23.7885625,30.125 30.125,23.7885625 30.125,16 C30.125,8.2114375 23.7885625,1.875 16,1.875 Z M16,6.0250625 C16.51775,6.0250625 16.9375,6.4448125 16.9375,6.9625625 L16.9375,6.9625625 L16.9375,9.0375625 L19.0125,9.0375625 C19.53025,9.0375625 19.95,9.4573125 19.95,9.9750625 C19.95,10.4928125 19.53025,10.9125625 19.0125,10.9125625 L19.0125,10.9125625 L14.9958125,10.9125625 C13.8516875,10.9125625 12.9208125,11.843375 12.9208125,12.9875625 C12.9208125,14.1316875 13.851625,15.0625 14.9958125,15.0625 L14.9958125,15.0625 L17.0041875,15.0625 C19.1821875,15.0625 20.954125,16.8345 20.954125,19.0125 C20.954125,21.1905 19.1821875,22.9625 17.0041875,22.9625 L17.0041875,22.9625 L16.9375,22.9625 L16.9375,25.0375625 C16.9375,25.5553125 16.51775,25.9750625 16,25.9750625 C15.48225,25.9750625 15.0625,25.5553125 15.0625,25.0375625 L15.0625,25.0375625 L15.0625,22.9625 L12.9875625,22.9625 C12.4698125,22.9625 12.0500625,22.54275 12.0500625,22.025 C12.0500625,21.50725 12.4698125,21.0875 12.9875625,21.0875 L12.9875625,21.0875 L17.00425,21.0875 C18.148375,21.0875 19.0791875,20.156625 19.0791875,19.0125 C19.0791875,17.868375 18.148375,16.9375 17.00425,16.9375 L17.00425,16.9375 L14.995875,16.9375 C12.817875,16.9375 11.045875,15.1655625 11.045875,12.9875625 C11.045875,10.8095625 12.8178125,9.0375625 14.995875,9.0375625 L14.995875,9.0375625 L15.0625,9.0375625 L15.0625,6.9625625 C15.0625,6.4448125 15.48225,6.0250625 16,6.0250625 Z"
                    id="money-border"
                    fill="currentColor"
                    fillRule="nonzero"
                />
            </g>
        </svg>
    );
};

MoneyBorder.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

MoneyBorder.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default MoneyBorder;
