import React from 'react';
import PropTypes from 'prop-types';

const Memory = (props) => {
    const { className, style, title } = props;
    return (
        <svg
            className={className}
            style={style}
            width="13px"
            height="15px"
            viewBox="0 0 13 15"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
        >
            <title>{title}</title>
            <g id="install-functions" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="install-function/runtime-section-memory-dropdown-open"
                    transform="translate(-643.000000, -1401.000000)"
                    fill="currentColor"
                    fillRule="nonzero"
                >
                    <g id="Group-55" transform="translate(631.000000, 1317.000000)">
                        <path
                            d="M23.9249725,86.0875168 L22.0624466,84.4312134 C21.7437287,84.1562118 21.3374634,84 20.9187241,84 L13.7187882,84 C12.7686996,84 12,84.7686996 12,85.7187882 L12,97.2812118 C12,98.2313004 12.7686996,99 13.7187882,99 L22.78125,99 C23.7312241,99 24.5000382,98.2313004 24.5000382,97.2812118 L24.5000382,87.3749771 C24.5000382,86.881279 24.2875213,86.412529 23.9249725,86.0875168 L23.9249725,86.0875168 Z M20.1249618,86.4999618 C20.1249618,86.1550369 20.4049988,85.875 20.7500382,85.875 C21.0949631,85.875 21.375,86.1550369 21.375,86.4999618 L21.375,87.4374618 C21.375,87.7825012 21.0949631,88.0625382 20.7500382,88.0625382 C20.4049988,88.0625382 20.1249618,87.7825012 20.1249618,87.4374618 L20.1249618,86.4999618 Z M18.0419083,86.4999618 C18.0419083,86.1550369 18.3218307,85.875 18.6668701,85.875 C19.0119095,85.875 19.291832,86.1550369 19.291832,86.4999618 L19.291832,87.4374618 C19.291832,87.7825012 19.0119095,88.0625382 18.6668701,88.0625382 C18.3218307,88.0625382 18.0419083,87.7825012 18.0419083,87.4374618 L18.0419083,86.4999618 Z M15.958168,86.4999618 C15.958168,86.1550369 16.2380905,85.875 16.5831299,85.875 C16.9281693,85.875 17.2080917,86.1550369 17.2080917,86.4999618 L17.2080917,87.4374618 C17.2080917,87.7825012 16.9281693,88.0625382 16.5831299,88.0625382 C16.2380905,88.0625382 15.958168,87.7825012 15.958168,87.4374618 L15.958168,86.4999618 Z M13.875,86.4999618 C13.875,86.1550369 14.1550369,85.875 14.4999618,85.875 C14.8450012,85.875 15.1250382,86.1550369 15.1250382,86.4999618 L15.1250382,87.4374618 C15.1250382,87.7825012 14.8450012,88.0625382 14.4999618,88.0625382 C14.1550369,88.0625382 13.875,87.7825012 13.875,87.4374618 L13.875,86.4999618 Z M22.6250382,96.65625 C22.6250382,96.9124832 22.4125213,97.125 22.1562882,97.125 L14.34375,97.125 C14.0875168,97.125 13.875,96.9124832 13.875,96.65625 L13.875,91.96875 C13.875,91.7125168 14.0875168,91.5 14.34375,91.5 L22.1562882,91.5 C22.4125213,91.5 22.6250382,91.7125168 22.6250382,91.96875 L22.6250382,96.65625 Z"
                            id="memory"
                        />
                    </g>
                </g>
            </g>
        </svg>
    );
};

Memory.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};
Memory.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default Memory;
