import React from 'react';
import PropTypes from 'prop-types';

export default function MediumIcon(props) {
    const { className, style, title } = props;

    return (
        <svg className={className} style={style} width="441px" height="250px" viewBox="0 0 441 250">
            <title>{title}</title>
            <g id="demo" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <path
                    d="M248.7786,124.858 C248.7856,192.119 192.8746,250.535 124.6156,249.22 C55.5366,250.284 0.2696,193.3 -0.000399249267,125.401 C-0.2714,56.391 55.0206,0.571 123.8536,0.004 C192.2786,-0.56 248.7706,56.623 248.7786,124.858 Z M350.7643,19.8363 C364.3313,32.8333 371.4873,49.5403 376.9023,67.2203 C383.0113,87.1683 385.1363,107.5743 384.9693,128.2993 C384.7723,152.6593 380.4753,176.3123 371.1483,198.8213 C365.6543,212.0813 358.2953,224.5483 346.6273,233.3543 C334.6913,242.3623 321.4263,245.9913 305.6613,237.5743 C291.8903,230.2233 283.6133,218.0323 277.2383,204.5933 C265.2903,179.4023 260.2443,152.6093 260.7703,122.6873 C259.8723,99.6033 264.7373,75.3903 273.8413,52.1163 C279.2653,38.2483 286.9533,25.3943 298.9873,16.1273 C314.9843,3.8103 333.7723,3.5593 350.7643,19.8363 Z M418.9434,19.9836 C438.6974,19.9836 440.6194,122.378802 440.6194,124.8186 C440.5844,151.5116 438.6974,178.0626 433.3654,204.2416 C432.0574,210.6606 429.3954,216.9406 426.4484,222.8306 C424.9754,225.7726 422.171694,229.5516 418.9714,229.5516 C414.576951,229.5516 412.0354,225.3636 410.6254,222.1346 C407.5264,215.0346 405.1744,207.4846 403.5254,199.8986 C399.5934,181.8156 397.9594,163.4446 397.3294,144.9316 C396.3144,115.0626 397.0104,85.2866 402.1114,55.8146 C403.7954,46.0816 409.746021,19.9836 418.9434,19.9836 Z"
                    id="medium"
                    fill="#000000"
                />
            </g>
        </svg>
    );
}

MediumIcon.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

MediumIcon.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};
