import React from 'react';
import PropTypes from 'prop-types';

const Link = (props) => {
    const { className, style, title } = props;
    return (
        <svg
            className={className}
            style={style}
            width="20px"
            height="20px"
            viewBox="0 0 20 20"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
        >
            <title>{title}</title>
            <g id="install-functions" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="install-function/different-types-url"
                    transform="translate(-642.000000, -1172.000000)"
                    fill="currentColor"
                >
                    <path
                        d="M657.963126,1179.77666 C658.760497,1180.57428 659.559503,1181.37027 660.351439,1182.17321 C660.963837,1182.79417 661.403623,1183.52373 661.680213,1184.35147 C661.95762,1185.18149 662.043517,1186.03034 661.936163,1186.89901 C661.778721,1188.17307 661.245151,1189.26519 660.361066,1190.19346 C659.748242,1190.83694 659.033854,1191.31922 658.199467,1191.62824 C657.659254,1191.82831 656.886181,1191.97261 656.124512,1191.97403 C654.871403,1191.95162 653.647425,1191.54053 652.588917,1190.67041 C652.436057,1190.54476 652.291474,1190.40803 652.151155,1190.26828 C651.381314,1189.50178 650.612611,1188.73414 649.84643,1187.96394 C649.537336,1187.65321 649.427567,1187.28171 649.588028,1186.86625 C649.807318,1186.2984 650.518366,1185.99488 651.080675,1186.35485 C651.139893,1186.39275 651.195275,1186.43908 651.245222,1186.48881 C652.048632,1187.28877 652.844192,1188.09677 653.655631,1188.88845 C654.244476,1189.46298 654.961528,1189.787 655.77968,1189.87904 C656.811758,1189.9951 657.743481,1189.7362 658.553677,1189.0881 C659.275631,1188.51066 659.713002,1187.75272 659.868739,1186.84117 C660.032078,1185.88522 659.853428,1184.99012 659.329805,1184.17385 C659.18405,1183.94664 659.004796,1183.73577 658.815062,1183.54281 C658.065897,1182.78085 657.307353,1182.0281 656.550373,1181.27382 C656.294174,1181.01851 656.181776,1180.71734 656.228917,1180.35641 C656.284263,1179.93275 656.682345,1179.54085 657.10746,1179.48433 C657.443979,1179.43957 657.726856,1179.54032 657.963126,1179.77666 Z M650.791446,1179.30533 C650.825442,1179.33368 650.856526,1179.36568 650.887893,1179.39705 C652.12395,1180.63456 653.359012,1181.87307 654.596668,1183.10895 C654.79681,1183.30877 654.936561,1183.53581 654.950984,1183.82213 C654.981002,1184.41737 654.513968,1184.89158 653.823986,1184.88924 C653.605549,1184.88661 653.351588,1184.77751 653.137947,1184.56167 C651.895034,1183.3059 650.64967,1182.05265 649.406011,1180.79762 C649.204874,1180.59464 649.101783,1180.34679 649.109243,1180.06117 C649.12086,1179.61915 649.361108,1179.32071 649.747218,1179.1475 C650.11919,1178.9806 650.475389,1179.04195 650.791446,1179.30533 Z M650.822842,1172.85465 C651.223055,1173.09582 651.579467,1173.39291 651.909378,1173.72239 C652.661314,1174.47337 653.411758,1175.22587 654.164298,1175.97625 C654.426004,1176.23724 654.558046,1176.54371 654.496732,1176.91525 C654.429094,1177.32495 654.088988,1177.66452 653.672504,1177.74516 C653.331261,1177.81124 653.034174,1177.72335 652.786821,1177.47696 C651.985648,1176.67891 651.190586,1175.87461 650.382025,1175.0842 C649.751119,1174.46747 648.983694,1174.13397 648.104227,1174.0674 C647.117584,1173.99276 646.226501,1174.25024 645.454991,1174.87518 C644.695062,1175.49074 644.246146,1176.28942 644.115311,1177.26015 C643.993286,1178.16555 644.170337,1179.01163 644.66778,1179.77909 C644.821101,1180.01561 645.005719,1180.2371 645.20341,1180.43859 C645.943588,1181.19283 646.693961,1181.9371 647.44302,1182.68257 C647.711829,1182.9501 647.842806,1183.2669 647.762842,1183.64037 C647.683872,1184.00942 647.461599,1184.28953 647.104725,1184.41966 C646.714671,1184.56186 646.343908,1184.48502 646.046465,1184.18889 C645.175915,1183.32225 644.292575,1182.46708 643.453854,1181.57035 C642.719645,1180.78541 642.29087,1179.82857 642.111474,1178.76786 C642.055417,1178.43639 642.036128,1178.0987 642,1177.76388 C642.03151,1176.50648 642.393357,1175.36275 643.14714,1174.35816 C644.018472,1173.19692 645.165542,1172.43973 646.590444,1172.13621 C648.092043,1171.81639 649.506323,1172.06136 650.822842,1172.85465 Z"
                        id="link"
                    />
                </g>
            </g>
        </svg>
    );
};

Link.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

Link.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default Link;
