import React from 'react';
import { IconProps } from '../../types';

const JsonFile: React.FC<IconProps> = (props: IconProps) => {
    const { className, style, title } = props;
    return (
        <svg
            className={className}
            style={style}
            fill="currentColor"
            width="26px"
            height="20px"
            viewBox="0 0 26 20"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
        >
            <title>{title}</title>
            <g id="marketplace" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="marketplace/functions-source-code/download"
                    transform="translate(-180.000000, -573.000000)"
                    fill="#F1B92D"
                >
                    <path
                        d="M200.997,573.581741 C201.940333,573.952852 202.339222,574.71063 202.345889,575.69137 C202.354407,576.954333 202.33737,578.217667 202.353296,579.480259 C202.373667,581.092852 203.108481,581.888407 204.71737,581.896185 C205.444407,581.899889 205.652185,582.149519 205.558111,582.807296 C205.481815,583.339148 205.866259,584.040259 204.771444,584.058037 C203.028481,584.086185 202.364037,584.863593 202.351444,586.608407 C202.342926,587.778778 202.363667,588.949889 202.345889,590.119889 C202.321074,591.723963 201.548852,592.495815 199.958852,592.538407 C199.681815,592.545815 199.398852,592.504704 199.127741,592.546556 C198.262185,592.679889 198.061074,592.311 198.040704,591.476926 C198.018111,590.564333 198.299593,590.240259 199.175519,590.400259 C200.015148,590.553593 200.281074,590.217296 200.228111,589.368037 C200.151815,588.14063 200.247,586.903593 200.197741,585.673222 C200.149963,584.478037 200.520704,583.561 201.845889,582.97063 C200.506259,582.408037 200.14737,581.464333 200.19663,580.240259 C200.249963,578.917667 200.190333,577.59137 200.217741,576.267296 C200.228111,575.773593 200.121444,575.492481 199.565889,575.575815 C199.475519,575.589519 199.379593,575.588407 199.288852,575.575444 C198.908111,575.522481 198.365148,575.779519 198.17737,575.403222 C197.920333,574.887296 198.068111,574.258037 198.110333,573.677296 C198.123296,573.497296 198.262556,573.413963 198.431815,573.419519 C199.289222,573.448407 200.167741,573.255815 200.997,573.581741 Z M187.509222,574.487815 C187.505148,575.380778 187.268852,575.739667 186.37737,575.578185 C185.582926,575.434111 185.295889,575.721889 185.354407,576.56263 C185.435148,577.727444 185.346259,578.903 185.382185,580.072259 C185.420333,581.321889 185.140704,582.379296 183.728481,582.971519 C185.191815,583.594481 185.422926,584.711148 185.382926,585.993 C185.344407,587.22337 185.402185,588.457444 185.362556,589.687815 C185.344407,590.255222 185.514778,590.419667 186.087741,590.415593 C187.52663,590.405593 187.712926,590.67263 187.475519,592.104852 C187.435519,592.345593 187.383296,592.531519 187.106259,592.527074 C186.251444,592.513741 185.383667,592.667074 184.562926,592.259296 C183.682185,591.821889 183.184778,591.169667 183.199593,590.152259 C183.217741,588.920407 183.212185,587.688185 183.201444,586.456704 C183.187741,584.89337 182.482185,584.050778 180.917,584.068185 C179.726259,584.081519 180.103296,583.344111 180.018481,582.744852 C179.912185,581.996333 180.274778,581.907074 180.912185,581.898556 C182.405148,581.877444 183.175519,581.075593 183.198481,579.597074 C183.218481,578.334481 183.192926,577.071519 183.20663,575.808926 C183.223296,574.260037 184.065889,573.43337 185.626259,573.409667 C185.872926,573.405963 186.124778,573.442259 186.364778,573.40337 C187.241074,573.260407 187.513667,573.575963 187.509222,574.487815 Z M192.838852,586.186074 C193.440333,586.22163 193.808481,586.61163 193.808852,587.217926 C193.809222,587.876815 193.409222,588.216444 192.762926,588.269037 C192.122185,588.180519 191.705519,587.837556 191.741074,587.180519 C191.775519,586.543111 192.181815,586.147185 192.838852,586.186074 Z M188.569259,586.184185 C189.213333,586.20937 189.531481,586.630481 189.575926,587.235667 C189.5,587.912333 189.120741,588.275296 188.484815,588.252704 C187.842963,588.229741 187.457407,587.810852 187.487037,587.180852 C187.516296,586.557519 187.925556,586.159 188.569259,586.184185 Z M196.995481,586.183037 C197.629556,586.158963 197.99437,586.553778 198.07437,587.20637 C198.035111,587.829704 197.716222,588.239704 197.061037,588.252296 C196.419556,588.264889 196.010296,587.893037 195.989185,587.254148 C195.968074,586.613037 196.369556,586.206741 196.995481,586.183037 Z"
                        id="config-json"
                    />
                </g>
            </g>
        </svg>
    );
};

JsonFile.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default JsonFile;
