import React from 'react';
import PropTypes from 'prop-types';

const InteractiveExamples = (props) => {
    const { className, style, title } = props;

    return (
        <svg
            width="40px"
            height="34px"
            viewBox="0 0 40 34"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            className={className}
            style={style}
        >
            <title>{title}</title>
            <g id="pages" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="rainbow-GlobalSearch-interactive-examples-results"
                    transform="translate(-136.000000, -153.000000)"
                    fill="currentColor"
                    fillRule="nonzero"
                >
                    <g id="Group" transform="translate(118.000000, 136.000000)">
                        <path
                            d="M57,25.1585644 C57.5522847,25.1585644 58,25.6062797 58,26.1585644 L58,49.2773577 C58,49.8296425 57.5522847,50.2773577 57,50.2773577 L27.1589359,50.2773577 C26.6066512,50.2773577 26.1589359,49.8296425 26.1589359,49.2773577 L26.1589359,26.1585644 C26.1589359,25.6062797 26.6066512,25.1585644 27.1589359,25.1585644 L57,25.1585644 Z M52.9207178,21.0792822 C53.4730025,21.0792822 53.9207178,21.5269975 53.9207178,22.0792822 L53.9207178,23.4194824 L25.2895808,23.4194824 C24.8088347,23.4194824 24.419854,23.8088347 24.419854,24.2892092 L24.419854,46.1980754 L23.0796538,46.1980754 C22.5273691,46.1980754 22.0796538,45.7503602 22.0796538,45.1980754 L22.0796538,22.0792822 C22.0796538,21.5269975 22.5273691,21.0792822 23.0796538,21.0792822 L52.9207178,21.0792822 Z M48.841064,17 C49.3933487,17 49.841064,17.4477153 49.841064,18 L49.841064,19.3402003 L21.209927,19.3402003 C20.729181,19.3402003 20.3405718,19.7295525 20.3405718,20.2095554 L20.3405718,42.1187933 L19,42.1187933 C18.4477153,42.1187933 18,41.671078 18,41.1187933 L18,18 C18,17.4477153 18.4477153,17 19,17 L48.841064,17 Z M45.6836415,34.8986578 C45.2563905,34.8986578 44.7154333,35.4073249 44.7154333,36.0595109 C44.7154333,36.3297205 44.8152105,36.5684956 44.9718408,36.6796276 L44.9718408,36.6796276 L47.477641,38.4926669 L44.9718408,40.3057062 C44.8152105,40.4168382 44.7154333,40.6556132 44.7154333,40.9258228 C44.7154333,41.5776914 45.2563905,42.086676 45.6836415,42.086676 C45.7834187,42.086676 45.8829116,42.0708 45.9542623,42.007296 L45.9542623,42.007296 L49.5704035,39.3833106 C49.8981616,39.1445355 50.0118677,38.7631939 50.0118677,38.4926669 C50.0118677,38.2224574 49.8981616,37.8407983 49.5704035,37.6023407 L49.5704035,37.6023407 L45.9542623,34.9780378 C45.8829116,34.9145338 45.7834187,34.8986578 45.6836415,34.8986578 Z M39.8579215,34.8986578 C39.7581443,34.8986578 39.6586514,34.9145338 39.5873008,34.9780378 L39.5873008,34.9780378 L35.9711596,37.6023407 L35.858088,37.6979775 C35.6167516,37.9344717 35.5296953,38.2562336 35.5296953,38.4926669 C35.5296953,38.7631939 35.6434015,39.1445355 35.9711596,39.3833106 L35.9711596,39.3833106 L39.5873008,42.007296 L39.6456551,42.0464899 C39.7084156,42.0777458 39.7830886,42.086676 39.8579215,42.086676 C40.2851725,42.086676 40.8261298,41.5776914 40.8261298,40.9258228 C40.8261298,40.6556132 40.7263526,40.4168382 40.5697223,40.3057062 L40.5697223,40.3057062 L38.063922,38.4926669 L40.5697223,36.6796276 L40.6332436,36.6244652 C40.7528241,36.4996326 40.8261298,36.2911191 40.8261298,36.0595109 C40.8261298,35.4073249 40.2851725,34.8986578 39.8579215,34.8986578 Z"
                            id="interactive-example"
                        />
                    </g>
                </g>
            </g>
        </svg>
    );
};

InteractiveExamples.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

InteractiveExamples.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default InteractiveExamples;
