import React from 'react';
import PropTypes from 'prop-types';

const InfoCircleFilled = (props) => {
    const { className, style, title } = props;

    return (
        <svg className={className} style={style} width="28px" height="28px" viewBox="0 0 28 28">
            <title>{title}</title>
            <g id="notifications" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <path
                    d="M13.9994074,0 C21.7303704,0 28,6.26844444 28,13.9994074 C28,21.7303704 21.7303704,28 13.9994074,28 C6.26844444,28 0,21.7303704 0,13.9994074 C0,6.26844444 6.26844444,0 13.9994074,0 Z M13.2503704,11.1988148 C12.7703704,11.1988148 12.2607407,11.2841481 11.7214815,11.4571852 C11.1822222,11.6278519 10.6168889,11.8340741 10.0266667,12.0746667 L10.0266667,12.0746667 L9.78844444,13.056 C9.96148148,12.9896296 10.1724444,12.9220741 10.4154074,12.8474074 C10.6607407,12.7751111 10.9001481,12.7407407 11.1324444,12.7407407 C11.6077037,12.7407407 11.9265185,12.818963 12.096,12.978963 C12.2631111,13.138963 12.3472593,13.4234074 12.3472593,13.8287407 C12.3472593,14.0562963 12.3211852,14.3063704 12.2666667,14.578963 C12.2121481,14.8491852 12.1434074,15.1395556 12.064,15.4453333 L12.064,15.4453333 L11.1620741,18.6311111 C11.0826667,18.9665185 11.0245926,19.2651852 10.9878519,19.5306667 C10.9522963,19.7961481 10.9345185,20.0568889 10.9345185,20.3117037 C10.9345185,20.9671111 11.1751111,21.5063704 11.6586667,21.9318519 C12.1422222,22.3573333 12.8213333,22.5706667 13.6936296,22.5706667 C14.2613333,22.5706667 14.7602963,22.496 15.1893333,22.3466667 C15.6195556,22.1973333 16.1931852,21.9816296 16.9137778,21.6971852 L16.9137778,21.6971852 L17.1543704,20.717037 C17.0287407,20.7751111 16.8296296,20.8426667 16.5546667,20.9185185 C16.2773333,20.9943704 16.032,21.0334815 15.8127407,21.0334815 C15.3481481,21.0334815 15.0198519,20.9564444 14.8325926,20.8035556 C14.642963,20.6506667 14.5493333,20.3626667 14.5493333,19.9407407 C14.5493333,19.7736296 14.5777778,19.5247407 14.6358519,19.1988148 C14.6951111,18.8728889 14.7602963,18.5813333 14.8337778,18.3265185 L14.8337778,18.3265185 L15.730963,15.1502222 C15.8186667,14.8574815 15.8791111,14.5386667 15.9111111,14.189037 C15.9431111,13.8405926 15.9597037,13.5964444 15.9597037,13.4577778 C15.9597037,12.7893333 15.7238519,12.2453333 15.2557037,11.826963 C14.7851852,11.4097778 14.1167407,11.1988148 13.2503704,11.1988148 Z M15.2438519,5.3842963 C14.656,5.3842963 14.1487407,5.57985185 13.7268148,5.97333333 C13.3084444,6.36562963 13.0951111,6.8397037 13.0951111,7.39081481 C13.0951111,7.94311111 13.3072593,8.416 13.7268148,8.80474074 C14.1487407,9.19348148 14.656,9.38785185 15.2438519,9.38785185 C15.8328889,9.38785185 16.3365926,9.19348148 16.754963,8.80474074 C17.1733333,8.416 17.3831111,7.9442963 17.3831111,7.39081481 C17.3831111,6.8397037 17.1733333,6.36562963 16.754963,5.97333333 C16.3377778,5.57985185 15.8328889,5.3842963 15.2438519,5.3842963 Z"
                    id="info"
                    fill="currentColor"
                    fillRule="nonzero"
                />
            </g>
        </svg>
    );
};

InfoCircleFilled.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

InfoCircleFilled.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default InfoCircleFilled;
