import React from 'react';
import PropTypes from 'prop-types';

const Globe = (props) => {
    const { className, style, title } = props;
    return (
        <svg
            className={className}
            style={style}
            width="16px"
            height="16px"
            viewBox="0 0 16 16"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
        >
            <title>{title}</title>
            <g id="webhook-solution" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="webhooks-logs"
                    transform="translate(-182.000000, -260.000000)"
                    fill="currentColor"
                    fillRule="nonzero"
                >
                    <g id="Group-14" transform="translate(174.000000, 254.000000)">
                        <path
                            d="M16.0332878,6.00251278 L16.0479236,6.00293599 L16.0479236,6.00293599 L16.054,6.003 L16.3743413,6.01427383 C17.5000678,6.07724937 18.5772629,6.37656237 19.5811257,6.9059861 C20.6150228,7.45123948 21.5336532,8.2351162 22.2414738,9.17552181 C22.2721668,9.20409891 22.298613,9.23862425 22.318356,9.27832526 L22.2807186,9.22811496 C23.3090376,10.6177809 23.8525746,12.2678946 23.8525746,14.0000044 C23.8525746,15.7120209 23.3218432,17.3437373 22.3171338,18.7229878 L22.3289641,18.6993846 C22.3083558,18.7493705 22.277576,18.7920964 22.240006,18.8261542 L22.2806834,18.7726345 C21.5677936,19.7363088 20.6342727,20.539165 19.5810552,21.0944107 C18.4825728,21.6735288 17.2960857,21.9772176 16.0542756,21.9972459 C16.0525813,21.9968368 16.0502526,21.9969565 16.0479236,21.9970728 L16.0334288,21.9975313 L16.0334288,21.9975313 L15.9815641,21.9993872 L15.9815641,21.9993872 L15.9262873,22 C15.8879872,22 15.8528259,21.9991889 15.81904,21.997496 L15.8049684,21.9970728 L15.8049684,21.9970728 L15.796,21.996 L15.4786531,21.9857885 C14.3529047,21.9229778 13.2755842,21.6236997 12.2716252,21.0943401 C11.2364463,20.5485021 10.3168154,19.7634266 9.60851643,18.8215059 C9.57915538,18.7942367 9.55403834,18.7612007 9.53502343,18.723473 L9.57153855,18.7719291 C8.54343119,17.3820163 8,15.7319379 8,14.0000044 C8,12.2880336 8.53113134,10.6561213 9.53664638,9.27624337 L9.52389265,9.30386875 C9.54378357,9.25314243 9.5741198,9.20962528 9.61147151,9.17480675 L9.57446572,9.22476458 C10.2878139,8.26172508 11.221229,7.45946843 12.2738823,6.90471648 C13.3714218,6.3262963 14.5565574,6.02290393 15.7966948,6.00278514 C15.7995935,6.0032095 15.8022808,6.0030705 15.8049684,6.00293599 L15.8192163,6.00251278 L15.8192163,6.00251278 C15.8872113,5.99916241 15.965328,5.99916241 16.0332878,6.00251278 Z M15.573,17.697 L15.9267105,17.6914501 C14.9312242,17.6923595 13.9218805,17.7960973 12.9207686,18.0000853 C13.527912,19.8322553 14.5122383,21.0377801 15.5733223,21.2582484 L15.573,17.697 Z M16.2783932,17.6952897 L16.2782252,21.2585685 C17.3413654,21.0388556 18.3271896,19.8310576 18.9351654,17.9973548 L19.307876,18.076814 C18.3055177,17.846512 17.2881422,17.71847 16.2783932,17.6952897 Z M12.2293407,18.1596787 L12.5467794,18.0810461 C11.8441502,18.2421709 11.1337856,18.4559493 10.4291711,18.7180986 C11.3293688,19.791975 12.4907224,20.5632758 13.7857075,20.9679957 C13.7177955,20.8969675 13.6511142,20.8225798 13.5855374,20.7447371 C13.0344111,20.0905927 12.5687823,19.2018239 12.2293407,18.1596787 Z M19.6255359,18.1531633 L19.7252272,17.8318838 C19.3802089,19.0148844 18.8765943,20.0217257 18.2688358,20.7434675 C18.2029063,20.821764 18.1358606,20.8965688 18.0677825,20.9678345 C19.3630843,20.5626992 20.5240678,19.7915319 21.4248575,18.7193506 L21.8628737,18.889016 C21.1241663,18.5881218 20.3727726,18.3410292 19.6255359,18.1531633 Z M11.6112811,14.3528835 L8.71363025,14.3530007 C8.77774338,15.7148521 9.2128316,17.0111276 9.98377752,18.1351345 L9.72361041,18.2349871 C10.4882186,17.9274212 11.2633015,17.6738689 12.0326632,17.4795074 L12.1294634,17.8361159 C11.8177431,16.7712994 11.6400624,15.5738814 11.6112811,14.3528835 Z M23.1389841,14.3522595 L20.24,14.352 L20.2395127,14.4458884 C20.208115,15.4991488 20.0659063,16.5332352 19.8224677,17.4778064 L19.4657316,17.3893871 C20.2661639,17.5729097 21.0733489,17.8224365 21.8689487,18.1322352 L21.7136585,18.353132 C22.5815786,17.1802175 23.0708397,15.803642 23.1389841,14.3522595 Z M15.573,14.352 L12.317,14.352 L12.3187663,14.4245281 C12.3487768,15.4349181 12.4855406,16.4243073 12.7197436,17.3242874 L12.3892058,17.3935839 C13.4463173,17.1512611 14.515825,17.0160201 15.5736435,16.9905539 L15.573,14.352 Z M19.5364964,14.3528193 L16.278,14.352 L16.278,16.991 L16.4316717,16.9939685 C17.3327611,17.0227764 18.238345,17.1308682 19.1340668,17.3168539 L19.0481688,17.6342821 C19.3407063,16.6326453 19.5080514,15.505003 19.5364964,14.3528193 Z M9.98680593,9.86455897 L10.1412438,9.64454922 C9.27192911,10.8183443 8.78183793,12.1957511 8.71359894,13.6477373 L11.612,13.647 L11.6137946,13.5530906 C11.6453308,12.4971681 11.7881997,11.460821 12.0327947,10.5146108 L12.3896643,10.6036741 C11.5927081,10.420753 10.7856045,10.1724349 9.98680593,9.86455897 Z M12.7205536,10.6761677 L12.8071918,10.3589555 C12.5133819,11.3621604 12.3453353,12.4920875 12.3168205,13.647056 L15.573,13.647 L15.573,11.007 L15.4224342,11.0041789 C14.5243992,10.9732004 13.6188785,10.8632882 12.7205536,10.6761677 Z M21.8692348,9.86588792 L22.1256491,9.76636188 C21.3654763,10.0761388 20.5916164,10.3311671 19.8212955,10.5258039 L19.7252625,10.1689362 C20.0360648,11.2331656 20.2132515,12.4288689 20.2419965,13.6472569 L23.1389426,13.6469721 C23.074835,12.2854014 22.6398961,10.9895229 21.8692348,9.86588792 Z M19.1348963,10.681122 L19.4653084,10.6115034 C18.4125195,10.8531024 17.3421481,10.9867734 16.2785556,11.0097073 L16.278,13.647 L19.535,13.647 L19.5345658,13.5763347 C19.5046454,12.5682058 19.3683265,11.5803832 19.1348963,10.681122 Z M16.278134,6.74145083 L16.278,10.303 L16.4101109,10.3010377 C17.2523489,10.2748677 18.098149,10.1751362 18.9349422,10.0047437 C18.326668,8.16880145 17.3410018,6.96118076 16.278134,6.74145083 Z M12.920626,9.99557311 L12.5475905,9.91628245 C13.5525871,10.1473477 14.5687409,10.277179 15.5734782,10.303122 L15.5734375,6.74178046 C14.5128556,6.96214228 13.5287127,8.16695881 12.920626,9.99557311 Z M18.0680723,7.03252009 L18.1152877,7.08297119 C18.1671127,7.1388898 18.2183197,7.19688295 18.2688711,7.2569293 C18.8203494,7.91200181 19.2860979,8.80181478 19.6254269,9.84504136 L19.3078054,9.92400595 C20.0120827,9.76287161 20.7221503,9.54795876 21.4246182,9.28357779 C20.5241045,8.20902823 19.3629528,7.43753649 18.0680723,7.03252009 Z M13.7853005,7.0325561 L13.6536173,7.07484773 C12.4133069,7.48950472 11.3012241,8.24331723 10.4310372,9.27757274 L9.98829021,9.10707817 C10.7332176,9.40698241 11.4857714,9.65290729 12.2307951,9.84011644 L12.1302393,10.1608247 C12.4756456,8.97986963 12.9791896,7.97482698 13.5863485,7.25449587 C13.651601,7.17708167 13.7179455,7.10308643 13.7853005,7.0325561 Z"
                            id="globe"
                        />
                    </g>
                </g>
            </g>
        </svg>
    );
};

Globe.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

Globe.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default Globe;
