import React from 'react';
import PropTypes from 'prop-types';

const FunctionSymbol = (props) => {
    const { className, style, title } = props;
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="18"
            height="17"
            viewBox="0 0 18 17"
            className={className}
            style={style}
        >
            <title>{title}</title>
            <g fill="none" fillRule="evenodd">
                <g fill="currentColor">
                    <g>
                        <path
                            d="M24.576 22.873c.214.072.421.197.6.337.407.32.54.919.337 1.395-.093.218-.262.35-.485.41-.105.028-.217.043-.325.044-.32.002-.617-.062-.768-.387-.155-.334-.14-.662.083-.968.058-.078.128-.147.186-.226.095-.128.07-.211-.096-.247-.42-.093-.826-.064-1.184.207-.397.3-.628.72-.759 1.18-.217.767-.393 1.546-.584 2.32-.069.276-.129.555-.2.864h1.628l-.114.447h-1.608c-.11.56-.223 1.109-.327 1.659-.324 1.7-.652 3.398-1.278 5.022-.283.735-.608 1.45-1.031 2.116-.431.68-.976 1.236-1.754 1.51-.497.177-1.009.242-1.526.09-.628-.183-.986-.668-.936-1.25.027-.312.256-.612.568-.692.332-.085.67-.076.908.213.217.261.186.573.06.866-.177.41-.094.543.348.5.508-.05.85-.364 1.039-.798.225-.516.425-1.053.55-1.601.31-1.348.574-2.706.85-4.06.228-1.123.447-2.248.67-3.371.012-.059.019-.119.031-.199h-1.77c.033-.139.047-.26.095-.368.02-.045.109-.083.167-.084.495-.007.989-.009 1.483 0 .127.001.176-.04.212-.161.3-1.02.654-2.017 1.203-2.934.322-.539.703-1.029 1.22-1.396.763-.543 1.598-.74 2.507-.438zm2.251 4.645c.397.054.722.242.86.623.164.456.274.931.408 1.398l.038.137c.062-.074.107-.127.15-.181.358-.448.71-.9 1.074-1.343.267-.326.565-.617 1.018-.648.138-.009.283-.002.417.03.415.102.627.535.488.973-.137.435-.572.653-1.007.49-.134-.05-.253-.144-.375-.222-.198-.126-.3-.134-.481.016-.46.383-.819.853-1.1 1.379-.05.096-.056.24-.032.352.186.875.378 1.75.584 2.621.047.198.138.392.24.57.122.21.311.254.516.124.142-.09.289-.199.382-.334.296-.43.568-.878.849-1.319.016-.025.03-.051.05-.089l.335.181c-.36.761-.725 1.496-1.382 2.033-.365.3-.787.46-1.259.479-.53.021-.93-.203-1.2-.658-.256-.434-.332-.925-.437-1.407-.055-.25-.096-.501-.15-.791-.06.076-.098.124-.135.175-.436.588-.86 1.184-1.312 1.76-.193.247-.422.475-.668.668-.284.223-.627.3-.986.192-.398-.12-.63-.533-.556-.973.061-.367.396-.645.762-.634.194.006.345.092.476.235.3.324.378.322.674-.013.476-.54.948-1.083 1.424-1.624.105-.12.176-.25.14-.416-.17-.767-.336-1.535-.516-2.3-.042-.18-.121-.357-.205-.525-.109-.22-.218-.253-.425-.116-.15.1-.301.216-.41.358-.336.432-.652.88-.995 1.35l-.339-.14c.41-.7.826-1.372 1.427-1.906.475-.422 1.03-.59 1.658-.505z"
                            transform="translate(-1239 -306) translate(1225 284)"
                        />
                    </g>
                </g>
            </g>
        </svg>
    );
};

FunctionSymbol.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};
FunctionSymbol.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default FunctionSymbol;
