import React from 'react';
import PropTypes from 'prop-types';

const ExportBorder = (props) => {
    const { className, style, title } = props;

    return (
        <svg className={className} style={style} width="32px" height="32px" viewBox="0 0 32 32">
            <title>{title}</title>
            <g id="modules" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <path
                    d="M11.3516942,11.2564347 C11.9633943,11.2564347 12.4617991,11.7548395 12.4617991,12.3665396 C12.4617991,12.869461 12.1229741,13.302746 11.6199373,13.4391821 L11.4908581,13.4669753 L11.3516942,13.4766444 L3.55052431,13.4766444 C2.90368478,13.4766444 2.35354722,13.9490783 2.24220779,14.5549306 L2.22589191,14.6777795 L2.22020972,14.806959 L2.22020972,28.4494757 C2.22020972,29.0963152 2.69264359,29.6464528 3.29849586,29.7577922 L3.42134477,29.7741081 L3.55052431,29.7797903 L28.4494757,29.7797903 C29.0963152,29.7797903 29.6464528,29.3073564 29.7577922,28.7015041 L29.7741081,28.5786552 L29.7797903,28.4494757 L29.7797903,14.806959 C29.7797903,14.1601195 29.3073564,13.6099819 28.7015041,13.4986425 L28.5786552,13.4823266 L28.4494757,13.4766444 L21.193041,13.4766444 C20.5813409,13.4766444 20.0829361,12.9782396 20.0829361,12.3665396 C20.0829361,11.8636181 20.4217611,11.4303332 20.9247979,11.293897 L21.0538772,11.2661038 L21.193041,11.2564347 L28.4494757,11.2564347 C30.261242,11.2564347 31.7770034,12.6330262 31.9781131,14.420771 L31.9945836,14.6138444 L32,14.806959 L32,28.4494757 C32,30.261242 30.6234085,31.7770034 28.8356637,31.9781131 L28.6425903,31.9945836 L28.4494757,32 L3.55052431,32 C1.73875802,32 0.222996589,30.6234085 0.0218869397,28.8356637 L0.00541643598,28.6425903 L0,28.4494757 L0,14.806959 C0,12.9951927 1.37659154,11.4794313 3.16433631,11.2783216 L3.3574097,11.2618511 L3.55052431,11.2564347 L11.3516942,11.2564347 Z M16.3122021,21.4385129 C16.8151236,21.4385129 17.2484085,21.7773379 17.3848446,22.2803747 L17.4126378,22.4094539 L17.422307,22.5486177 L17.4206607,23.5043154 L17.4076697,23.643458 C17.3201391,24.1762311 16.8570337,24.5738799 16.3122021,24.5738799 C15.8092806,24.5738799 15.3759957,24.2350549 15.2395595,23.7320181 L15.2117663,23.6029389 L15.2020972,23.463775 L15.2037435,22.5080774 L15.2167345,22.3689347 C15.3042651,21.8361617 15.7673705,21.4385129 16.3122021,21.4385129 Z M16.3122021,0 C16.4968933,0 16.6779655,0.0476475997 16.8558325,0.150456674 L16.9886382,0.238023661 L17.0928289,0.329478068 L22.5205383,5.75965588 L22.6191146,5.8791099 C22.9307927,6.31941707 22.878729,6.90368761 22.4922569,7.29015968 C22.1355135,7.64690313 21.6102317,7.71870691 21.1585358,7.46183936 L21.047285,7.39074984 L20.9310033,7.29015968 L17.422,3.781 L17.4206607,18.8436862 L17.4076697,18.9828289 C17.3201391,19.5156019 16.8570337,19.9132507 16.3122021,19.9132507 C15.8092806,19.9132507 15.3759957,19.5744257 15.2395595,19.0713889 L15.2117663,18.9423097 L15.2020972,18.8031459 L15.202,3.78 L11.6626511,7.31844111 L11.5431971,7.41701735 C11.1028899,7.72869546 10.5186193,7.67663175 10.1321473,7.29015968 C9.77540383,6.93341623 9.70360004,6.40813444 9.9604676,5.95643854 L10.0315571,5.84518773 L10.1321473,5.72890609 L15.5591368,0.303914986 L15.6659157,0.214055235 C15.8561287,0.0744493745 16.0813381,0 16.3122021,0 Z"
                    id="export-border"
                    fill="currentColor"
                    fillRule="nonzero"
                />
            </g>
        </svg>
    );
};

ExportBorder.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

ExportBorder.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default ExportBorder;
