import React from 'react';
import PropTypes from 'prop-types';

const Docs = (props) => {
    const { className, style, title } = props;
    return (
        <svg className={className} style={style} width="22px" height="20px" viewBox="0 0 22 20">
            <title>{title}</title>
            <g id="new-layout" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="new-layout/projects"
                    transform="translate(-24.000000, -566.000000)"
                    fill="currentColor"
                >
                    <path
                        d="M33.9039722,583.963889 L35.7725833,583.963889 L35.7725833,583.101111 C35.7725833,578.911944 35.7709167,574.7225 35.7731389,570.533333 C35.77425,568.1025 36.5928611,567.056667 38.9300833,566.408333 C40.0086944,566.109167 41.0856389,565.835556 42.2020278,566.119167 C44.2470278,566.639167 45.5964722,568.245833 45.6334167,570.379722 C45.6903611,573.688333 45.6886944,576.999444 45.63675,580.308333 C45.6028611,582.478333 44.1239722,584.203611 42.0053611,584.628333 C39.9886944,585.0325 37.9648056,585.418611 35.9281389,585.695556 C35.0286944,585.818333 34.0778611,585.732222 33.1709167,585.599722 C31.3423056,585.331944 29.5214722,584.999444 27.70925,584.635278 C25.5195278,584.195556 24.0548056,582.446389 24.0306389,580.208611 C23.9959167,576.991667 23.9834167,573.773889 24.0325833,570.5575 C24.0806389,567.421944 26.7234167,565.435556 29.7759167,566.168333 C30.3148056,566.297778 30.8564722,566.421944 31.3861944,566.583333 C32.83925,567.025556 33.8498056,568.226111 33.8659167,569.743889 C33.9125833,574.163889 33.8959167,578.584722 33.9039722,583.005 C33.90425,583.301944 33.9039722,583.599167 33.9039722,583.963889"
                        id="docs"
                    />
                </g>
            </g>
        </svg>
    );
};

Docs.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

Docs.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default Docs;
