import React from 'react';
import PropTypes from 'prop-types';

export default function CampaignIcon(props) {
    const { className, style, title } = props;
    return (
        <svg
            className={className}
            width="25px"
            height="24px"
            viewBox="0 0 25 24"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            style={style}
        >
            <title>{title}</title>
            <g id="Dashboard" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="dashboard-copy-2"
                    transform="translate(-39.000000, -228.000000)"
                    fill="currentColor"
                >
                    <g id="Group-13" transform="translate(8.000000, 10.000000)">
                        <g id="Group-4" transform="translate(0.000000, 207.000000)">
                            <path
                                d="M55.2799361,12.9433742 C55.307837,13.1085769 55.3278449,13.2776343 55.3280284,13.4446726 C55.3302311,18.8133936 55.3355543,24.1819309 55.325275,29.5506519 C55.3228888,30.727813 54.6339935,31.585215 53.5034563,31.9044234 C52.9079923,32.072563 52.3642918,31.9572883 51.8396814,31.6320225 C50.1891228,30.6092341 48.5413176,29.5816733 46.8703839,28.5930269 C45.4579008,27.7571011 43.9518027,27.1194187 42.3735662,26.6594209 C42.2303905,26.6177531 42.0842779,26.5859975 41.8783252,26.534234 C42.0303116,27.8949536 42.3218027,29.1539818 43.2843838,30.1229875 C43.9125212,30.7551632 44.1173725,31.4427736 43.8950831,32.2902635 C43.7906383,32.6887691 43.7273106,33.0981047 43.637734,33.5008322 C43.3229311,34.9155181 41.9078781,35.4605035 40.7314512,34.6042028 C39.3055683,33.5665462 38.3385818,32.1731531 37.6788723,30.5549008 C37.1843655,29.3423129 36.8816774,28.0808985 36.809906,26.7726766 C36.789531,26.4048252 36.6513114,26.2950572 36.2948407,26.2572441 C33.7062978,25.9819062 31.8130747,23.7520368 31.951845,21.1710198 C32.0887797,18.6248789 34.2090647,16.6233563 36.7981583,16.6020635 C37.6698779,16.5947212 38.5452687,16.5512178 39.4127665,16.6117921 C40.7699985,16.7063248 42.047199,16.3907876 43.231886,15.8179013 C45.3071992,14.8140195 47.3318502,13.7051422 49.3750406,12.6353629 C50.2552039,12.1744473 51.1168278,11.6770036 52.0081882,11.2394 C53.3654202,10.5728988 55.0268088,11.451043 55.2799361,12.9433742 Z M39.8929557,26.30552 L38.6899129,26.30552 C38.8808138,28.943073 39.6737868,31.2162623 41.7758995,33.0193581 C41.876306,32.5400867 41.9695538,32.160304 42.0270076,31.7751982 C42.0413252,31.679197 41.9638634,31.5435472 41.8886044,31.4638828 C40.8882102,30.4065855 40.3588273,29.126448 40.1055165,27.7161676 C40.0229152,27.2561698 39.9654613,26.7915831 39.8929557,26.30552 L39.8929557,26.30552 Z M52.5039615,13.1294475 C51.2682453,13.8001705 50.037118,14.4798879 48.8148015,15.1748406 C46.6724894,16.3927517 44.51329,17.572299 42.1182178,18.2321921 C41.8482032,18.3067169 41.8494881,18.4676977 41.8496717,18.6745682 C41.8513237,20.5096032 41.855362,22.3446382 41.843041,24.1794896 C41.841228,24.4660245 41.9515467,24.5467903 42.2123834,24.6376518 C42.3834141,24.6972166 42.5553253,24.7552756 42.7277147,24.8125706 L43.7645726,25.1531068 C44.6280399,25.4391373 45.4833511,25.7431562 46.2802248,26.1578838 C48.4184985,27.2706159 50.4563657,28.5760844 52.5439773,29.7873874 C52.7245989,29.8921993 53.0355471,30.0074741 53.1537588,29.9259741 C53.3073974,29.8202444 53.3947712,29.5223288 53.3960562,29.3064639 C53.4064578,27.5735487 53.4074776,25.8405519 53.4070017,24.1074735 L53.4061519,21.5077947 L53.4101902,21.5077947 L53.409823,13.6632358 C53.4094559,12.9339576 53.1566958,12.775363 52.5039615,13.1294475 Z M37.1244703,18.5267852 C36.8649185,18.527703 36.6016955,18.5209113 36.3469163,18.5601929 C34.990602,18.7698168 33.9566166,19.9014553 33.8769522,21.2452876 C33.7947179,22.6320726 34.6623993,24.0063755 36.0045795,24.2299499 C37.0883093,24.4102568 38.2054842,24.388949 39.3350662,24.4159402 L39.9007937,24.4346177 L39.9007937,18.5253167 C38.9523465,18.5253167 38.0384084,18.523114 37.1244703,18.5267852 Z"
                                id="campaign"
                            />
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
}

CampaignIcon.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};
CampaignIcon.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};
