import React from 'react';
import PropTypes from 'prop-types';

const AppsBorder = (props) => {
    const { className, style, title } = props;
    return (
        <svg className={className} style={style} width="24px" height="25px" viewBox="0 0 24 25">
            <title>{title}</title>
            <g id="new-layout" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="new-layout/marketplace"
                    transform="translate(-18.000000, -163.000000)"
                    fill="currentColor"
                    fillRule="nonzero"
                >
                    <path
                        d="M39.8181679,176.59089 C40.9691391,176.59089 41.9144844,177.486147 41.9945126,178.617102 L42,178.772723 L42,185.318168 C42,186.469188 41.1046969,187.414489 39.973782,187.494513 L39.8181679,187.5 L33.2727226,187.5 C32.1217025,187.5 31.1764019,186.604697 31.0963777,185.473782 L31.0908905,185.318168 L31.0908905,178.772723 C31.0908905,177.621703 31.9861468,176.676402 33.1171024,176.596378 L33.2727226,176.59089 L39.8181679,176.59089 Z M26.7272774,176.59089 C27.8782486,176.59089 28.8235939,177.486147 28.9036221,178.617102 L28.9091095,178.772723 L28.9091095,185.318168 C28.9091095,186.469188 28.0138064,187.414489 26.8828915,187.494513 L26.7272774,187.5 L20.1818321,187.5 C19.030812,187.5 18.0855114,186.604697 18.0054872,185.473782 L18,185.318168 L18,178.772723 C18,177.621703 18.8952563,176.676402 20.0262119,176.596378 L20.1818321,176.59089 L26.7272774,176.59089 Z M39.8181679,177.99089 L33.2727226,177.99089 C32.8784271,177.99089 32.5500505,178.286409 32.4980593,178.66698 L32.4908905,178.772723 L32.4908905,185.318168 C32.4908905,185.712437 32.7864282,186.040836 33.1669847,186.092831 L33.2727226,186.1 L39.8181679,186.1 C40.2124373,186.1 40.5408356,185.804462 40.5928307,185.423906 L40.6,185.318168 L40.6,178.772723 C40.6,178.378448 40.3044575,178.050054 39.9239046,177.99806 L39.8181679,177.99089 Z M26.7272774,177.99089 L20.1818321,177.99089 C19.7875366,177.99089 19.45916,178.286409 19.4071688,178.66698 L19.4,178.772723 L19.4,185.318168 C19.4,185.712437 19.6955377,186.040836 20.0760942,186.092831 L20.1818321,186.1 L26.7272774,186.1 C27.1215468,186.1 27.4499451,185.804462 27.5019402,185.423906 L27.5091095,185.318168 L27.5091095,178.772723 C27.5091095,178.378448 27.213567,178.050054 26.8330141,177.99806 L26.7272774,177.99089 Z M26.7272774,163.5 C27.8782486,163.5 28.8235939,164.395256 28.9036221,165.526212 L28.9091095,165.681832 L28.9091095,172.227277 C28.9091095,173.378297 28.0138064,174.323598 26.8828915,174.403622 L26.7272774,174.40911 L20.1818321,174.40911 C19.030812,174.40911 18.0855114,173.513806 18.0054872,172.382891 L18,172.227277 L18,165.681832 C18,164.530812 18.8952563,163.585511 20.0262119,163.505487 L20.1818321,163.5 L26.7272774,163.5 Z M39.8181679,163.5 C40.9691391,163.5 41.9144844,164.395256 41.9945126,165.526212 L42,165.681832 L42,172.227277 C42,173.378297 41.1046969,174.323598 39.973782,174.403622 L39.8181679,174.40911 L33.2727226,174.40911 C32.1217025,174.40911 31.1764019,173.513806 31.0963777,172.382891 L31.0908905,172.227277 L31.0908905,165.681832 C31.0908905,164.530812 31.9861468,163.585511 33.1171024,163.505487 L33.2727226,163.5 L39.8181679,163.5 Z M26.7272774,164.9 L20.1818321,164.9 C19.7875366,164.9 19.45916,165.195519 19.4071688,165.576089 L19.4,165.681832 L19.4,172.227277 C19.4,172.621547 19.6955377,172.949945 20.0760942,173.00194 L20.1818321,173.00911 L26.7272774,173.00911 C27.1215468,173.00911 27.4499451,172.713572 27.5019402,172.333015 L27.5091095,172.227277 L27.5091095,165.681832 C27.5091095,165.287557 27.213567,164.959164 26.8330141,164.907169 L26.7272774,164.9 Z M39.8181679,164.9 L33.2727226,164.9 C32.8784271,164.9 32.5500505,165.195519 32.4980593,165.576089 L32.4908905,165.681832 L32.4908905,172.227277 C32.4908905,172.621547 32.7864282,172.949945 33.1669847,173.00194 L33.2727226,173.00911 L39.8181679,173.00911 C40.2124373,173.00911 40.5408356,172.713572 40.5928307,172.333015 L40.6,172.227277 L40.6,165.681832 C40.6,165.287557 40.3044575,164.959164 39.9239046,164.907169 L39.8181679,164.9 Z"
                        id="apps-border"
                    />
                </g>
            </g>
        </svg>
    );
};

AppsBorder.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
    title: PropTypes.string,
};

AppsBorder.defaultProps = {
    className: undefined,
    style: undefined,
    title: undefined,
};

export default AppsBorder;
